/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.DefaultRowSorter;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.PopupMenu;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.gui.window.ImageDetailsWindow;
import org.openslx.dozmod.gui.window.ImageListWindow;
import org.openslx.dozmod.gui.window.LectureDetailsWindow;
import org.openslx.dozmod.gui.window.layout.LectureListWindowLayout;
import org.openslx.dozmod.gui.wizard.LectureWizard;
import org.openslx.dozmod.permissions.LecturePerms;
import org.openslx.dozmod.thrift.ImageLocalDetailsActions;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.cache.LectureCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class LectureListWindow
extends LectureListWindowLayout {
    private static final Logger LOGGER = Logger.getLogger(LectureListWindow.class);
    public final LectureListWindow me = this;
    private Pattern searchFieldPattern = null;
    private final RowFilter<ListTable.ListModel<LectureSummary>, Integer> filterSearchTerm = new RowFilter<ListTable.ListModel<LectureSummary>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends ListTable.ListModel<LectureSummary>, ? extends Integer> entry) {
            LectureSummary lecture = (LectureSummary)LectureListWindow.this.tblLectures.getModelRow(entry.getIdentifier());
            if (LectureListWindow.this.searchFieldPattern.matcher(lecture.lectureName).find()) {
                return true;
            }
            UserInfo user = UserCache.find(lecture.ownerId);
            if (user == null) {
                return false;
            }
            if (LectureListWindow.this.searchFieldPattern.matcher(user.firstName).find()) {
                return true;
            }
            if (LectureListWindow.this.searchFieldPattern.matcher(user.lastName).find()) {
                return true;
            }
            return LectureListWindow.this.searchFieldPattern.matcher(user.eMail).find();
        }
    };
    private JMenuItem popupItemNew = new JMenuItem("Neu");
    private JMenuItem popupItemEdit = new JMenuItem("Detailansicht");
    private JMenuItem popupItemLinked = new JMenuItem("VM-Details anzeigen");
    private JMenuItem popupItemDownload = new JMenuItem("Verlinkte VM herunterladen");
    private JMenuItem popupItemDelete = new JMenuItem("L\u00f6schen");

    public LectureListWindow() {
        this.tblLectures.setSelectionMode(2);
        this.txtSearch.getDocument().addDocumentListener(new TextChangeListener(){

            @Override
            public void changed() {
                String str = LectureListWindow.this.txtSearch.getText();
                if (str == null || str.isEmpty()) {
                    LectureListWindow.this.searchFieldPattern = null;
                } else {
                    try {
                        LectureListWindow.this.searchFieldPattern = Pattern.compile(str, 2);
                        LectureListWindow.this.txtSearch.setForeground(UIManager.getColor("TextField.foreground"));
                    }
                    catch (PatternSyntaxException ex) {
                        LectureListWindow.this.txtSearch.setForeground(Color.RED);
                    }
                }
                LectureListWindow.this.applyFilterOnTable();
            }
        });
        this.cboFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureListWindow.this.txtSearch.setEnabled(true);
                LectureListWindow.this.applyFilterOnTable();
            }
        });
        this.btnNewLecture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new LectureWizard(SwingUtilities.getWindowAncestor(LectureListWindow.this.me), null, null).setVisible(true);
            }
        });
        this.btnEditLecture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureListWindow.this.openLectureDetails((LectureSummary)LectureListWindow.this.tblLectures.getSelectedItem());
            }
        });
        this.btnDeleteLecture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureListWindow.this.deleteLectures(LectureListWindow.this.tblLectures.getSelectedItems());
            }
        });
        this.btnSwitchView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.showPage(ImageListWindow.class);
            }
        });
        final PopupMenu pop = new PopupMenu(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDetailsRead image;
                LectureSummary lecture = (LectureSummary)LectureListWindow.this.tblLectures.getSelectedItem();
                if (lecture == null) {
                    return;
                }
                if (e.getSource().equals(LectureListWindow.this.popupItemNew) && Gui.showMessageBox(LectureListWindow.this.me, "Um eine Veranstaltung zu erstellen, m\u00fcssen Sie eine VM ausw\u00e4hlen. Zur VM-Auswahl wechseln?", MessageType.QUESTION_YESNO, LOGGER, null)) {
                    MainWindow.showPage(ImageListWindow.class);
                }
                if (e.getSource().equals(LectureListWindow.this.popupItemEdit)) {
                    LectureListWindow.this.openLectureDetails(lecture);
                }
                if (e.getSource().equals(LectureListWindow.this.popupItemDownload) && (image = ThriftActions.getImageDetails(JOptionPane.getFrameForComponent(LectureListWindow.this.me), lecture.imageBaseId)) != null) {
                    long versionSize = -1L;
                    for (ImageVersionDetails version : image.getVersions()) {
                        if (!version.versionId.equals(lecture.imageVersionId)) continue;
                        versionSize = version.fileSize;
                        break;
                    }
                    if (versionSize != -1L) {
                        ThriftActions.initDownload(JOptionPane.getFrameForComponent(LectureListWindow.this.me), lecture.imageVersionId, image.imageName, image.virtId, image.osId, versionSize, null);
                    }
                }
                if (e.getSource().equals(LectureListWindow.this.popupItemLinked)) {
                    ImageDetailsWindow.open(JOptionPane.getFrameForComponent(LectureListWindow.this.me), lecture.imageBaseId, null, new ImageLocalDetailsActions(JOptionPane.getFrameForComponent(LectureListWindow.this.me)));
                }
                if (e.getSource().equals(LectureListWindow.this.popupItemDelete)) {
                    LectureListWindow.this.deleteLectures(LectureListWindow.this.tblLectures.getSelectedItems());
                }
            }
        });
        pop.addMenuItem(this.popupItemNew);
        pop.addMenuItem(this.popupItemEdit);
        pop.addMenuItem(this.popupItemLinked);
        pop.addMenuItem(this.popupItemDownload);
        pop.addSeparator();
        pop.addMenuItem(this.popupItemDelete);
        this.tblLectures.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    if (!Session.canListImages()) {
                        Gui.showMessageBox("Ihnen fehlen die ben\u00f6tigten Berechtigungen.", MessageType.ERROR, LOGGER, null);
                        return;
                    }
                    LectureListWindow.this.openLectureDetails((LectureSummary)LectureListWindow.this.tblLectures.getSelectedItem());
                }
                this.processClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.processClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processClick(e);
            }

            private void processClick(MouseEvent e) {
                int mouseRowIndex = LectureListWindow.this.tblLectures.rowAtPoint(e.getPoint());
                boolean alreadySelectedRow = false;
                for (int i : LectureListWindow.this.tblLectures.getSelectedRows()) {
                    if (i != mouseRowIndex) continue;
                    alreadySelectedRow = true;
                    break;
                }
                if (mouseRowIndex >= 0 && mouseRowIndex < LectureListWindow.this.tblLectures.getRowCount() && SwingUtilities.isRightMouseButton(e)) {
                    if (!alreadySelectedRow) {
                        LectureListWindow.this.tblLectures.setRowSelectionInterval(mouseRowIndex, mouseRowIndex);
                    }
                    if (e.isPopupTrigger()) {
                        pop.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        this.tblLectures.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 116) {
                    LectureListWindow.this.refreshList(true);
                }
            }
        });
        this.tblLectures.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LectureSummary item = (LectureSummary)LectureListWindow.this.tblLectures.getSelectedItem();
                LectureListWindow.this.updateAvailableOptions(item);
            }
        });
        if (Session.canListImages()) {
            this.cboFilter.setSelectedItem((Object)FilterType.OWN);
        } else {
            this.cboFilter.setSelectedItem((Object)FilterType.ALL);
        }
        this.updateAvailableOptions(null);
        this.tblLectures.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "details");
        this.tblLectures.getActionMap().put("details", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LectureListWindow.this.btnEditLecture.doClick();
            }
        });
        this.tblLectures.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblLectures.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LectureListWindow.this.btnDeleteLecture.doClick();
            }
        });
    }

    private void updateAvailableOptions(LectureSummary lecture) {
        boolean admin = LecturePerms.canAdmin(lecture);
        boolean singleSelection = this.tblLectures.getSelectedRows().length <= 1;
        this.btnEditLecture.setEnabled(Session.canListImages() && singleSelection);
        this.btnDeleteLecture.setEnabled(admin || !singleSelection);
        this.popupItemDelete.setEnabled(admin || !singleSelection);
        this.popupItemLinked.setEnabled(Session.canListImages() && singleSelection);
        this.popupItemDownload.setEnabled(Session.canListImages() && singleSelection);
        this.popupItemNew.setEnabled(Session.canListImages() && singleSelection);
        this.popupItemEdit.setEnabled(Session.canListImages() && singleSelection);
    }

    private void openLectureDetails(LectureSummary lecture) {
        if (lecture == null) {
            return;
        }
        LectureDetailsWindow.open((JFrame)SwingUtilities.getWindowAncestor(this.me), lecture.getLectureId(), new LectureDetailsWindow.LectureUpdatedCallback(){

            @Override
            public void updated(boolean success) {
                LectureListWindow.this.refreshList(success);
            }
        });
    }

    private void deleteLectures(List<LectureSummary> lectureList) {
        ThriftActions.deleteLecture(JOptionPane.getFrameForComponent(this.me), lectureList, new ThriftActions.DeleteLectureCallback(){

            @Override
            public void deleted(Map<LectureSummary, TException> fLectures) {
                LectureListWindow.this.refreshList(true);
                if (fLectures.size() > 0) {
                    StringBuilder builder = new StringBuilder();
                    for (LectureSummary lecture : fLectures.keySet()) {
                        builder.append("\n\n");
                        builder.append(lecture.lectureName + " \n");
                        builder.append("Begr\u00fcndung: " + fLectures.get(lecture).getLocalizedMessage());
                        LOGGER.error("Couldn't delete lecture " + lecture.lectureName + ", reason:", fLectures.get(lecture));
                    }
                    Gui.showMessageBox("Folgende Veranstaltungen konnten nicht gel\u00f6scht werden: " + builder.toString(), MessageType.INFO, LOGGER, null);
                }
            }
        });
    }

    private void applyFilterOnTable() {
        if (this.cboFilter.getSelectedIndex() == -1) {
            return;
        }
        ArrayList<RowFilter> filters = new ArrayList<RowFilter>();
        if (this.searchFieldPattern != null) {
            filters.add(this.filterSearchTerm);
        }
        FilterType filterType = (FilterType)((Object)this.cboFilter.getSelectedItem());
        this.tblLectures.setHighlightOwn(true);
        if (filterType != null && filterType.filter != null) {
            filters.add(filterType.filter);
        }
        RowFilter andFilters = RowFilter.andFilter(filters);
        ((DefaultRowSorter)this.tblLectures.getRowSorter()).setRowFilter(andFilters);
        this.setLectureCountLabel(this.tblLectures.getRowCount());
    }

    private void refreshList(final boolean force) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                final List<LectureSummary> lectureList = LectureCache.get(force);
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LectureListWindow.this.tblLectures.setData(lectureList, true);
                        LectureListWindow.this.setLectureCountLabel(LectureListWindow.this.tblLectures.getRowCount());
                    }
                });
            }
        });
    }

    @Override
    public boolean requestHide() {
        if (this.cboFilter.getSelectedIndex() == -1) {
            this.cboFilter.setSelectedIndex(0);
        }
        return true;
    }

    @Override
    public void requestShow() {
        this.btnSwitchView.setEnabled(Session.canListImages());
        this.btnNewLecture.setEnabled(Session.canListImages());
        this.updateAvailableOptions(null);
        this.refreshList(false);
    }

    public void filterByImageBaseId(final String imageBaseId) {
        if (imageBaseId == null) {
            return;
        }
        RowFilter<ListTable.ListModel<LectureSummary>, Integer> imageFilter = new RowFilter<ListTable.ListModel<LectureSummary>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTable.ListModel<LectureSummary>, ? extends Integer> entry) {
                LectureSummary lecture = (LectureSummary)LectureListWindow.this.tblLectures.getModelRow(entry.getIdentifier());
                return imageBaseId.equals(lecture.imageBaseId);
            }
        };
        this.cboFilter.setSelectedIndex(-1);
        this.txtSearch.setText("");
        this.txtSearch.setEnabled(false);
        ((DefaultRowSorter)this.tblLectures.getRowSorter()).setRowFilter(imageFilter);
        this.setLectureCountLabel(this.tblLectures.getRowCount());
    }

    public static enum FilterType {
        ALL("Alle anzeigen", null),
        OWN("Nur eigene/zugewiesene anzeigen", new RowFilter<ListTable.ListModel<LectureSummary>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTable.ListModel<LectureSummary>, ? extends Integer> entry) {
                LectureSummary lecture = entry.getModel().getModelRow(entry.getIdentifier());
                return lecture.userPermissions.admin || lecture.ownerId.equals(Session.getUserId());
            }
        }),
        ACTIVE("Nur aktive anzeigen", new RowFilter<ListTable.ListModel<LectureSummary>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTable.ListModel<LectureSummary>, ? extends Integer> entry) {
                LectureSummary lecture = entry.getModel().getModelRow(entry.getIdentifier());
                return lecture.isEnabled && lecture.endTime > Util.unixTime();
            }
        }),
        EDITABLE("Nur editierbare anzeigen", new RowFilter<ListTable.ListModel<LectureSummary>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTable.ListModel<LectureSummary>, ? extends Integer> entry) {
                LectureSummary lecture = entry.getModel().getModelRow(entry.getIdentifier());
                return LecturePerms.canEdit(lecture);
            }
        }),
        EXPIRING("Bald auslaufende anzeigen", new RowFilter<ListTable.ListModel<LectureSummary>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTable.ListModel<LectureSummary>, ? extends Integer> entry) {
                LectureSummary lecture = entry.getModel().getModelRow(entry.getIdentifier());
                return Math.abs(lecture.endTime - Util.unixTime()) < 604800L;
            }
        }),
        EXAMS("Pr\u00fcfungsveranstaltungen anzeigen", new RowFilter<ListTable.ListModel<LectureSummary>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTable.ListModel<LectureSummary>, ? extends Integer> entry) {
                LectureSummary lecture = entry.getModel().getModelRow(entry.getIdentifier());
                return lecture.isExam;
            }
        });

        private final String name;
        private final RowFilter<ListTable.ListModel<LectureSummary>, Integer> filter;

        private FilterType(String name, RowFilter<ListTable.ListModel<LectureSummary>, Integer> filter) {
            this.name = name;
            this.filter = filter;
        }

        public String toString() {
            return this.name;
        }
    }
}

