/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.changemonitor.GenericControlWindow;
import org.openslx.dozmod.gui.control.table.ImageTable;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.layout.LectureChangeImageLayout;
import org.openslx.dozmod.permissions.ImagePerms;

public class LectureChangeImage
extends LectureChangeImageLayout
implements UiFeedback,
GenericControlWindow<ImageSummaryRead> {
    private static final Logger LOGGER = Logger.getLogger(LectureChangeImage.class);
    private boolean okUsed = false;
    private ImageTable imageTable;
    private List<ChangeListener> listeners;

    protected LectureChangeImage(Window modalParent) {
        super(modalParent);
        this.imageListViewer.refreshList(false, 1);
        this.imageTable = this.imageListViewer.getImageTable();
        this.imageTable.setColumnVisible(ImageTable.COL_LASTCHANGE, false);
        this.imageTable.setColumnVisible(ImageTable.COL_OS, false);
        this.imageTable.setColumnVisible(ImageTable.COL_SIZE, false);
        this.imageTable.setColumnVisible(ImageTable.COL_TEMPLATE, false);
        this.imageTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.processClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processClick(e);
            }

            private void processClick(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ImageSummaryRead image = (ImageSummaryRead)LectureChangeImage.this.imageTable.getSelectedItem();
                    if (image.isValid && ImagePerms.canLink(image)) {
                        LectureChangeImage.this.okUsed = true;
                        LectureChangeImage.this.dispose();
                    } else if (!image.isValid) {
                        Gui.showMessageBox(LectureChangeImage.this, "Ausgew\u00e4hlte VM ist ung\u00fcltig!", MessageType.ERROR, LOGGER, null);
                    } else {
                        Gui.showMessageBox(LectureChangeImage.this, "Keine Rechte zum Verlinken auf die ausgew\u00e4hlte VM.", MessageType.ERROR, LOGGER, null);
                    }
                }
            }
        });
        this.imageTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImageSummaryRead image = (ImageSummaryRead)LectureChangeImage.this.imageTable.getSelectedItem();
                LectureChangeImage.this.btnOk.setEnabled(image.isValid && ImagePerms.canLink(image));
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureChangeImage.this.okUsed = true;
                LectureChangeImage.this.dispose();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LectureChangeImage.this.dispose();
            }
        });
    }

    private ImageSummaryRead runAndReturn() {
        this.setVisible(true);
        if (this.okUsed) {
            this.fireChangeEvent();
        }
        return this.getState();
    }

    @Override
    public ImageSummaryRead getState() {
        if (this.okUsed) {
            return (ImageSummaryRead)this.imageTable.getSelectedItem();
        }
        return null;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(l);
    }

    private void fireChangeEvent() {
        if (this.listeners == null) {
            return;
        }
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(null);
        }
    }

    public static ImageSummaryRead open(Window modalParent, DialogChangeMonitor monitor) {
        LectureChangeImage lci = new LectureChangeImage(modalParent);
        monitor.add(lci);
        return lci.runAndReturn();
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }
}

