/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.layout.GenericNoticeWindowLayout;

public abstract class GenericNoticeWindow
extends GenericNoticeWindowLayout
implements UiFeedback {
    final GenericNoticeWindow me = this;
    private static final Logger LOGGER = Logger.getLogger(GenericNoticeWindow.class);
    private boolean shouldBeShown = true;

    public GenericNoticeWindow(Frame modalParent, boolean shouldBeShown) {
        super(modalParent);
        this.setDefaultCloseOperation(0);
        this.shouldBeShown = shouldBeShown;
        this.chkAgreeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericNoticeWindow.this.btnContinue.setEnabled(GenericNoticeWindow.this.chkAgreeBox.isSelected());
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GenericNoticeWindow.this.closeWindow();
            }
        });
        if (!shouldBeShown) {
            this.chkAgreeBox.setVisible(false);
            this.btnContinue.setText("Schlie\u00dfen");
            this.btnContinue.setEnabled(true);
        } else {
            this.disclaimerPanel.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    int max;
                    JScrollBar scrollBar = (JScrollBar)e.getAdjustable();
                    int extent = scrollBar.getModel().getExtent();
                    int value = e.getValue() + extent;
                    if (value >= (max = e.getAdjustable().getMaximum())) {
                        GenericNoticeWindow.this.chkAgreeBox.setEnabled(true);
                    }
                }
            });
        }
    }

    @Override
    public boolean wantConfirmQuit() {
        return true;
    }

    @Override
    public void escapePressed() {
        this.closeWindow();
    }

    private void closeWindow() {
        if (this.shouldBeShown) {
            if (Gui.showMessageBox(this.me, "Wenn diesen rechtlichen Hinweis nicht akzeptieren, k\u00f6nnen Sie die Software nicht verwenden! Sind Sie sicher, dass sie abbrechen wollen?", MessageType.QUESTION_YESNO, LOGGER, null)) {
                System.exit(128);
            }
        } else {
            this.me.dispose();
        }
    }
}

