/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.GenericNoticeWindow;
import org.openslx.dozmod.gui.window.PrivacyNoticeWindow;
import org.openslx.dozmod.util.ResourceLoader;

public class DisclaimerWindow
extends GenericNoticeWindow
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(PrivacyNoticeWindow.class);
    final DisclaimerWindow me = this;
    protected String DISCLAIMER_NOTICE;
    private static String DISCLAIMER_NOTICE_MD5 = null;
    private static String DISCLAIMER_NOTICE_CONTENT = null;

    public DisclaimerWindow(Frame modalParent) {
        super(modalParent, DisclaimerWindow.shouldBeShown());
        this.setNoticeText(DISCLAIMER_NOTICE_CONTENT);
        this.btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.setDisclaimerAgreement(DISCLAIMER_NOTICE_MD5);
                DisclaimerWindow.this.me.dispose();
            }
        });
    }

    public static boolean shouldBeShown() {
        return !Config.getDisclaimerAgreement().equals(DISCLAIMER_NOTICE_MD5);
    }

    public static void open(Frame modalParent) {
        new DisclaimerWindow(modalParent).setVisible(true);
    }

    static {
        try (InputStream noticeStream = ResourceLoader.getStream("/txt/disclaimer_notice");){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] content = IOUtils.toByteArray(noticeStream);
            md.update(content);
            byte[] md5 = md.digest();
            DISCLAIMER_NOTICE_CONTENT = new String(content, StandardCharsets.UTF_8);
            DISCLAIMER_NOTICE_MD5 = DatatypeConverter.printHexBinary((byte[])md5);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOGGER.error("Failed to get hash of disclaimer notice: ", e);
        }
    }
}

