/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.SatelliteUserConfig;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.layout.ConfigWindowLayout;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.thrifthelper.ThriftManager;

public class ConfigWindow
extends ConfigWindowLayout
implements UiFeedback,
ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ConfigWindow.class);
    private SatelliteUserConfig userConfig = null;
    private JRadioButton selectedLookAndFeel = null;

    public ConfigWindow(Window modalParent) {
        super(modalParent);
        this.btnSave.setEnabled(false);
        switch (Config.getProxyMode()) {
            case NONE: {
                this.btnProxyNone.setSelected(true);
                break;
            }
            case AUTO: {
                this.btnProxyAuto.setSelected(true);
                break;
            }
        }
        this.btnProxyNone.addActionListener(this);
        this.btnProxyAuto.addActionListener(this);
        if (Session.getSatelliteToken() == null) {
            this.chkSendMeMail.setEnabled(false);
        } else {
            this.userConfig = this.getSatUserConfig();
            if (this.userConfig != null) {
                this.chkSendMeMail.setSelected(this.userConfig.isEmailNotifications());
            } else {
                this.chkSendMeMail.setSelected(false);
            }
            this.chkSendMeMail.addActionListener(this);
            this.lblYourAddress.setText("Ihre Adresse ist " + Session.getEMail());
        }
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfigWindow.this.reactToInput();
            }
        };
        this.sldFontSize.setValue(Config.getFontScaling());
        this.sldFontSize.addChangeListener(changeListener);
        Enumeration<AbstractButton> btn = this.btnGroupLookAndFeel.getElements();
        while (btn.hasMoreElements()) {
            final JRadioButton b = (JRadioButton)btn.nextElement();
            if (Config.getLookAndFeel() != null && !Config.getLookAndFeel().isEmpty() && b.getToolTipText().equals(Config.getLookAndFeel())) {
                this.selectedLookAndFeel = b;
                b.setSelected(true);
            }
            if (this.selectedLookAndFeel == null && b.getToolTipText().equals(UIManager.getSystemLookAndFeelClassName())) {
                this.selectedLookAndFeel = b;
                b.setSelected(true);
            }
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigWindow.this.selectedLookAndFeel = b;
                    ConfigWindow.this.reactToInput();
                }
            });
        }
        if (this.selectedLookAndFeel == null) {
            LOGGER.error("Failed to detect the current look & feel theme.");
        }
        this.sldConnections.setValue(Config.getTransferConnectionCount());
        this.sldConnections.addChangeListener(changeListener);
        this.btnSave.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnProxyAuto || source == this.btnProxyHttp || source == this.btnProxyNone || source == this.btnProxySocks || source == this.chkSendMeMail) {
            this.reactToInput();
        }
        if (source == this.btnSave) {
            this.saveOptions();
        }
        if (source == this.btnClose) {
            this.dispose();
        }
    }

    private void reactToInput() {
        boolean changed = false;
        Config.ProxyMode initMode = Config.getProxyMode();
        int fontScaling = Config.getFontScaling();
        if (this.btnProxyNone.isSelected() && initMode != Config.ProxyMode.NONE) {
            changed = true;
        } else if (this.btnProxyAuto.isSelected() && initMode != Config.ProxyMode.AUTO) {
            changed = true;
        } else if (this.chkSendMeMail.isEnabled() && this.chkSendMeMail.isSelected() != this.userConfig.emailNotifications) {
            changed = true;
        } else if (this.sldFontSize.getValue() != fontScaling) {
            changed = true;
        } else if (this.sldConnections.getValue() != Config.getTransferConnectionCount()) {
            changed = true;
        } else if (!this.selectedLookAndFeel.getToolTipText().equals(Config.getLookAndFeel())) {
            changed = true;
        }
        this.btnSave.setEnabled(changed);
    }

    private SatelliteUserConfig getSatUserConfig() {
        SatelliteUserConfig userConfig = null;
        try {
            userConfig = ThriftManager.getSatClient().getUserConfig(Session.getSatelliteToken());
        }
        catch (TException e) {
            ThriftError.showMessage(this, LOGGER, e, "Konnte die benutzerspezifische Konfiguration nicht vom Satelliten holen");
        }
        return userConfig;
    }

    private boolean setSatUserConfig(SatelliteUserConfig config) {
        if (config == null) {
            return false;
        }
        try {
            ThriftManager.getSatClient().setUserConfig(Session.getSatelliteToken(), config);
            this.userConfig = config;
        }
        catch (TException e) {
            ThriftError.showMessage(this, LOGGER, e, "Konnte die benutzerspezifische Konfiguration nicht auf dem Satelliten speichern");
            return false;
        }
        return true;
    }

    private void saveOptions() {
        boolean restartRequired = false;
        this.btnSave.setEnabled(false);
        Config.ProxyMode selectedMode = null;
        if (this.btnProxyAuto.isSelected()) {
            selectedMode = Config.ProxyMode.AUTO;
        }
        if (this.btnProxyNone.isSelected()) {
            selectedMode = Config.ProxyMode.NONE;
        }
        if (selectedMode != null) {
            restartRequired = restartRequired || Config.getProxyMode() != selectedMode;
            Config.setProxyMode(selectedMode);
        }
        int newFontScaling = this.sldFontSize.getValue();
        restartRequired = restartRequired || Config.getFontScaling() != newFontScaling;
        Config.setFontScaling(newFontScaling);
        Config.setTransferConnectionCount(this.sldConnections.getValue());
        if (Session.getSatelliteToken() != null && !this.setSatUserConfig(new SatelliteUserConfig(this.chkSendMeMail.isSelected()))) {
            this.btnSave.setEnabled(true);
        }
        if (this.selectedLookAndFeel != null) {
            restartRequired = restartRequired || !this.selectedLookAndFeel.getToolTipText().equals(Config.getLookAndFeel());
            Config.setLookAndFeel(this.selectedLookAndFeel.getToolTipText());
        }
        if (restartRequired) {
            Gui.showMessageBox(this, "Die \u00c4nderungen werden erst nach einem Programmneustart wirksam.", MessageType.INFO, null, null);
        }
    }

    public static boolean shouldBeShown() {
        return true;
    }

    public static void open(Window modalParent) {
        ConfigWindow win = new ConfigWindow(modalParent);
        MainWindow.centerShell(win);
        win.setVisible(true);
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }
}

