/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.authentication.ShibbolethEcp;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.util.DesktopEnvironment;

public class BwIdmLinkWindow
extends JDialog
implements UiFeedback {
    private static final String title = "Registrierung erforderlich";
    private static final String infoText = "<html><body style='width:100%'>Sie sind nicht bei " + Branding.getServiceName() + " registriert. Bitte rufen Sie die angegebene Seite auf um sich zu registrieren und versuchen Sie es erneut.</body></html>";
    protected JButton btnLink;
    protected JButton OkButton;
    private static final Logger LOGGER = Logger.getLogger(BwIdmLinkWindow.class);

    public BwIdmLinkWindow(Frame modalParent) {
        super((Window)modalParent, title, modalParent != null ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        final BwIdmLinkWindow me = this;
        this.setDefaultCloseOperation(2);
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(contentPanel);
        GridManager grid = new GridManager(contentPanel, 1);
        JLabel infoLabel = new JLabel(infoText);
        infoLabel.setBorder(BorderFactory.createTitledBorder("Hinweis"));
        grid.add(infoLabel).fill(true, true).expand(true, true).anchor(10);
        grid.nextRow();
        this.btnLink = new JButton("Seite im Browser \u00f6ffnen");
        this.btnLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopEnvironment.openWebpageUri(ShibbolethEcp.getRegistrationUrl().toURI());
                }
                catch (URISyntaxException e1) {
                    LOGGER.error("Could not convert from url to uri: ", e1);
                }
            }
        });
        grid.add(this.btnLink).anchor(10).fill(false, false).expand(false, false);
        grid.nextRow();
        JTextArea linkText = new JTextArea(ShibbolethEcp.getRegistrationUrl().toString());
        linkText.setEditable(false);
        linkText.setMaximumSize(linkText.getPreferredSize());
        linkText.setMinimumSize(linkText.getPreferredSize());
        grid.add(linkText).anchor(10).fill(false, false).expand(false, false);
        grid.nextRow();
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new BoxLayout(bottomPane, 2));
        bottomPane.add(Box.createHorizontalGlue());
        this.OkButton = new JButton("Schlie\u00dfen");
        this.OkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        bottomPane.add(this.OkButton);
        grid.add(bottomPane).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.finish(false);
        this.setMinimumSize(Gui.getScaledDimension(500, 200));
        this.setPreferredSize(this.getMinimumSize());
        this.setLocationRelativeTo(modalParent);
    }

    public static void open(Frame modalParent) {
        new BwIdmLinkWindow(modalParent).setVisible(true);
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }
}

