/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.helper;

import java.awt.Component;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.DateTimeHelper;
import org.openslx.dozmod.gui.helper.ExpiryDateChooser;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.util.FormatHelper;

class ExpiryDateChooserWindow
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(ExpiryDateChooser.class);
    public static final int DEFAULT_EXTENSION_DURATION = 14;
    private final JPanel pane = new JPanel();
    private final GridManager grdPane = new GridManager(this.pane, 3, true);
    private final JSlider sldDaysToExtend = new JSlider(0);
    private final QLabel lblNewDate = new QLabel();
    private final QLabel lblNewDateLabel = new QLabel("Neues Ablaufdatum: ");
    private final Component parent;

    public ExpiryDateChooserWindow(Component parent) {
        this.parent = parent;
        this.grdPane.add(new QLabel("Geben Sie ein um wieviele Tage diese Version(en) verl\u00e4ngert werden soll:"), 3).fill(true, true).expand(true, true);
        this.grdPane.nextRow();
        this.sldDaysToExtend.setModel(new DefaultBoundedRangeModel(14, 0, 1, Session.getSatelliteConfig().maxImageValidityDays));
        this.grdPane.add(this.sldDaysToExtend, 3).fill(true, false).expand(true, false);
        this.grdPane.nextRow();
        this.grdPane.add(this.lblNewDateLabel);
        this.grdPane.add(Box.createGlue()).fill(true, false).expand(true, false);
        this.grdPane.add(this.lblNewDate).fill(true, true).expand(true, true);
        this.grdPane.finish(true);
    }

    public int query(final Date startingDate) {
        this.lblNewDate.setText(startingDate == null ? "" : FormatHelper.longDate(DateTimeHelper.addDaysTo(startingDate, 14)));
        this.sldDaysToExtend.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (startingDate == null) {
                    return;
                }
                Date current = DateTimeHelper.addDaysTo(startingDate, ExpiryDateChooserWindow.this.sldDaysToExtend.getValue());
                ExpiryDateChooserWindow.this.lblNewDate.setText(FormatHelper.longDate(current));
            }
        });
        this.sldDaysToExtend.setValue(14);
        int ret = JOptionPane.showConfirmDialog(this.parent, this.pane, "Ablaufdatum verl\u00e4ngern", 2);
        if (ret != 0) {
            return -1;
        }
        return this.sldDaysToExtend.getValue();
    }
}

