/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class LecturePermissionTable
extends ListTable<UserLecturePermissions> {
    public static final ListTable.ListTableColumn COL_USER = new ListTable.ListTableColumn("Benutzer");
    public static final ListTable.ListTableColumn COL_EDIT = new ListTable.ListTableColumn("Bearbeiten", Boolean.class);
    public static final ListTable.ListTableColumn COL_ADMIN = new ListTable.ListTableColumn("Admin", Boolean.class);

    public LecturePermissionTable() {
        super(COL_USER, COL_EDIT, COL_ADMIN);
    }

    @Override
    protected Object getValueAtInternal(UserLecturePermissions row, ListTable.ListTableColumn column) {
        if (column == COL_USER) {
            return FormatHelper.userName(UserCache.find(row.userId));
        }
        if (column == COL_EDIT) {
            return row.permissions.edit;
        }
        if (column == COL_ADMIN) {
            return row.permissions.admin;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!(aValue instanceof Boolean)) {
            return;
        }
        UserLecturePermissions row = (UserLecturePermissions)this.getViewRow(rowIndex);
        if (columnIndex == 1) {
            row.permissions.edit = (Boolean)aValue;
        }
        if (columnIndex == 2) {
            row.permissions.admin = (Boolean)aValue;
        }
    }

    public static class UserLecturePermissions {
        public final String userId;
        public final LecturePermissions permissions;

        public UserLecturePermissions(String userId, LecturePermissions permission) {
            this.userId = userId;
            this.permissions = permission;
        }
    }
}

