/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBox<T>
extends JComboBox<T> {
    private final Comparator<T> equalityComparator;
    private final ComboBoxRenderer<T> itemRenderer;
    private final ComboBox<T> me = this;
    private boolean replacedRenderer = false;

    public ComboBox(ComboBoxRenderer<T> renderer) {
        this(null, renderer);
    }

    public ComboBox(Comparator<T> equalityComparator, ComboBoxRenderer<T> renderer) {
        this.itemRenderer = renderer;
        this.equalityComparator = equalityComparator;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject != null && this.equalityComparator != null) {
            ComboBoxModel model = this.getModel();
            Object localObject = null;
            try {
                for (int i = 0; i < model.getSize(); ++i) {
                    Object element = model.getElementAt(i);
                    if (this.equalityComparator.compare(anObject, element) != 0) continue;
                    localObject = element;
                    break;
                }
                super.setSelectedItem(localObject);
                return;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        super.setSelectedItem(anObject);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (!this.replacedRenderer) {
            this.replacedRenderer = true;
            final ListCellRenderer oldRenderer = super.getRenderer();
            if (oldRenderer instanceof JLabel) {
                ((JLabel)((Object)oldRenderer)).putClientProperty("html.disable", Boolean.TRUE);
                ((JLabel)((Object)oldRenderer)).putClientProperty("html", null);
                super.setRenderer(new ListCellRenderer<T>(){

                    @Override
                    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                        String text = ComboBox.this.me.getModel().getSize() == 0 ? ComboBox.this.itemRenderer.getEmptyText() : ComboBox.this.itemRenderer.renderItem(value);
                        Component comp = oldRenderer.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
                        comp.setEnabled(ComboBox.this.me.isEnabled());
                        ((JLabel)comp).setText(text);
                        return comp;
                    }
                });
            } else {
                super.setRenderer(new FallbackCellRenderer());
            }
        }
    }

    private class FallbackCellRenderer
    extends DefaultListCellRenderer {
        public FallbackCellRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
            this.putClientProperty("html", null);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (ComboBox.this.me.getModel().getSize() == 0) {
                value = ComboBox.this.itemRenderer.getEmptyText();
            } else {
                try {
                    value = ComboBox.this.itemRenderer.renderItem(value);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    public static abstract class ComboBoxRenderer<T> {
        public abstract String renderItem(T var1);

        public String getEmptyText() {
            return null;
        }
    }
}

