/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openslx.dozmod.gui.configurator.RunscriptType;
import org.openslx.dozmod.gui.configurator.RunscriptVisibility;
import org.openslx.dozmod.gui.configurator.SoundState;
import org.openslx.dozmod.gui.control.ComboBox;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.control.WordWrapLabel;
import org.openslx.dozmod.gui.helper.GridManager;

class StartupConfiguratorLayout
extends JPanel {
    private static final long serialVersionUID = 648729071828404053L;
    private static final String RUN_SCRIPT_HELP = "Ein hier eingetragenes Skript wird nach dem Start der VM automatisch ausgef\u00fchrt.";
    protected final QLabel lblError;
    protected final JTextArea taRunScript;
    protected final ComboBox<RunscriptType> cboRunscriptType;
    protected final ComboBox<RunscriptVisibility> cboRunscriptVisibility;
    protected final ComboBox<SoundState> cboSoundState;
    protected final JButton btnPredefinedScripts;

    public StartupConfiguratorLayout() {
        GridManager grid = new GridManager(this, 2, true, new Insets(5, 5, 5, 5));
        grid.add(new QLabel("Audio"));
        this.cboSoundState = new ComboBox<SoundState>(new ComboBox.ComboBoxRenderer<SoundState>(){

            @Override
            public String renderItem(SoundState item) {
                return item.displayName;
            }
        });
        this.cboSoundState.setModel(new DefaultComboBoxModel<SoundState>(SoundState.values()));
        grid.add(this.cboSoundState).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(Box.createVerticalStrut(4), 2);
        grid.nextRow();
        grid.add(new WordWrapLabel(RUN_SCRIPT_HELP, false, true), 2).fill(true, false).expand(true, false);
        grid.nextRow();
        this.cboRunscriptType = new ComboBox<RunscriptType>(new ComboBox.ComboBoxRenderer<RunscriptType>(){

            @Override
            public String renderItem(RunscriptType item) {
                if (item == null) {
                    return null;
                }
                return item.toString();
            }
        });
        this.cboRunscriptType.setModel(new DefaultComboBoxModel<RunscriptType>(RunscriptType.values()));
        this.cboRunscriptType.setEditable(true);
        grid.add(new QLabel("Dateinamenserweiterung: ")).fill(false, false).expand(false, false);
        grid.add(this.cboRunscriptType).fill(true, false).expand(true, false);
        grid.nextRow();
        this.cboRunscriptVisibility = new ComboBox<RunscriptVisibility>(new ComboBox.ComboBoxRenderer<RunscriptVisibility>(){

            @Override
            public String renderItem(RunscriptVisibility item) {
                if (item == null) {
                    return null;
                }
                return item.displayName;
            }
        });
        this.cboRunscriptVisibility.setModel(new DefaultComboBoxModel<RunscriptVisibility>(RunscriptVisibility.values()));
        grid.add(new QLabel("Sichtbarkeit: ")).fill(false, false).expand(false, false);
        grid.add(this.cboRunscriptVisibility).fill(true, false).expand(true, false);
        grid.nextRow();
        this.taRunScript = new JTextArea("", 5, 20);
        JScrollPane scpRunScript = new JScrollPane(this.taRunScript, 20, 31);
        this.taRunScript.setLineWrap(true);
        this.taRunScript.setWrapStyleWord(true);
        grid.add(scpRunScript, 2).fill(true, true).expand(true, true);
        grid.nextRow();
        this.btnPredefinedScripts = new JButton("Vordefinierte Scripte...");
        grid.add(this.btnPredefinedScripts, 2).anchor(22);
        grid.nextRow();
        this.lblError = new QLabel("");
        this.lblError.setForeground(Color.RED);
        JPanel pnlError = new JPanel();
        pnlError.add(Box.createGlue());
        pnlError.add(this.lblError);
        pnlError.add(Box.createGlue());
        grid.add(pnlError, 2).fill(true, false).expand(true, false);
        grid.finish(false);
    }
}

