/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.LectureRead;
import org.openslx.bwlp.thrift.iface.NetDirection;
import org.openslx.bwlp.thrift.iface.NetRule;
import org.openslx.bwlp.thrift.iface.PresetNetRule;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.changemonitor.GenericControlWindow;
import org.openslx.dozmod.gui.configurator.NetrulesConfiguratorLayout;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class NetrulesConfigurator
extends NetrulesConfiguratorLayout
implements GenericControlWindow<StateWrapper> {
    private static final long serialVersionUID = -3497629601818983994L;
    private static final Logger LOGGER = Logger.getLogger(NetrulesConfigurator.class);
    private boolean checkChange = false;
    private StateWrapper currentState = new StateWrapper();
    private LectureRead lecture;
    private List<ChangeListener> listeners;
    private List<PresetNetRule> predefinedRules;
    private static final String FIELD_DELIMITER = "\\s+";
    private static final Color FOREGROUND_TEXT_COLOR;

    public NetrulesConfigurator() {
        TextChangeListener docListener = new TextChangeListener(){

            @Override
            public void changed() {
                NetrulesConfigurator.this.checkChange = true;
                NetrulesConfigurator.this.fireChangeEvent();
            }
        };
        final SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setForeground(as, FOREGROUND_TEXT_COLOR);
        this.tpNetworkRules.getDocument().addDocumentListener(docListener);
        this.tpNetworkRules.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int pos = NetrulesConfigurator.this.tpNetworkRules.getCaretPosition();
                        if (pos < 0) {
                            return;
                        }
                        String text = NetrulesConfigurator.this.tpNetworkRules.getText().replace("\r", "");
                        if (pos >= text.length()) {
                            return;
                        }
                        int start = text.lastIndexOf(10, pos == 0 ? 0 : pos - 1);
                        int end = text.indexOf(10, pos);
                        if (start == -1) {
                            start = 0;
                        }
                        if (end == -1) {
                            end = text.length() - 1;
                        }
                        if (end <= start) {
                            return;
                        }
                        NetrulesConfigurator.this.tpNetworkRules.getStyledDocument().setCharacterAttributes(start, end - start, as, true);
                    }
                });
            }
        });
        this.btnCheckRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetrulesConfigurator.this.getState(false);
            }
        });
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                NetrulesConfigurator.this.predefinedRules = MetaDataCache.getPredefinedNetRules();
                if (NetrulesConfigurator.this.predefinedRules.isEmpty()) {
                    Gui.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NetrulesConfigurator.this.btnShowPresets.setVisible(false);
                        }
                    });
                }
            }
        });
        this.btnShowPresets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetrulesConfigurator.this.showPresetSelector();
            }
        });
    }

    private void showPresetSelector() {
        if (this.predefinedRules == null) {
            Gui.showMessageBox("Wah wah wah! Null preset list", MessageType.ERROR, null, null);
            return;
        }
        final JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(this), "Regelsets ausw\u00e4hlen", Dialog.ModalityType.APPLICATION_MODAL);
        JPanel pane = new JPanel();
        dialog.setContentPane(pane);
        dialog.setMinimumSize(Gui.getScaledDimension(200, 300));
        GridManager grid = new GridManager(pane, 2, true, new Insets(2, 2, 2, 2));
        final HashMap<ButtonModel, Integer> mapper = new HashMap<ButtonModel, Integer>();
        for (PresetNetRule ruleSet : this.predefinedRules) {
            JCheckBox button = new JCheckBox(ruleSet.displayName);
            grid.add(button, 2);
            grid.nextRow();
            mapper.put(button.getModel(), ruleSet.ruleId);
            if (this.lecture == null || this.lecture.presetNetworkExceptionIds == null || !this.lecture.presetNetworkExceptionIds.contains(ruleSet.ruleId)) continue;
            button.setSelected(true);
        }
        grid.add(Box.createVerticalGlue(), 2);
        grid.nextRow();
        JButton btnCancel = new JButton("Abbrechen");
        JButton btnOk = new JButton("SPASCHAN");
        grid.add(btnCancel).anchor(21);
        grid.add(btnOk).anchor(22);
        grid.finish(false);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        final AtomicReference selectedRules = new AtomicReference();
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList selected = new ArrayList();
                for (Map.Entry button : mapper.entrySet()) {
                    if (!((ButtonModel)button.getKey()).isSelected()) continue;
                    selected.add(button.getValue());
                }
                selectedRules.set(selected);
                dialog.dispose();
            }
        });
        dialog.pack();
        Gui.centerShellOverShell(SwingUtilities.getWindowAncestor(this), dialog);
        dialog.setVisible(true);
        if (selectedRules.get() != null) {
            this.lecture.presetNetworkExceptionIds = this.currentState.selectedPresets = (List)selectedRules.get();
            this.checkChange = true;
            this.fireChangeEvent();
        }
    }

    @Override
    public StateWrapper getState() {
        return this.getState(true);
    }

    public StateWrapper getState(boolean silent) {
        if (this.checkChange || !silent) {
            this.currentState.customRules = this.parseNetRules(silent);
        }
        return this.currentState.clone();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(l);
    }

    private void fireChangeEvent() {
        if (this.listeners == null) {
            return;
        }
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(null);
        }
    }

    public void setState(LectureRead lecture) {
        this.currentState.customRules = lecture.networkExceptions;
        this.currentState.selectedPresets = lecture.presetNetworkExceptionIds;
        this.checkChange = true;
        this.lecture = lecture;
        this.tpNetworkRules.setText(NetrulesConfigurator.decodeNetRulesToText(lecture.networkExceptions));
        this.fireChangeEvent();
    }

    public static String decodeNetRulesToText(List<NetRule> netRulesList) {
        if (netRulesList == null || netRulesList.isEmpty()) {
            return "";
        }
        String decodedRules = "";
        Iterator<NetRule> it = netRulesList.iterator();
        while (it.hasNext()) {
            String currentLine = "";
            NetRule currentRule = it.next();
            if (currentRule.host.isEmpty() || currentRule.port > 65535) {
                LOGGER.error("Invalid rule! Ignoring: " + currentRule.host + ":" + currentRule.port);
                continue;
            }
            currentLine = currentLine + currentRule.host + " \t ";
            currentLine = currentLine + currentRule.port + " \t ";
            currentLine = currentLine + currentRule.direction.name();
            decodedRules = decodedRules + currentLine + (it.hasNext() ? "\n" : "");
        }
        return decodedRules;
    }

    public List<NetRule> parseNetRules(boolean silent) {
        String rawNetRules = this.tpNetworkRules.getText().trim();
        ArrayList<NetRule> rulesList = new ArrayList<NetRule>();
        if (rawNetRules.isEmpty()) {
            return rulesList;
        }
        boolean invalid = false;
        DefaultStyledDocument newdoc = null;
        if (!silent) {
            newdoc = new DefaultStyledDocument();
        }
        StringBuilder errors = new StringBuilder();
        int lineNo = 0;
        for (String ruleLine : rawNetRules.split("[\r\n]+")) {
            if (silent && invalid) {
                return null;
            }
            Color lineColor = null;
            LOGGER.debug("Parsing rule: " + ruleLine);
            String[] fields = ruleLine.trim().split(FIELD_DELIMITER);
            if (fields.length != 3) {
                lineNo += this.addLine(newdoc, ruleLine, Color.RED, true);
                LOGGER.debug("Invalid number of fields! Expected 3, got: " + fields.length);
                if (fields.length > 3) {
                    errors.append("Zeile " + lineNo + ": Zu viele Felder.\n");
                } else {
                    errors.append("Zeile " + lineNo + ": Zu wenig Felder.\n");
                }
                invalid = true;
                continue;
            }
            String ruleDirection = fields[2].toUpperCase();
            ruleLine = fields[0] + " \t " + fields[1] + " \t " + ruleDirection;
            if (!ruleDirection.equals("IN") && !ruleDirection.equals("OUT")) {
                LOGGER.debug("Invalid net direction! Expected 'in' or out'. Got: " + ruleDirection);
                errors.append("Zeile " + (lineNo += this.addLine(newdoc, ruleLine, Color.RED, true)) + ": Ung\u00fcltige Richtung. Bitte nutzen Sie 'IN' bzw. 'OUT'.\n");
                invalid = true;
                continue;
            }
            int port = Util.parseInt(fields[1], -1);
            if (port < 0 || port > 65535) {
                LOGGER.debug("Invalid port! Got: " + port);
                errors.append("Zeile " + (lineNo += this.addLine(newdoc, ruleLine, Color.RED, true)) + ": Ung\u00fcltiger Port. G\u00fcltiger Bereich ist 0-65535.\n");
                invalid = true;
                continue;
            }
            String checkRes = this.checkHostnameSimple(fields[0]);
            if (checkRes != null) {
                errors.append("Zeile " + (lineNo += this.addLine(newdoc, ruleLine, Color.RED, true)) + ": " + checkRes + "\n");
                invalid = true;
                continue;
            }
            lineNo += this.addLine(newdoc, ruleLine, lineColor, false);
            rulesList.add(new NetRule(NetDirection.valueOf(ruleDirection), fields[0], port));
        }
        if (newdoc != null) {
            this.tpNetworkRules.setDocument(newdoc);
            this.resetTabStops();
        }
        if (!silent && errors.length() != 0) {
            Gui.showMessageBox("Fehler beim Auswerten der angegebenen Netzwerkregeln.\n\n" + errors.toString() + "\nBitte geben Sie die Regeln zeilenweise im Format\n<host> <port> <IN|OUT>\nan.", MessageType.ERROR, null, null);
        }
        if (invalid) {
            return null;
        }
        return rulesList;
    }

    private int addLine(DefaultStyledDocument doc, String line, Color color, boolean bold) {
        if (doc == null) {
            return 0;
        }
        if (color == null) {
            color = FOREGROUND_TEXT_COLOR;
        }
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, color);
        StyleConstants.setBold(attrs, bold);
        try {
            doc.insertString(doc.getLength(), line + "\n", attrs);
        }
        catch (BadLocationException e) {
            LOGGER.warn("Cannot append to new textbox document", e);
        }
        return 1;
    }

    private String checkHostnameSimple(String hostname) {
        if (hostname.length() > 254) {
            return "Hostname ist zu lang.";
        }
        boolean allNumeric = true;
        int netmask = -1;
        String[] domainLabels = null;
        int ls = hostname.lastIndexOf(47);
        if (ls != -1) {
            netmask = Util.parseInt(hostname.substring(ls + 1), -1);
            if (netmask == -1) {
                return "Ung\u00fcltige Netzmaske.";
            }
            hostname = hostname.substring(0, ls);
        }
        if (hostname.matches("^\\[.*\\]$")) {
            hostname = hostname.substring(1, hostname.length() - 2);
        } else {
            domainLabels = hostname.split("\\.");
        }
        if (domainLabels == null || domainLabels.length <= 1 && hostname.indexOf(58) != -1) {
            if (hostname.startsWith(":") && !hostname.startsWith("::") || hostname.endsWith(":") && !hostname.endsWith("::")) {
                return "IPv6-Adresse darf nicht mit einem Doppelpunkt beginnen oder enden.";
            }
            int numCompressed = (hostname.length() - hostname.replace("::", "").length()) / 2;
            if (numCompressed > 1) {
                return "IPv6-Adresse darf nicht mehr als einen komprimierten Teil enthalten.";
            }
            if (netmask > 128) {
                return "IPv6 Netzmaske kann nicht gr\u00f6\u00dfer 128 Bit sein.";
            }
            domainLabels = hostname.split(":");
            if (domainLabels.length > 8) {
                return "IPv6-Adresse enth\u00e4lt zu viele Hextets.";
            }
            for (String domainLabel : domainLabels) {
                if (domainLabel.isEmpty()) continue;
                try {
                    int test = Integer.parseInt(domainLabel, 16);
                    if (test >= 0 && test <= 65535) continue;
                    return "IPv6-Adresse enth\u00e4lt ung\u00fcltiges Hextet.";
                }
                catch (Exception e) {
                    return "IPv6-Adresse enth\u00e4lt nicht-hexadezimale Zeichen.";
                }
            }
            if (!(allNumeric && (domainLabels.length != 8 && numCompressed <= 0 || netmask >= -1 && netmask <= 128) && (domainLabels.length >= 8 || numCompressed != 0 || netmask >= 0 && netmask <= 128))) {
                return "Fehlerhafte IPv6-Adresse/Netzmaske.";
            }
        } else {
            if (netmask > 32) {
                return "IPv4 Netzmaske kann nicht gr\u00f6\u00dfer 32 Bit sein.";
            }
            for (String domainLabel : domainLabels) {
                if (domainLabel.length() > 63) {
                    return "Domain-Ebene '" + domainLabel + "' l\u00e4nger als 63 Zeichen.";
                }
                int i = Util.parseInt(domainLabel, -1);
                if (i >= 0 && i <= 255) continue;
                allNumeric = false;
            }
            if (allNumeric && (domainLabels.length == 4 && (netmask < -1 || netmask > 32) || domainLabels.length > 4 || domainLabels.length < 4 && (netmask < 0 || netmask > 32))) {
                return "Fehlerhafte IPv4-Adresse/Netzmaske.";
            }
        }
        return null;
    }

    static {
        Color fgOrigColor = UIManager.getDefaults().getColor("ColorChooser.foreground");
        if (fgOrigColor == null) {
            fgOrigColor = Color.BLACK;
        }
        FOREGROUND_TEXT_COLOR = fgOrigColor;
    }

    public static class StateWrapper {
        public List<NetRule> customRules;
        public List<Integer> selectedPresets;

        public boolean equals(Object obj) {
            if (!(obj instanceof StateWrapper)) {
                return false;
            }
            StateWrapper o = (StateWrapper)obj;
            if (!(this.selectedPresets == o.selectedPresets || this.selectedPresets != null && this.selectedPresets.equals(o.selectedPresets))) {
                return false;
            }
            if (this.customRules == o.customRules) {
                return true;
            }
            return this.customRules != null && this.customRules.equals(o.customRules);
        }

        protected StateWrapper clone() {
            StateWrapper r = new StateWrapper();
            if (this.customRules != null) {
                r.customRules = new ArrayList<NetRule>(this.customRules);
            }
            if (this.selectedPresets != null) {
                r.selectedPresets = new ArrayList<Integer>(this.selectedPresets);
            }
            return r;
        }
    }
}

