/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.changemonitor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openslx.dozmod.gui.changemonitor.AbstractControlWrapper;
import org.openslx.dozmod.gui.changemonitor.ClonedTableModel;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;

class TableWrapper
extends AbstractControlWrapper<ClonedTableModel> {
    private static final Comparator<ClonedTableModel> COMPARATOR = new Comparator<ClonedTableModel>(){

        @Override
        public int compare(ClonedTableModel o1, ClonedTableModel o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -o2.rowCount;
            }
            if (o2 == null) {
                return o1.rowCount;
            }
            if (o1.rowCount != o2.rowCount) {
                return o2.rowCount - o1.rowCount;
            }
            if (o1.columnCount != o2.columnCount) {
                return o2.columnCount - o1.columnCount;
            }
            for (int i = 0; i < o1.grid.length; ++i) {
                Object c1 = o1.grid[i];
                Object c2 = o2.grid[i];
                if (c1 == c2) continue;
                if (c1 == null) {
                    return c2.hashCode();
                }
                if (c2 == null) {
                    return c1.hashCode();
                }
                if (c1.equals(c2)) continue;
                return c1.hashCode() - c2.hashCode();
            }
            return 0;
        }
    };
    private final JTable component;

    public TableWrapper(DialogChangeMonitor dcm, JTable table) {
        super(dcm, COMPARATOR);
        this.component = table;
        final TableModelListener changeListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TableWrapper.this.contentChanged();
            }
        };
        table.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getOldValue();
                Object n = evt.getNewValue();
                if (o != null && o instanceof TableModel) {
                    ((TableModel)o).removeTableModelListener(changeListener);
                }
                if (n != null && n instanceof TableModel) {
                    ((TableModel)n).addTableModelListener(changeListener);
                }
            }
        });
        if (table.getModel() != null) {
            table.getModel().addTableModelListener(changeListener);
        }
    }

    @Override
    ClonedTableModel getCurrentValue() {
        TableModel model = this.component.getModel();
        if (model == null) {
            return null;
        }
        return new ClonedTableModel(model);
    }
}

