/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.changemonitor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdatepicker.JDatePicker;
import org.openslx.dozmod.gui.changemonitor.AbstractControlWrapper;
import org.openslx.dozmod.gui.changemonitor.ButtonGroupWrapper;
import org.openslx.dozmod.gui.changemonitor.CheckBoxTreeWrapper;
import org.openslx.dozmod.gui.changemonitor.CheckBoxWrapper;
import org.openslx.dozmod.gui.changemonitor.ClonedTableModel;
import org.openslx.dozmod.gui.changemonitor.DatePickerWrapper;
import org.openslx.dozmod.gui.changemonitor.EditableComboBoxWrapper;
import org.openslx.dozmod.gui.changemonitor.FixedComboBoxWrapper;
import org.openslx.dozmod.gui.changemonitor.GenericControlWindow;
import org.openslx.dozmod.gui.changemonitor.GenericControlWrapper;
import org.openslx.dozmod.gui.changemonitor.TableWrapper;
import org.openslx.dozmod.gui.changemonitor.TextControlWrapper;
import org.openslx.dozmod.gui.changemonitor.TimeSpinnerWrapper;
import org.openslx.dozmod.gui.control.ComboBox;
import org.openslx.dozmod.gui.control.JCheckBoxTree;
import org.openslx.util.Util;

public class DialogChangeMonitor {
    private static final Logger LOGGER = Logger.getLogger(DialogChangeMonitor.class);
    private final Callback callback;
    private final List<AbstractControlWrapper<?>> controls = new ArrayList();
    private boolean isCurrentlyModified;
    private boolean wasEverModified;
    private boolean isValid = true;

    public DialogChangeMonitor(Callback cb) {
        this.callback = cb;
    }

    private <T> AbstractControlWrapper<T> add(AbstractControlWrapper<T> elem) {
        this.controls.add(elem);
        elem.resetChangeState();
        return elem;
    }

    public AbstractControlWrapper<String> add(JTextComponent component) {
        return this.add(new TextControlWrapper(this, component));
    }

    public <T> AbstractControlWrapper<T> addFixedCombo(ComboBox<T> component, Comparator<T> comparator) {
        return this.add(new FixedComboBoxWrapper<T>(this, component, comparator));
    }

    public AbstractControlWrapper<Object> addEditableCombo(ComboBox<?> component, Comparator<Object> comparator) {
        return this.add(new EditableComboBoxWrapper(this, component, comparator));
    }

    public AbstractControlWrapper<Boolean> add(JCheckBox component) {
        return this.add(new CheckBoxWrapper(this, component));
    }

    public AbstractControlWrapper<TreePath[]> add(JCheckBoxTree component) {
        return this.add(new CheckBoxTreeWrapper(this, component));
    }

    public AbstractControlWrapper<ButtonModel> add(ButtonGroup group) {
        return this.add(new ButtonGroupWrapper(this, group));
    }

    public AbstractControlWrapper<Object> add(JDatePicker picker) {
        return this.add(new DatePickerWrapper(this, picker));
    }

    public AbstractControlWrapper<Object> add(JSpinner spinner) {
        return this.add(new TimeSpinnerWrapper(this, spinner));
    }

    public AbstractControlWrapper<ClonedTableModel> add(JTable table) {
        return this.add(new TableWrapper(this, table));
    }

    public <T> AbstractControlWrapper<T> add(GenericControlWindow<T> editor) {
        return this.add(new GenericControlWrapper<T>(this, editor));
    }

    public boolean wasEverModified() {
        return this.wasEverModified;
    }

    public boolean isCurrentlyModified() {
        return this.isCurrentlyModified;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void reset() {
        boolean oldState = this.wasEverModified;
        this.isCurrentlyModified = false;
        this.wasEverModified = false;
        for (AbstractControlWrapper<?> cw : this.controls) {
            cw.resetChangeState();
        }
        if (this.callback != null && oldState) {
            this.callback.modificationChanged();
        }
    }

    void validityChanged(AbstractControlWrapper<?> cw) {
        String error = null;
        boolean oldValid = this.isValid;
        if (cw.currentError != null) {
            this.isValid = false;
            error = cw.currentError;
        } else {
            this.isValid = true;
        }
        if (error == null) {
            for (AbstractControlWrapper<?> c : this.controls) {
                if (c.currentError == null) continue;
                this.isValid = false;
                error = c.currentError;
                break;
            }
        }
        if (this.callback != null && (this.isValid && !oldValid || error != null)) {
            this.callback.validityChanged(error);
        }
    }

    void contentChanged(AbstractControlWrapper<?> cw) {
        LOGGER.info(cw.getClass().getSimpleName() + " is changed: " + cw.isCurrentlyChanged);
        boolean oldEver = this.wasEverModified;
        boolean oldCurrent = this.isCurrentlyModified;
        this.wasEverModified = false;
        this.isCurrentlyModified = false;
        for (AbstractControlWrapper<?> c : this.controls) {
            if (c.isCurrentlyChanged) {
                this.isCurrentlyModified = true;
                c.wasEverChanged = true;
            }
            if (!c.wasEverChanged) continue;
            this.wasEverModified = true;
        }
        if (this.callback != null && (oldCurrent != this.isCurrentlyModified || oldEver != this.wasEverModified)) {
            this.callback.modificationChanged();
        }
    }

    public static interface Callback {
        public void validityChanged(String var1);

        public void modificationChanged();
    }

    public static class NotNullConstraint<T>
    implements ValidationConstraint<T> {
        private final String errorMsg;

        public NotNullConstraint(String errorMessage) {
            this.errorMsg = errorMessage;
        }

        @Override
        public String checkStateValid(T userInput) {
            if (userInput == null) {
                return this.errorMsg;
            }
            return null;
        }
    }

    public static class TextNotEmptyConstraint
    implements ValidationConstraint<String> {
        private final String errorMsg;

        public TextNotEmptyConstraint(String errorMessage) {
            this.errorMsg = errorMessage;
        }

        @Override
        public String checkStateValid(String userInput) {
            if (Util.isEmptyString(userInput)) {
                return this.errorMsg;
            }
            return null;
        }
    }

    public static interface ValidationConstraint<T> {
        public String checkStateValid(T var1);
    }
}

