/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.changemonitor;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class ClonedTableModel
implements TableModel {
    protected final Object[] grid;
    protected final int columnCount;
    protected final int rowCount;

    protected ClonedTableModel(TableModel other) {
        this.columnCount = other.getColumnCount();
        this.rowCount = other.getRowCount();
        this.grid = new Object[this.columnCount * this.rowCount];
        for (int y = 0; y < this.rowCount; ++y) {
            for (int x = 0; x < this.columnCount; ++x) {
                this.grid[y * this.columnCount + x] = other.getValueAt(y, x);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.grid[columnIndex] == null) {
            return Object.class;
        }
        return this.grid[columnIndex].getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.grid[rowIndex * this.rowCount + this.columnCount];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new RuntimeException("A cloned table model is read only");
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        throw new RuntimeException("A cloned table model is read only");
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        throw new RuntimeException("A cloned table model is read only");
    }
}

