/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.activity;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.activity.ActivityPanel;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.window.CheckUpdateWindow;
import org.openslx.dozmod.util.DesktopEnvironment;

public class UpdatePanel
extends ActivityPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JPanel header;
    protected QLabel lblInfo;
    protected final JButton btnLink;
    protected final JButton btnDetails;
    protected final JButton btnClose;

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    public UpdatePanel(String newVersion) {
        this.setLayout(new BoxLayout(this, 3));
        this.header = new JPanel();
        this.header.setLayout(new BoxLayout(this.header, 2));
        this.lblInfo = new QLabel("Neue Version verf\u00fcgbar: " + newVersion, Gui.getScaledIconResource("/img/upload-icon.png", "!", 32, this), 2);
        this.header.add(this.lblInfo);
        this.header.add(Box.createHorizontalGlue());
        this.btnLink = new JButton("Im Browser \u00f6ffnen", Gui.getScaledIconResource("/img/download-icon.png", "!", 24, this));
        this.btnDetails = new JButton("Changelog", Gui.getScaledIconResource("/img/info-icon.png", "?", 24, this));
        this.btnClose = new JButton("Schlie\u00dfen", Gui.getScaledIconResource("/img/delete-icon.png", "X", 24, this));
        this.btnLink.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.header.add(this.btnLink);
        this.header.add(this.btnDetails);
        this.header.add(this.btnClose);
        this.add(this.header);
        this.btnDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckUpdateWindow.open(SwingUtilities.getWindowAncestor(UpdatePanel.this));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnLink) {
            DesktopEnvironment.openWebpage(DesktopEnvironment.Link.DOZMOD);
            this.close();
        }
        if (e.getSource() == this.btnClose) {
            this.close();
        }
    }
}

