/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.thrift.iface;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.SscMode;

public class SatelliteConfig
implements TBase<SatelliteConfig, _Fields>,
Serializable,
Cloneable,
Comparable<SatelliteConfig> {
    private static final TStruct STRUCT_DESC = new TStruct("SatelliteConfig");
    private static final TField PAGE_SIZE_FIELD_DESC = new TField("pageSize", 8, 1);
    private static final TField DEFAULT_IMAGE_PERMISSIONS_FIELD_DESC = new TField("defaultImagePermissions", 12, 2);
    private static final TField DEFAULT_LECTURE_PERMISSIONS_FIELD_DESC = new TField("defaultLecturePermissions", 12, 3);
    private static final TField MAX_IMAGE_VALIDITY_DAYS_FIELD_DESC = new TField("maxImageValidityDays", 8, 4);
    private static final TField MAX_LECTURE_VALIDITY_DAYS_FIELD_DESC = new TField("maxLectureValidityDays", 8, 5);
    private static final TField MAX_TRANSFERS_FIELD_DESC = new TField("maxTransfers", 8, 6);
    private static final TField MAX_CONNECTIONS_PER_TRANSFER_FIELD_DESC = new TField("maxConnectionsPerTransfer", 8, 7);
    private static final TField MAX_LOCATIONS_PER_LECTURE_FIELD_DESC = new TField("maxLocationsPerLecture", 8, 8);
    private static final TField ALLOW_LOGIN_BY_DEFAULT_FIELD_DESC = new TField("allowLoginByDefault", 2, 9);
    private static final TField SERVER_SIDE_COPY_FIELD_DESC = new TField("serverSideCopy", 8, 10);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public int pageSize;
    public ImagePermissions defaultImagePermissions;
    public LecturePermissions defaultLecturePermissions;
    public int maxImageValidityDays;
    public int maxLectureValidityDays;
    public int maxTransfers;
    public int maxConnectionsPerTransfer;
    public int maxLocationsPerLecture;
    public boolean allowLoginByDefault;
    public SscMode serverSideCopy;
    private static final int __PAGESIZE_ISSET_ID = 0;
    private static final int __MAXIMAGEVALIDITYDAYS_ISSET_ID = 1;
    private static final int __MAXLECTUREVALIDITYDAYS_ISSET_ID = 2;
    private static final int __MAXTRANSFERS_ISSET_ID = 3;
    private static final int __MAXCONNECTIONSPERTRANSFER_ISSET_ID = 4;
    private static final int __MAXLOCATIONSPERLECTURE_ISSET_ID = 5;
    private static final int __ALLOWLOGINBYDEFAULT_ISSET_ID = 6;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public SatelliteConfig() {
    }

    public SatelliteConfig(int pageSize, ImagePermissions defaultImagePermissions, LecturePermissions defaultLecturePermissions, int maxImageValidityDays, int maxLectureValidityDays) {
        this();
        this.pageSize = pageSize;
        this.setPageSizeIsSet(true);
        this.defaultImagePermissions = defaultImagePermissions;
        this.defaultLecturePermissions = defaultLecturePermissions;
        this.maxImageValidityDays = maxImageValidityDays;
        this.setMaxImageValidityDaysIsSet(true);
        this.maxLectureValidityDays = maxLectureValidityDays;
        this.setMaxLectureValidityDaysIsSet(true);
    }

    public SatelliteConfig(SatelliteConfig other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.pageSize = other.pageSize;
        if (other.isSetDefaultImagePermissions()) {
            this.defaultImagePermissions = new ImagePermissions(other.defaultImagePermissions);
        }
        if (other.isSetDefaultLecturePermissions()) {
            this.defaultLecturePermissions = new LecturePermissions(other.defaultLecturePermissions);
        }
        this.maxImageValidityDays = other.maxImageValidityDays;
        this.maxLectureValidityDays = other.maxLectureValidityDays;
        this.maxTransfers = other.maxTransfers;
        this.maxConnectionsPerTransfer = other.maxConnectionsPerTransfer;
        this.maxLocationsPerLecture = other.maxLocationsPerLecture;
        this.allowLoginByDefault = other.allowLoginByDefault;
        if (other.isSetServerSideCopy()) {
            this.serverSideCopy = other.serverSideCopy;
        }
    }

    public SatelliteConfig deepCopy() {
        return new SatelliteConfig(this);
    }

    @Override
    public void clear() {
        this.setPageSizeIsSet(false);
        this.pageSize = 0;
        this.defaultImagePermissions = null;
        this.defaultLecturePermissions = null;
        this.setMaxImageValidityDaysIsSet(false);
        this.maxImageValidityDays = 0;
        this.setMaxLectureValidityDaysIsSet(false);
        this.maxLectureValidityDays = 0;
        this.setMaxTransfersIsSet(false);
        this.maxTransfers = 0;
        this.setMaxConnectionsPerTransferIsSet(false);
        this.maxConnectionsPerTransfer = 0;
        this.setMaxLocationsPerLectureIsSet(false);
        this.maxLocationsPerLecture = 0;
        this.setAllowLoginByDefaultIsSet(false);
        this.allowLoginByDefault = false;
        this.serverSideCopy = null;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public SatelliteConfig setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.setPageSizeIsSet(true);
        return this;
    }

    public void unsetPageSize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetPageSize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setPageSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public ImagePermissions getDefaultImagePermissions() {
        return this.defaultImagePermissions;
    }

    public SatelliteConfig setDefaultImagePermissions(ImagePermissions defaultImagePermissions) {
        this.defaultImagePermissions = defaultImagePermissions;
        return this;
    }

    public void unsetDefaultImagePermissions() {
        this.defaultImagePermissions = null;
    }

    public boolean isSetDefaultImagePermissions() {
        return this.defaultImagePermissions != null;
    }

    public void setDefaultImagePermissionsIsSet(boolean value) {
        if (!value) {
            this.defaultImagePermissions = null;
        }
    }

    public LecturePermissions getDefaultLecturePermissions() {
        return this.defaultLecturePermissions;
    }

    public SatelliteConfig setDefaultLecturePermissions(LecturePermissions defaultLecturePermissions) {
        this.defaultLecturePermissions = defaultLecturePermissions;
        return this;
    }

    public void unsetDefaultLecturePermissions() {
        this.defaultLecturePermissions = null;
    }

    public boolean isSetDefaultLecturePermissions() {
        return this.defaultLecturePermissions != null;
    }

    public void setDefaultLecturePermissionsIsSet(boolean value) {
        if (!value) {
            this.defaultLecturePermissions = null;
        }
    }

    public int getMaxImageValidityDays() {
        return this.maxImageValidityDays;
    }

    public SatelliteConfig setMaxImageValidityDays(int maxImageValidityDays) {
        this.maxImageValidityDays = maxImageValidityDays;
        this.setMaxImageValidityDaysIsSet(true);
        return this;
    }

    public void unsetMaxImageValidityDays() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetMaxImageValidityDays() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setMaxImageValidityDaysIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public int getMaxLectureValidityDays() {
        return this.maxLectureValidityDays;
    }

    public SatelliteConfig setMaxLectureValidityDays(int maxLectureValidityDays) {
        this.maxLectureValidityDays = maxLectureValidityDays;
        this.setMaxLectureValidityDaysIsSet(true);
        return this;
    }

    public void unsetMaxLectureValidityDays() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetMaxLectureValidityDays() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setMaxLectureValidityDaysIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    public int getMaxTransfers() {
        return this.maxTransfers;
    }

    public SatelliteConfig setMaxTransfers(int maxTransfers) {
        this.maxTransfers = maxTransfers;
        this.setMaxTransfersIsSet(true);
        return this;
    }

    public void unsetMaxTransfers() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 3);
    }

    public boolean isSetMaxTransfers() {
        return EncodingUtils.testBit(this.__isset_bitfield, 3);
    }

    public void setMaxTransfersIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 3, value);
    }

    public int getMaxConnectionsPerTransfer() {
        return this.maxConnectionsPerTransfer;
    }

    public SatelliteConfig setMaxConnectionsPerTransfer(int maxConnectionsPerTransfer) {
        this.maxConnectionsPerTransfer = maxConnectionsPerTransfer;
        this.setMaxConnectionsPerTransferIsSet(true);
        return this;
    }

    public void unsetMaxConnectionsPerTransfer() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 4);
    }

    public boolean isSetMaxConnectionsPerTransfer() {
        return EncodingUtils.testBit(this.__isset_bitfield, 4);
    }

    public void setMaxConnectionsPerTransferIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 4, value);
    }

    public int getMaxLocationsPerLecture() {
        return this.maxLocationsPerLecture;
    }

    public SatelliteConfig setMaxLocationsPerLecture(int maxLocationsPerLecture) {
        this.maxLocationsPerLecture = maxLocationsPerLecture;
        this.setMaxLocationsPerLectureIsSet(true);
        return this;
    }

    public void unsetMaxLocationsPerLecture() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 5);
    }

    public boolean isSetMaxLocationsPerLecture() {
        return EncodingUtils.testBit(this.__isset_bitfield, 5);
    }

    public void setMaxLocationsPerLectureIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 5, value);
    }

    public boolean isAllowLoginByDefault() {
        return this.allowLoginByDefault;
    }

    public SatelliteConfig setAllowLoginByDefault(boolean allowLoginByDefault) {
        this.allowLoginByDefault = allowLoginByDefault;
        this.setAllowLoginByDefaultIsSet(true);
        return this;
    }

    public void unsetAllowLoginByDefault() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 6);
    }

    public boolean isSetAllowLoginByDefault() {
        return EncodingUtils.testBit(this.__isset_bitfield, 6);
    }

    public void setAllowLoginByDefaultIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 6, value);
    }

    public SscMode getServerSideCopy() {
        return this.serverSideCopy;
    }

    public SatelliteConfig setServerSideCopy(SscMode serverSideCopy) {
        this.serverSideCopy = serverSideCopy;
        return this;
    }

    public void unsetServerSideCopy() {
        this.serverSideCopy = null;
    }

    public boolean isSetServerSideCopy() {
        return this.serverSideCopy != null;
    }

    public void setServerSideCopyIsSet(boolean value) {
        if (!value) {
            this.serverSideCopy = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case PAGE_SIZE: {
                if (value == null) {
                    this.unsetPageSize();
                    break;
                }
                this.setPageSize((Integer)value);
                break;
            }
            case DEFAULT_IMAGE_PERMISSIONS: {
                if (value == null) {
                    this.unsetDefaultImagePermissions();
                    break;
                }
                this.setDefaultImagePermissions((ImagePermissions)value);
                break;
            }
            case DEFAULT_LECTURE_PERMISSIONS: {
                if (value == null) {
                    this.unsetDefaultLecturePermissions();
                    break;
                }
                this.setDefaultLecturePermissions((LecturePermissions)value);
                break;
            }
            case MAX_IMAGE_VALIDITY_DAYS: {
                if (value == null) {
                    this.unsetMaxImageValidityDays();
                    break;
                }
                this.setMaxImageValidityDays((Integer)value);
                break;
            }
            case MAX_LECTURE_VALIDITY_DAYS: {
                if (value == null) {
                    this.unsetMaxLectureValidityDays();
                    break;
                }
                this.setMaxLectureValidityDays((Integer)value);
                break;
            }
            case MAX_TRANSFERS: {
                if (value == null) {
                    this.unsetMaxTransfers();
                    break;
                }
                this.setMaxTransfers((Integer)value);
                break;
            }
            case MAX_CONNECTIONS_PER_TRANSFER: {
                if (value == null) {
                    this.unsetMaxConnectionsPerTransfer();
                    break;
                }
                this.setMaxConnectionsPerTransfer((Integer)value);
                break;
            }
            case MAX_LOCATIONS_PER_LECTURE: {
                if (value == null) {
                    this.unsetMaxLocationsPerLecture();
                    break;
                }
                this.setMaxLocationsPerLecture((Integer)value);
                break;
            }
            case ALLOW_LOGIN_BY_DEFAULT: {
                if (value == null) {
                    this.unsetAllowLoginByDefault();
                    break;
                }
                this.setAllowLoginByDefault((Boolean)value);
                break;
            }
            case SERVER_SIDE_COPY: {
                if (value == null) {
                    this.unsetServerSideCopy();
                    break;
                }
                this.setServerSideCopy((SscMode)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PAGE_SIZE: {
                return this.getPageSize();
            }
            case DEFAULT_IMAGE_PERMISSIONS: {
                return this.getDefaultImagePermissions();
            }
            case DEFAULT_LECTURE_PERMISSIONS: {
                return this.getDefaultLecturePermissions();
            }
            case MAX_IMAGE_VALIDITY_DAYS: {
                return this.getMaxImageValidityDays();
            }
            case MAX_LECTURE_VALIDITY_DAYS: {
                return this.getMaxLectureValidityDays();
            }
            case MAX_TRANSFERS: {
                return this.getMaxTransfers();
            }
            case MAX_CONNECTIONS_PER_TRANSFER: {
                return this.getMaxConnectionsPerTransfer();
            }
            case MAX_LOCATIONS_PER_LECTURE: {
                return this.getMaxLocationsPerLecture();
            }
            case ALLOW_LOGIN_BY_DEFAULT: {
                return this.isAllowLoginByDefault();
            }
            case SERVER_SIDE_COPY: {
                return this.getServerSideCopy();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PAGE_SIZE: {
                return this.isSetPageSize();
            }
            case DEFAULT_IMAGE_PERMISSIONS: {
                return this.isSetDefaultImagePermissions();
            }
            case DEFAULT_LECTURE_PERMISSIONS: {
                return this.isSetDefaultLecturePermissions();
            }
            case MAX_IMAGE_VALIDITY_DAYS: {
                return this.isSetMaxImageValidityDays();
            }
            case MAX_LECTURE_VALIDITY_DAYS: {
                return this.isSetMaxLectureValidityDays();
            }
            case MAX_TRANSFERS: {
                return this.isSetMaxTransfers();
            }
            case MAX_CONNECTIONS_PER_TRANSFER: {
                return this.isSetMaxConnectionsPerTransfer();
            }
            case MAX_LOCATIONS_PER_LECTURE: {
                return this.isSetMaxLocationsPerLecture();
            }
            case ALLOW_LOGIN_BY_DEFAULT: {
                return this.isSetAllowLoginByDefault();
            }
            case SERVER_SIDE_COPY: {
                return this.isSetServerSideCopy();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof SatelliteConfig) {
            return this.equals((SatelliteConfig)that);
        }
        return false;
    }

    public boolean equals(SatelliteConfig that) {
        if (that == null) {
            return false;
        }
        boolean this_present_pageSize = true;
        boolean that_present_pageSize = true;
        if (this_present_pageSize || that_present_pageSize) {
            if (!this_present_pageSize || !that_present_pageSize) {
                return false;
            }
            if (this.pageSize != that.pageSize) {
                return false;
            }
        }
        boolean this_present_defaultImagePermissions = this.isSetDefaultImagePermissions();
        boolean that_present_defaultImagePermissions = that.isSetDefaultImagePermissions();
        if (this_present_defaultImagePermissions || that_present_defaultImagePermissions) {
            if (!this_present_defaultImagePermissions || !that_present_defaultImagePermissions) {
                return false;
            }
            if (!this.defaultImagePermissions.equals(that.defaultImagePermissions)) {
                return false;
            }
        }
        boolean this_present_defaultLecturePermissions = this.isSetDefaultLecturePermissions();
        boolean that_present_defaultLecturePermissions = that.isSetDefaultLecturePermissions();
        if (this_present_defaultLecturePermissions || that_present_defaultLecturePermissions) {
            if (!this_present_defaultLecturePermissions || !that_present_defaultLecturePermissions) {
                return false;
            }
            if (!this.defaultLecturePermissions.equals(that.defaultLecturePermissions)) {
                return false;
            }
        }
        boolean this_present_maxImageValidityDays = true;
        boolean that_present_maxImageValidityDays = true;
        if (this_present_maxImageValidityDays || that_present_maxImageValidityDays) {
            if (!this_present_maxImageValidityDays || !that_present_maxImageValidityDays) {
                return false;
            }
            if (this.maxImageValidityDays != that.maxImageValidityDays) {
                return false;
            }
        }
        boolean this_present_maxLectureValidityDays = true;
        boolean that_present_maxLectureValidityDays = true;
        if (this_present_maxLectureValidityDays || that_present_maxLectureValidityDays) {
            if (!this_present_maxLectureValidityDays || !that_present_maxLectureValidityDays) {
                return false;
            }
            if (this.maxLectureValidityDays != that.maxLectureValidityDays) {
                return false;
            }
        }
        boolean this_present_maxTransfers = this.isSetMaxTransfers();
        boolean that_present_maxTransfers = that.isSetMaxTransfers();
        if (this_present_maxTransfers || that_present_maxTransfers) {
            if (!this_present_maxTransfers || !that_present_maxTransfers) {
                return false;
            }
            if (this.maxTransfers != that.maxTransfers) {
                return false;
            }
        }
        boolean this_present_maxConnectionsPerTransfer = this.isSetMaxConnectionsPerTransfer();
        boolean that_present_maxConnectionsPerTransfer = that.isSetMaxConnectionsPerTransfer();
        if (this_present_maxConnectionsPerTransfer || that_present_maxConnectionsPerTransfer) {
            if (!this_present_maxConnectionsPerTransfer || !that_present_maxConnectionsPerTransfer) {
                return false;
            }
            if (this.maxConnectionsPerTransfer != that.maxConnectionsPerTransfer) {
                return false;
            }
        }
        boolean this_present_maxLocationsPerLecture = this.isSetMaxLocationsPerLecture();
        boolean that_present_maxLocationsPerLecture = that.isSetMaxLocationsPerLecture();
        if (this_present_maxLocationsPerLecture || that_present_maxLocationsPerLecture) {
            if (!this_present_maxLocationsPerLecture || !that_present_maxLocationsPerLecture) {
                return false;
            }
            if (this.maxLocationsPerLecture != that.maxLocationsPerLecture) {
                return false;
            }
        }
        boolean this_present_allowLoginByDefault = this.isSetAllowLoginByDefault();
        boolean that_present_allowLoginByDefault = that.isSetAllowLoginByDefault();
        if (this_present_allowLoginByDefault || that_present_allowLoginByDefault) {
            if (!this_present_allowLoginByDefault || !that_present_allowLoginByDefault) {
                return false;
            }
            if (this.allowLoginByDefault != that.allowLoginByDefault) {
                return false;
            }
        }
        boolean this_present_serverSideCopy = this.isSetServerSideCopy();
        boolean that_present_serverSideCopy = that.isSetServerSideCopy();
        if (this_present_serverSideCopy || that_present_serverSideCopy) {
            if (!this_present_serverSideCopy || !that_present_serverSideCopy) {
                return false;
            }
            if (!this.serverSideCopy.equals(that.serverSideCopy)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_pageSize = true;
        list.add(Boolean.valueOf(present_pageSize));
        if (present_pageSize) {
            list.add(Integer.valueOf(this.pageSize));
        }
        boolean present_defaultImagePermissions = this.isSetDefaultImagePermissions();
        list.add(Boolean.valueOf(present_defaultImagePermissions));
        if (present_defaultImagePermissions) {
            list.add(this.defaultImagePermissions);
        }
        boolean present_defaultLecturePermissions = this.isSetDefaultLecturePermissions();
        list.add(Boolean.valueOf(present_defaultLecturePermissions));
        if (present_defaultLecturePermissions) {
            list.add(this.defaultLecturePermissions);
        }
        boolean present_maxImageValidityDays = true;
        list.add(Boolean.valueOf(present_maxImageValidityDays));
        if (present_maxImageValidityDays) {
            list.add(Integer.valueOf(this.maxImageValidityDays));
        }
        boolean present_maxLectureValidityDays = true;
        list.add(Boolean.valueOf(present_maxLectureValidityDays));
        if (present_maxLectureValidityDays) {
            list.add(Integer.valueOf(this.maxLectureValidityDays));
        }
        boolean present_maxTransfers = this.isSetMaxTransfers();
        list.add(Boolean.valueOf(present_maxTransfers));
        if (present_maxTransfers) {
            list.add(Integer.valueOf(this.maxTransfers));
        }
        boolean present_maxConnectionsPerTransfer = this.isSetMaxConnectionsPerTransfer();
        list.add(Boolean.valueOf(present_maxConnectionsPerTransfer));
        if (present_maxConnectionsPerTransfer) {
            list.add(Integer.valueOf(this.maxConnectionsPerTransfer));
        }
        boolean present_maxLocationsPerLecture = this.isSetMaxLocationsPerLecture();
        list.add(Boolean.valueOf(present_maxLocationsPerLecture));
        if (present_maxLocationsPerLecture) {
            list.add(Integer.valueOf(this.maxLocationsPerLecture));
        }
        boolean present_allowLoginByDefault = this.isSetAllowLoginByDefault();
        list.add(Boolean.valueOf(present_allowLoginByDefault));
        if (present_allowLoginByDefault) {
            list.add(Boolean.valueOf(this.allowLoginByDefault));
        }
        boolean present_serverSideCopy = this.isSetServerSideCopy();
        list.add(Boolean.valueOf(present_serverSideCopy));
        if (present_serverSideCopy) {
            list.add(Integer.valueOf(this.serverSideCopy.getValue()));
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(SatelliteConfig other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetPageSize()).compareTo(other.isSetPageSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPageSize() && (lastComparison = TBaseHelper.compareTo(this.pageSize, other.pageSize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefaultImagePermissions()).compareTo(other.isSetDefaultImagePermissions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultImagePermissions() && (lastComparison = TBaseHelper.compareTo(this.defaultImagePermissions, other.defaultImagePermissions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefaultLecturePermissions()).compareTo(other.isSetDefaultLecturePermissions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultLecturePermissions() && (lastComparison = TBaseHelper.compareTo(this.defaultLecturePermissions, other.defaultLecturePermissions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxImageValidityDays()).compareTo(other.isSetMaxImageValidityDays());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxImageValidityDays() && (lastComparison = TBaseHelper.compareTo(this.maxImageValidityDays, other.maxImageValidityDays)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxLectureValidityDays()).compareTo(other.isSetMaxLectureValidityDays());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxLectureValidityDays() && (lastComparison = TBaseHelper.compareTo(this.maxLectureValidityDays, other.maxLectureValidityDays)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxTransfers()).compareTo(other.isSetMaxTransfers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxTransfers() && (lastComparison = TBaseHelper.compareTo(this.maxTransfers, other.maxTransfers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxConnectionsPerTransfer()).compareTo(other.isSetMaxConnectionsPerTransfer());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxConnectionsPerTransfer() && (lastComparison = TBaseHelper.compareTo(this.maxConnectionsPerTransfer, other.maxConnectionsPerTransfer)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxLocationsPerLecture()).compareTo(other.isSetMaxLocationsPerLecture());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxLocationsPerLecture() && (lastComparison = TBaseHelper.compareTo(this.maxLocationsPerLecture, other.maxLocationsPerLecture)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAllowLoginByDefault()).compareTo(other.isSetAllowLoginByDefault());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAllowLoginByDefault() && (lastComparison = TBaseHelper.compareTo(this.allowLoginByDefault, other.allowLoginByDefault)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetServerSideCopy()).compareTo(other.isSetServerSideCopy());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetServerSideCopy() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.serverSideCopy), (Comparable)((Object)other.serverSideCopy))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (SatelliteConfig)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (SatelliteConfig)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SatelliteConfig(");
        boolean first = true;
        sb.append("pageSize:");
        sb.append(this.pageSize);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("defaultImagePermissions:");
        if (this.defaultImagePermissions == null) {
            sb.append("null");
        } else {
            sb.append(this.defaultImagePermissions);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("defaultLecturePermissions:");
        if (this.defaultLecturePermissions == null) {
            sb.append("null");
        } else {
            sb.append(this.defaultLecturePermissions);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxImageValidityDays:");
        sb.append(this.maxImageValidityDays);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxLectureValidityDays:");
        sb.append(this.maxLectureValidityDays);
        first = false;
        if (this.isSetMaxTransfers()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxTransfers:");
            sb.append(this.maxTransfers);
            first = false;
        }
        if (this.isSetMaxConnectionsPerTransfer()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxConnectionsPerTransfer:");
            sb.append(this.maxConnectionsPerTransfer);
            first = false;
        }
        if (this.isSetMaxLocationsPerLecture()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxLocationsPerLecture:");
            sb.append(this.maxLocationsPerLecture);
            first = false;
        }
        if (this.isSetAllowLoginByDefault()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("allowLoginByDefault:");
            sb.append(this.allowLoginByDefault);
            first = false;
        }
        if (this.isSetServerSideCopy()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("serverSideCopy:");
            if (this.serverSideCopy == null) {
                sb.append("null");
            } else {
                sb.append(this.serverSideCopy);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.defaultImagePermissions != null) {
            this.defaultImagePermissions.validate();
        }
        if (this.defaultLecturePermissions != null) {
            this.defaultLecturePermissions.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new SatelliteConfigStandardSchemeFactory());
        schemes.put(TupleScheme.class, new SatelliteConfigTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.MAX_TRANSFERS, _Fields.MAX_CONNECTIONS_PER_TRANSFER, _Fields.MAX_LOCATIONS_PER_LECTURE, _Fields.ALLOW_LOGIN_BY_DEFAULT, _Fields.SERVER_SIDE_COPY};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PAGE_SIZE, new FieldMetaData("pageSize", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.DEFAULT_IMAGE_PERMISSIONS, new FieldMetaData("defaultImagePermissions", 3, new StructMetaData(12, ImagePermissions.class)));
        tmpMap.put(_Fields.DEFAULT_LECTURE_PERMISSIONS, new FieldMetaData("defaultLecturePermissions", 3, new StructMetaData(12, LecturePermissions.class)));
        tmpMap.put(_Fields.MAX_IMAGE_VALIDITY_DAYS, new FieldMetaData("maxImageValidityDays", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_LECTURE_VALIDITY_DAYS, new FieldMetaData("maxLectureValidityDays", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_TRANSFERS, new FieldMetaData("maxTransfers", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_CONNECTIONS_PER_TRANSFER, new FieldMetaData("maxConnectionsPerTransfer", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_LOCATIONS_PER_LECTURE, new FieldMetaData("maxLocationsPerLecture", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ALLOW_LOGIN_BY_DEFAULT, new FieldMetaData("allowLoginByDefault", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.SERVER_SIDE_COPY, new FieldMetaData("serverSideCopy", 2, new EnumMetaData(16, SscMode.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(SatelliteConfig.class, metaDataMap);
    }

    private static class SatelliteConfigTupleScheme
    extends TupleScheme<SatelliteConfig> {
        private SatelliteConfigTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, SatelliteConfig struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetPageSize()) {
                optionals.set(0);
            }
            if (struct.isSetDefaultImagePermissions()) {
                optionals.set(1);
            }
            if (struct.isSetDefaultLecturePermissions()) {
                optionals.set(2);
            }
            if (struct.isSetMaxImageValidityDays()) {
                optionals.set(3);
            }
            if (struct.isSetMaxLectureValidityDays()) {
                optionals.set(4);
            }
            if (struct.isSetMaxTransfers()) {
                optionals.set(5);
            }
            if (struct.isSetMaxConnectionsPerTransfer()) {
                optionals.set(6);
            }
            if (struct.isSetMaxLocationsPerLecture()) {
                optionals.set(7);
            }
            if (struct.isSetAllowLoginByDefault()) {
                optionals.set(8);
            }
            if (struct.isSetServerSideCopy()) {
                optionals.set(9);
            }
            oprot.writeBitSet(optionals, 10);
            if (struct.isSetPageSize()) {
                oprot.writeI32(struct.pageSize);
            }
            if (struct.isSetDefaultImagePermissions()) {
                struct.defaultImagePermissions.write(oprot);
            }
            if (struct.isSetDefaultLecturePermissions()) {
                struct.defaultLecturePermissions.write(oprot);
            }
            if (struct.isSetMaxImageValidityDays()) {
                oprot.writeI32(struct.maxImageValidityDays);
            }
            if (struct.isSetMaxLectureValidityDays()) {
                oprot.writeI32(struct.maxLectureValidityDays);
            }
            if (struct.isSetMaxTransfers()) {
                oprot.writeI32(struct.maxTransfers);
            }
            if (struct.isSetMaxConnectionsPerTransfer()) {
                oprot.writeI32(struct.maxConnectionsPerTransfer);
            }
            if (struct.isSetMaxLocationsPerLecture()) {
                oprot.writeI32(struct.maxLocationsPerLecture);
            }
            if (struct.isSetAllowLoginByDefault()) {
                oprot.writeBool(struct.allowLoginByDefault);
            }
            if (struct.isSetServerSideCopy()) {
                oprot.writeI32(struct.serverSideCopy.getValue());
            }
        }

        @Override
        public void read(TProtocol prot, SatelliteConfig struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(10);
            if (incoming.get(0)) {
                struct.pageSize = iprot.readI32();
                struct.setPageSizeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.defaultImagePermissions = new ImagePermissions();
                struct.defaultImagePermissions.read(iprot);
                struct.setDefaultImagePermissionsIsSet(true);
            }
            if (incoming.get(2)) {
                struct.defaultLecturePermissions = new LecturePermissions();
                struct.defaultLecturePermissions.read(iprot);
                struct.setDefaultLecturePermissionsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.maxImageValidityDays = iprot.readI32();
                struct.setMaxImageValidityDaysIsSet(true);
            }
            if (incoming.get(4)) {
                struct.maxLectureValidityDays = iprot.readI32();
                struct.setMaxLectureValidityDaysIsSet(true);
            }
            if (incoming.get(5)) {
                struct.maxTransfers = iprot.readI32();
                struct.setMaxTransfersIsSet(true);
            }
            if (incoming.get(6)) {
                struct.maxConnectionsPerTransfer = iprot.readI32();
                struct.setMaxConnectionsPerTransferIsSet(true);
            }
            if (incoming.get(7)) {
                struct.maxLocationsPerLecture = iprot.readI32();
                struct.setMaxLocationsPerLectureIsSet(true);
            }
            if (incoming.get(8)) {
                struct.allowLoginByDefault = iprot.readBool();
                struct.setAllowLoginByDefaultIsSet(true);
            }
            if (incoming.get(9)) {
                struct.serverSideCopy = SscMode.findByValue(iprot.readI32());
                struct.setServerSideCopyIsSet(true);
            }
        }
    }

    private static class SatelliteConfigTupleSchemeFactory
    implements SchemeFactory {
        private SatelliteConfigTupleSchemeFactory() {
        }

        public SatelliteConfigTupleScheme getScheme() {
            return new SatelliteConfigTupleScheme();
        }
    }

    private static class SatelliteConfigStandardScheme
    extends StandardScheme<SatelliteConfig> {
        private SatelliteConfigStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, SatelliteConfig struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.pageSize = iprot.readI32();
                            struct.setPageSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.defaultImagePermissions = new ImagePermissions();
                            struct.defaultImagePermissions.read(iprot);
                            struct.setDefaultImagePermissionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.defaultLecturePermissions = new LecturePermissions();
                            struct.defaultLecturePermissions.read(iprot);
                            struct.setDefaultLecturePermissionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.maxImageValidityDays = iprot.readI32();
                            struct.setMaxImageValidityDaysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.maxLectureValidityDays = iprot.readI32();
                            struct.setMaxLectureValidityDaysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.maxTransfers = iprot.readI32();
                            struct.setMaxTransfersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.maxConnectionsPerTransfer = iprot.readI32();
                            struct.setMaxConnectionsPerTransferIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.maxLocationsPerLecture = iprot.readI32();
                            struct.setMaxLocationsPerLectureIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 2) {
                            struct.allowLoginByDefault = iprot.readBool();
                            struct.setAllowLoginByDefaultIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.serverSideCopy = SscMode.findByValue(iprot.readI32());
                            struct.setServerSideCopyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, SatelliteConfig struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(PAGE_SIZE_FIELD_DESC);
            oprot.writeI32(struct.pageSize);
            oprot.writeFieldEnd();
            if (struct.defaultImagePermissions != null) {
                oprot.writeFieldBegin(DEFAULT_IMAGE_PERMISSIONS_FIELD_DESC);
                struct.defaultImagePermissions.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.defaultLecturePermissions != null) {
                oprot.writeFieldBegin(DEFAULT_LECTURE_PERMISSIONS_FIELD_DESC);
                struct.defaultLecturePermissions.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(MAX_IMAGE_VALIDITY_DAYS_FIELD_DESC);
            oprot.writeI32(struct.maxImageValidityDays);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_LECTURE_VALIDITY_DAYS_FIELD_DESC);
            oprot.writeI32(struct.maxLectureValidityDays);
            oprot.writeFieldEnd();
            if (struct.isSetMaxTransfers()) {
                oprot.writeFieldBegin(MAX_TRANSFERS_FIELD_DESC);
                oprot.writeI32(struct.maxTransfers);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxConnectionsPerTransfer()) {
                oprot.writeFieldBegin(MAX_CONNECTIONS_PER_TRANSFER_FIELD_DESC);
                oprot.writeI32(struct.maxConnectionsPerTransfer);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxLocationsPerLecture()) {
                oprot.writeFieldBegin(MAX_LOCATIONS_PER_LECTURE_FIELD_DESC);
                oprot.writeI32(struct.maxLocationsPerLecture);
                oprot.writeFieldEnd();
            }
            if (struct.isSetAllowLoginByDefault()) {
                oprot.writeFieldBegin(ALLOW_LOGIN_BY_DEFAULT_FIELD_DESC);
                oprot.writeBool(struct.allowLoginByDefault);
                oprot.writeFieldEnd();
            }
            if (struct.serverSideCopy != null && struct.isSetServerSideCopy()) {
                oprot.writeFieldBegin(SERVER_SIDE_COPY_FIELD_DESC);
                oprot.writeI32(struct.serverSideCopy.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SatelliteConfigStandardSchemeFactory
    implements SchemeFactory {
        private SatelliteConfigStandardSchemeFactory() {
        }

        public SatelliteConfigStandardScheme getScheme() {
            return new SatelliteConfigStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PAGE_SIZE(1, "pageSize"),
        DEFAULT_IMAGE_PERMISSIONS(2, "defaultImagePermissions"),
        DEFAULT_LECTURE_PERMISSIONS(3, "defaultLecturePermissions"),
        MAX_IMAGE_VALIDITY_DAYS(4, "maxImageValidityDays"),
        MAX_LECTURE_VALIDITY_DAYS(5, "maxLectureValidityDays"),
        MAX_TRANSFERS(6, "maxTransfers"),
        MAX_CONNECTIONS_PER_TRANSFER(7, "maxConnectionsPerTransfer"),
        MAX_LOCATIONS_PER_LECTURE(8, "maxLocationsPerLecture"),
        ALLOW_LOGIN_BY_DEFAULT(9, "allowLoginByDefault"),
        SERVER_SIDE_COPY(10, "serverSideCopy");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PAGE_SIZE;
                }
                case 2: {
                    return DEFAULT_IMAGE_PERMISSIONS;
                }
                case 3: {
                    return DEFAULT_LECTURE_PERMISSIONS;
                }
                case 4: {
                    return MAX_IMAGE_VALIDITY_DAYS;
                }
                case 5: {
                    return MAX_LECTURE_VALIDITY_DAYS;
                }
                case 6: {
                    return MAX_TRANSFERS;
                }
                case 7: {
                    return MAX_CONNECTIONS_PER_TRANSFER;
                }
                case 8: {
                    return MAX_LOCATIONS_PER_LECTURE;
                }
                case 9: {
                    return ALLOW_LOGIN_BY_DEFAULT;
                }
                case 10: {
                    return SERVER_SIDE_COPY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

