/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.pac;

import com.btr.proxy.selector.pac.JavaxPacScriptParser;
import com.btr.proxy.selector.pac.PacScriptParser;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.ProxyEvaluationException;
import com.btr.proxy.selector.pac.ScriptAvailability;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.MiscUtil;
import com.btr.proxy.util.ProxyUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PacProxySelector
extends ProxySelector {
    private final boolean JAVAX_PARSER = ScriptAvailability.isJavaxScriptingAvailable();
    private static final String PAC_SOCKS = "SOCKS";
    private static final String PAC_DIRECT = "DIRECT";
    private PacScriptParser pacScriptParser;
    private static volatile boolean enabled = true;

    public PacProxySelector(PacScriptSource pacSource) {
        this.selectEngine(pacSource);
    }

    public static void setEnabled(boolean enable) {
        enabled = enable;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private void selectEngine(PacScriptSource pacSource) {
        try {
            if (this.JAVAX_PARSER) {
                Logger.log(this.getClass(), Logger.LogLevel.INFO, "Using javax.script JavaScript engine.", new Object[0]);
                this.pacScriptParser = new JavaxPacScriptParser(pacSource);
            } else {
                Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Rhino JavaScript engine support dropped. javax JS should be available unless you're still running Java 1.5.", new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "PAC parser error.", e);
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null.");
        }
        if (!enabled) {
            return ProxyUtil.noProxyList();
        }
        return this.findProxy(uri);
    }

    private List<Proxy> findProxy(URI uri) {
        try {
            String[] proxyDefinitions;
            ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            String parseResult = this.pacScriptParser.evaluate(uri.toString(), uri.getHost());
            if (parseResult == null) {
                return ProxyUtil.noProxyList();
            }
            for (String proxyDef : proxyDefinitions = parseResult.split("[;]")) {
                if (proxyDef.trim().length() <= 0) continue;
                Proxy proxy = this.buildProxyFromPacResult(proxyDef);
                if (proxy.type() == Proxy.Type.SOCKS) {
                    if (!proxies.isEmpty() && ((Proxy)proxies.get(0)).type() == Proxy.Type.DIRECT) {
                        proxies.add(1, proxy);
                        continue;
                    }
                    proxies.add(0, proxy);
                    continue;
                }
                proxies.add(proxy);
            }
            return proxies;
        }
        catch (ProxyEvaluationException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "PAC resolving error.", e);
            return ProxyUtil.noProxyList();
        }
    }

    private Proxy buildProxyFromPacResult(String pacResult) {
        String host;
        int indexOfPort;
        if (pacResult == null || pacResult.trim().length() < 6) {
            return Proxy.NO_PROXY;
        }
        String proxyDef = pacResult.trim();
        if (proxyDef.toUpperCase().startsWith(PAC_DIRECT)) {
            return Proxy.NO_PROXY;
        }
        Proxy.Type type = Proxy.Type.HTTP;
        Integer port = 80;
        if (proxyDef.toUpperCase().startsWith(PAC_SOCKS)) {
            type = Proxy.Type.SOCKS;
            port = 1080;
        }
        if ((indexOfPort = (host = proxyDef.substring(6).trim()).indexOf(58)) != -1) {
            port = MiscUtil.parseInt(host.substring(indexOfPort + 1).trim());
            host = host.substring(0, indexOfPort).trim();
        }
        if (port < 0 || port > 65535) {
            return Proxy.NO_PROXY;
        }
        InetSocketAddress adr = InetSocketAddress.createUnresolved(host, port);
        return new Proxy(type, adr);
    }
}

