/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util.vm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.util.vm.DiskImage;
import org.openslx.util.vm.UnsupportedVirtualizerFormatException;
import org.openslx.util.vm.VBoxDDAccelMeta;
import org.openslx.util.vm.VBoxEthernetDevTypeMeta;
import org.openslx.util.vm.VBoxHWVersionMeta;
import org.openslx.util.vm.VBoxSoundCardMeta;
import org.openslx.util.vm.VmMetaData;

public class QemuMetaData
extends VmMetaData<VBoxSoundCardMeta, VBoxDDAccelMeta, VBoxHWVersionMeta, VBoxEthernetDevTypeMeta> {
    private final Map<String, String> arguments = new HashMap<String, String>();
    private String config;
    private static final Logger LOGGER = Logger.getLogger(QemuMetaData.class);
    private static final Virtualizer virtualizer = new Virtualizer("qemukvm", "QEMU-KVM");

    public QemuMetaData(List<OperatingSystem> osList, File file) throws FileNotFoundException, IOException, UnsupportedVirtualizerFormatException {
        super(osList);
        DiskImage di;
        try {
            di = new DiskImage(file);
        }
        catch (DiskImage.UnknownImageFormatException e) {
            di = null;
        }
        if (di == null || di.format != DiskImage.ImageFormat.QCOW2) {
            throw new UnsupportedVirtualizerFormatException("This is not a qcow2 disk image");
        }
        this.config = "qemu-system-i386 <args> <image> -enable-kvm \n\r qemu-system-x86_64 <args> <image> -enable-kvm";
        this.displayName = file.getName().substring(0, file.getName().indexOf("."));
        this.setOs("anyOs");
        this.hdds.add(new VmMetaData.HardDisk("anychipset", VmMetaData.DriveBusType.IDE, file.getAbsolutePath()));
        this.makeStartSequence();
    }

    public void makeStartSequence() {
        this.arguments.put("cpu", "host");
        this.arguments.put("smp", "2");
        this.arguments.put("m", "1024");
        this.arguments.put("vga", "std");
    }

    private String configWithArgs() {
        String tempString = "";
        for (String key : this.arguments.keySet()) {
            tempString = tempString + "-" + key + " " + this.arguments.get(key) + " ";
        }
        return this.config.replaceAll("<args>", tempString);
    }

    @Override
    public byte[] getFilteredDefinitionArray() {
        return this.configWithArgs().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void applySettingsForLocalEdit() {
    }

    @Override
    public boolean addHddTemplate(File diskImage, String hddMode, String redoDir) {
        String tempS;
        this.config = tempS = this.config.replaceAll("<image>", diskImage.getAbsolutePath());
        this.hdds.add(new VmMetaData.HardDisk("anychipset", VmMetaData.DriveBusType.IDE, diskImage.getAbsolutePath()));
        return true;
    }

    @Override
    public boolean addHddTemplate(String diskImagePath, String hddMode, String redoDir) {
        String tempS;
        this.config = tempS = this.config.replaceAll("<image>", diskImagePath);
        this.hdds.add(new VmMetaData.HardDisk("anychipset", VmMetaData.DriveBusType.IDE, diskImagePath));
        return true;
    }

    @Override
    public boolean addDefaultNat() {
        return true;
    }

    @Override
    public void setOs(String vendorOsId) {
        this.setOs("qemukvm", vendorOsId);
    }

    @Override
    public boolean addDisplayName(String name) {
        return false;
    }

    @Override
    public boolean addRam(int mem) {
        this.arguments.put("m", Integer.toString(mem));
        return true;
    }

    @Override
    public void addFloppy(int index, String image, boolean readOnly) {
    }

    @Override
    public boolean addCdrom(String image) {
        return false;
    }

    @Override
    public boolean addCpuCoreCount(int nrOfCores) {
        this.arguments.put("smp", Integer.toString(nrOfCores));
        return true;
    }

    @Override
    public void setSoundCard(VmMetaData.SoundCardType type) {
    }

    @Override
    public VmMetaData.SoundCardType getSoundCard() {
        return null;
    }

    @Override
    public void setDDAcceleration(VmMetaData.DDAcceleration type) {
    }

    @Override
    public VmMetaData.DDAcceleration getDDAcceleration() {
        return null;
    }

    @Override
    public void setHWVersion(VmMetaData.HWVersion type) {
    }

    @Override
    public VmMetaData.HWVersion getHWVersion() {
        return null;
    }

    @Override
    public void setEthernetDevType(int cardIndex, VmMetaData.EthernetDevType type) {
    }

    @Override
    public VmMetaData.EthernetDevType getEthernetDevType(int cardIndex) {
        return null;
    }

    @Override
    public byte[] getDefinitionArray() {
        return this.configWithArgs().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean addEthernet(VmMetaData.EtherType type) {
        return false;
    }

    @Override
    public Virtualizer getVirtualizer() {
        return virtualizer;
    }

    @Override
    public void enableUsb(boolean enabled) {
        if (enabled) {
            this.arguments.put("usb", "");
        } else {
            this.arguments.remove("usb");
        }
    }

    @Override
    public boolean disableSuspend() {
        return false;
    }

    @Override
    public void registerVirtualHW() {
    }
}

