/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.thrifthelper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.openslx.thrifthelper.ThriftManager;

class ThriftHandler<T extends TServiceClient>
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(ThriftHandler.class);
    private final Deque<T> pool = new ArrayDeque<T>();
    private final WantClientCallback<? extends T> callback;
    private final ThriftManager.ErrorCallback errorCallback;
    private final Set<String> thriftMethods;

    public ThriftHandler(Class<? extends T> clazz, WantClientCallback<? extends T> cb, ThriftManager.ErrorCallback errCb) {
        this.errorCallback = errCb;
        this.callback = cb;
        HashSet<String> tmpset = new HashSet<String>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean thrift = false;
            Class<?>[] type = methods[i].getExceptionTypes();
            for (int e = 0; e < type.length; ++e) {
                if (!TException.class.isAssignableFrom(type[e])) continue;
                thrift = true;
            }
            String name = methods[i].getName();
            if (!thrift || name.startsWith("send_") || name.startsWith("recv_")) continue;
            tmpset.add(name);
        }
        this.thriftMethods = Collections.unmodifiableSet(tmpset);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object invoke(Object tproxy, Method method, Object[] args) throws Throwable {
        if (!this.thriftMethods.contains(method.getName())) {
            throw new IllegalAccessException("Cannot call this method on a proxied thrift client");
        }
        client = this.getClient();
        try {
            cause = null;
            i = 1;
            while (true) {
                if (client == null) ** GOTO lbl21
                try {
                    var7_8 = method.invoke(client, args);
                    return var7_8;
                }
                catch (InvocationTargetException e) {
                    cause = e.getCause();
                    if (cause != null && !(cause instanceof TException)) {
                        throw cause;
                    }
                    this.freeClient(client);
                    client = null;
                    if (cause == null) {
                        cause = e;
                    }
lbl21:
                    // 4 sources

                    if (this.errorCallback.thriftError(i, method.getName(), cause)) {
                        if (client == null) {
                            client = this.getClient();
                            cause = null;
                        }
                        ++i;
                        continue;
                    }
                    if (cause != null) {
                        throw cause;
                    }
                    throw new TTransportException("Could not connect");
                }
                break;
            }
        }
        finally {
            this.returnClient(client);
        }
    }

    private void freeClient(T client) {
        try {
            ((TServiceClient)client).getInputProtocol().getTransport().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((TServiceClient)client).getOutputProtocol().getTransport().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getClient() {
        Deque<T> deque = this.pool;
        synchronized (deque) {
            TServiceClient client = (TServiceClient)this.pool.poll();
            if (client != null) {
                return (T)client;
            }
        }
        LOGGER.debug("Creating new thrift client");
        return (T)((TServiceClient)this.callback.getNewClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnClient(T client) {
        if (client == null) {
            return;
        }
        Deque<T> deque = this.pool;
        synchronized (deque) {
            this.pool.push(client);
        }
    }

    protected static interface WantClientCallback<T> {
        public T getNewClient();
    }
}

