/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.thrifthelper;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public class TBinaryProtocolSafe
extends TBinaryProtocol {
    private static final int maxLen = 0xC00000;

    public TBinaryProtocolSafe(TTransport trans) {
        this(trans, false, true);
    }

    public TBinaryProtocolSafe(TTransport trans, boolean strictRead, boolean strictWrite) {
        super(trans);
        this.strictRead_ = strictRead;
        this.strictWrite_ = strictWrite;
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        int size = this.readI32();
        if (size > 0xC00000) {
            throw new TProtocolException(3, "Payload too big.");
        }
        if (size < 0) {
            int version = size & 0xFFFF0000;
            if (version != -2147418112) {
                throw new TProtocolException(4, "Bad version in readMessageBegin");
            }
            return new TMessage(this.readString(), (byte)(size & 0xFF), this.readI32());
        }
        if (this.strictRead_) {
            throw new TProtocolException(4, "Missing version in readMessageBegin, old client?");
        }
        return new TMessage(this.readStringBody(size), this.readByte(), this.readI32());
    }

    @Override
    public String readString() throws TException {
        int size = this.readI32();
        if (size > 0xC00000) {
            throw new TProtocolException(3, "Payload too big.");
        }
        if (this.trans_.getBytesRemainingInBuffer() >= size) {
            try {
                String s = new String(this.trans_.getBuffer(), this.trans_.getBufferPosition(), size, "UTF-8");
                this.trans_.consumeBuffer(size);
                return s;
            }
            catch (UnsupportedEncodingException e) {
                throw new TException("JVM DOES NOT SUPPORT UTF-8");
            }
        }
        return this.readStringBody(size);
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        int size = this.readI32();
        if (size > 0xC00000) {
            throw new TProtocolException(3, "Payload too big.");
        }
        if (this.trans_.getBytesRemainingInBuffer() >= size) {
            ByteBuffer bb = ByteBuffer.wrap(this.trans_.getBuffer(), this.trans_.getBufferPosition(), size);
            this.trans_.consumeBuffer(size);
            return bb;
        }
        byte[] buf = new byte[size];
        this.trans_.readAll(buf, 0, size);
        return ByteBuffer.wrap(buf);
    }

    public static class Factory
    implements TProtocolFactory {
        protected boolean strictRead_ = false;
        protected boolean strictWrite_ = true;

        public Factory() {
            this(false, true);
        }

        public Factory(boolean strictRead, boolean strictWrite) {
            this.strictRead_ = strictRead;
            this.strictWrite_ = strictWrite;
        }

        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TBinaryProtocolSafe(trans, this.strictRead_, this.strictWrite_);
        }
    }
}

