/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.encryption;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;

public class AsymEncryptionHandler {
    private static final Logger LOG = Logger.getLogger(AsymEncryptionHandler.class);
    private final Key key;

    public AsymEncryptionHandler(Key key) {
        this.key = key;
    }

    public byte[] encryptMessage(byte[] cleartext) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, this.key);
            return cipher.doFinal(cleartext);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.warn("Cannot encrypt message", e);
            return null;
        }
    }

    public boolean verifyMessage(byte[] encryptedMessage, byte[] expectedCleartext) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, this.key);
            byte[] result = cipher.doFinal(encryptedMessage);
            return Arrays.equals(expectedCleartext, result);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.warn("Cannot verify message", e);
            return false;
        }
    }

    public static KeyPair generateKeyPair(int bits) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(bits);
            return kpg.genKeyPair();
        }
        catch (InvalidParameterException | NoSuchAlgorithmException e) {
            LOG.warn("Cannot generate RSA Keypair", e);
            return null;
        }
    }
}

