/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.util;

import java.util.Map;
import org.apache.log4j.Logger;

public class MapHelper {
    private static final Logger LOGGER = Logger.getLogger(MapHelper.class);

    private MapHelper() {
    }

    public static <K, T> boolean hasChanged(Map<K, T> oldMap, Map<K, T> newMap) {
        return MapHelper.compare(oldMap, newMap) != 0;
    }

    public static <K, T> int compare(Map<K, T> oldMap, Map<K, T> newMap) {
        if (oldMap == null && newMap == null) {
            return 0;
        }
        if (oldMap == null) {
            return -1;
        }
        if (newMap == null) {
            return 1;
        }
        if (oldMap.size() != newMap.size()) {
            return oldMap.size() - newMap.size();
        }
        int retval = 0;
        for (Map.Entry<K, T> entry : oldMap.entrySet()) {
            T current = entry.getValue();
            T other = newMap.get(entry.getKey());
            if (other == null) {
                --retval;
                continue;
            }
            retval += current.hashCode() - other.hashCode();
        }
        return retval;
    }
}

