/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.layout;

import java.util.Calendar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DateFormatter;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.QDatePickerImpl;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.WizardPage;

public abstract class LectureCreationPageLayout
extends WizardPage {
    protected final JTextField txtName;
    protected final JTextArea txtDescription;
    protected final QDatePickerImpl dtpStartDate;
    protected final QDatePickerImpl dtpEndDate;
    protected final JSpinner spnStartTime;
    protected final JSpinner spnEndTime;
    protected final QLabel lblCalcPeriod;

    public LectureCreationPageLayout(Wizard wizard, String title) {
        super(wizard, title);
        this.setDescription("Geben Sie bitte einen aussagekr\u00e4ftigen Namen f\u00fcr die neue Veranstaltung ein.");
        GridManager grid = new GridManager(this, 3);
        this.txtName = new JTextField();
        grid.add(new QLabel("Veranstaltungsname"));
        grid.add(this.txtName, 2).fill(true, false).expand(true, false);
        grid.nextRow();
        this.txtDescription = new JTextArea(3, 50);
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        JScrollPane descPane = new JScrollPane(this.txtDescription, 22, 31);
        this.txtDescription.setMinimumSize(Gui.getScaledDimension(0, 60));
        descPane.setMinimumSize(this.txtDescription.getMinimumSize());
        grid.add(new QLabel("Beschreibung"));
        grid.add(descPane, 2).fill(true, false).expand(true, false);
        grid.nextRow();
        this.dtpStartDate = new QDatePickerImpl();
        this.spnStartTime = this.makeTimeSpinner(0, 0);
        grid.add(new QLabel("Startdatum"));
        grid.add(this.dtpStartDate).fill(true, false).expand(true, false);
        grid.add(this.spnStartTime);
        grid.nextRow();
        this.dtpEndDate = new QDatePickerImpl();
        this.spnEndTime = this.makeTimeSpinner(23, 59);
        grid.add(new QLabel("Enddatum"));
        grid.add(this.dtpEndDate).fill(true, false).expand(true, false);
        grid.add(this.spnEndTime);
        grid.nextRow();
        grid.add(new QLabel("Dauer der Veranstaltung: "));
        this.lblCalcPeriod = new QLabel();
        grid.add(this.lblCalcPeriod, 2);
        grid.nextRow();
        grid.finish(true);
    }

    private JSpinner makeTimeSpinner(int h, int m) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, h);
        calendar.set(12, m);
        calendar.set(13, 0);
        SpinnerDateModel model = new SpinnerDateModel();
        model.setValue(calendar.getTime());
        JSpinner spinner = new JSpinner(model);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(spinner, "HH:mm");
        DateFormatter formatter = (DateFormatter)editor.getTextField().getFormatter();
        formatter.setAllowsInvalid(false);
        formatter.setOverwriteMode(true);
        spinner.setEditor(editor);
        return spinner;
    }
}

