/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.ShareMode;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.configurator.ImagePermissionConfigurator;
import org.openslx.dozmod.gui.control.ComboBox;
import org.openslx.dozmod.gui.control.PersonLabel;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.control.table.ImageVersionTable;
import org.openslx.dozmod.gui.control.table.QScrollPane;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.thrifthelper.Comparators;

public abstract class ImageDetailsWindowLayout
extends JDialog {
    private static final int ICON_SIZE_Y = 24;
    protected final JTextField txtTitle;
    protected final JTextArea txtDescription;
    protected QLabel lblError;
    protected final PersonLabel lblOwner;
    protected final JButton btnChangeOwner;
    protected final QLabel lblCreateTime;
    protected final PersonLabel lblUpdater;
    protected final QLabel lblUpdateTime;
    protected final ComboBox<OperatingSystem> cboOperatingSystem;
    protected final QLabel lblVirtualizer;
    protected final JTextField txtTags;
    protected final JCheckBox chkIsTemplate;
    protected final ComboBox<ShareMode> cboShareMode;
    protected final JTextField txtId;
    protected final JTextField txtVersion;
    protected final JButton btnSaveChanges;
    protected final JButton btnUpdateImage;
    protected final JButton btnUploadToMaster;
    protected final JButton btnClose;
    protected final JCheckBox chkDefaultPermAdmin;
    protected final JCheckBox chkDefaultPermEdit;
    protected final JCheckBox chkDefaultPermDownload;
    protected final JCheckBox chkDefaultPermLink;
    protected final JButton btnShowLinkingLectures;
    protected final QLabel lblLinkedLectureCount;
    protected final ImageVersionTable tblVersions;
    protected final QScrollPane scpVersions;
    protected JTabbedPane pnlTabs;
    protected ImagePermissionConfigurator ctlImagePermissionConfigurator;
    private static String infoTextDefPerms = "<html><body style='width:100%'>Hier k\u00f6nnen Sie Rechte f\u00fcr nicht in der Liste angegebene Nutzer festlegen:</body></html>";

    public ImageDetailsWindowLayout(Frame modalParent) {
        super((Window)modalParent, "<init>", Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setPreferredSize(Gui.getScaledDimension(630, 680));
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel pnlTabOverview = new JPanel();
        GridManager grid = new GridManager(pnlTabOverview, 3, true, new Insets(2, 2, 2, 2));
        this.txtTitle = new JTextField();
        this.txtTitle.setFont(this.txtTitle.getFont().deriveFont(1, this.txtTitle.getFont().getSize2D() * 1.4f));
        grid.add(this.txtTitle, 3).expand(true, false).fill(true, false);
        grid.nextRow();
        this.txtDescription = new JTextArea();
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        grid.add((Component)new QLabel((String)"Beschreibung")).anchor = 23;
        JScrollPane jsp = new JScrollPane(this.txtDescription, 20, 31);
        jsp.setMinimumSize(Gui.getScaledDimension(0, 110));
        jsp.setPreferredSize(Gui.getScaledDimension(0, 110));
        grid.add(jsp, 2).expand(true, true).fill(true, true);
        grid.nextRow();
        this.lblOwner = new PersonLabel();
        this.btnChangeOwner = new JButton("\u00c4ndern");
        grid.add(new QLabel("Besitzer"));
        grid.add(this.lblOwner).expand(true, false);
        grid.add(this.btnChangeOwner).fill(true, false);
        grid.nextRow();
        this.lblCreateTime = new QLabel();
        grid.add(new QLabel("Erstellt am"));
        grid.add(this.lblCreateTime, 2);
        grid.nextRow();
        this.lblUpdater = new PersonLabel();
        grid.add(new QLabel("Ge\u00e4ndert durch"));
        grid.add(this.lblUpdater, 2);
        grid.nextRow();
        this.lblUpdateTime = new QLabel();
        grid.add(new QLabel("Ge\u00e4ndert am"));
        grid.add(this.lblUpdateTime, 2);
        grid.nextRow();
        this.cboOperatingSystem = new ComboBox<OperatingSystem>(Comparators.operatingSystem, new ComboBox.ComboBoxRenderer<OperatingSystem>(){

            @Override
            public String renderItem(OperatingSystem item) {
                if (item == null) {
                    return null;
                }
                return item.getOsName();
            }
        });
        this.cboOperatingSystem.setEditable(false);
        grid.add(new QLabel("Betriebssystem"));
        grid.add(this.cboOperatingSystem, 2).expand(true, false).fill(true, false);
        grid.nextRow();
        this.txtTags = new JTextField();
        this.cboShareMode = new ComboBox<ShareMode>(new ComboBox.ComboBoxRenderer<ShareMode>(){

            @Override
            public String renderItem(ShareMode item) {
                if (item == null) {
                    return "null";
                }
                return item.name();
            }
        });
        grid.add(new QLabel("Freigabemodus"));
        grid.add(this.cboShareMode, 2).expand(true, false).fill(true, false);
        grid.nextRow();
        this.chkIsTemplate = new JCheckBox("Vorlage");
        grid.add(Box.createGlue());
        grid.add(this.chkIsTemplate, 2);
        grid.nextRow();
        this.txtVersion = new JTextField();
        grid.add(new QLabel("Versions-ID"));
        grid.add(this.txtVersion, 2).expand(true, false).fill(true, false);
        grid.nextRow();
        this.txtId = new JTextField();
        this.txtId.setEditable(false);
        grid.add(new QLabel("VM-ID"));
        grid.add(this.txtId, 2).expand(true, false).fill(true, false);
        grid.nextRow();
        this.lblVirtualizer = new QLabel();
        grid.add(new QLabel("Virtualisierer"));
        grid.add(this.lblVirtualizer, 2).expand(true, false).fill(true, false);
        grid.nextRow();
        grid.add(new QLabel("Veranstaltungen"));
        this.lblLinkedLectureCount = new QLabel();
        grid.add(this.lblLinkedLectureCount).expand(true, false);
        this.btnShowLinkingLectures = new JButton("Anzeigen");
        grid.add(this.btnShowLinkingLectures).fill(true, false);
        grid.nextRow();
        grid.add(Box.createVerticalGlue(), 3).expand(true, true).fill(true, true);
        grid.nextRow();
        JPanel buttonBar = new JPanel();
        BoxLayout buttons = new BoxLayout(buttonBar, 2);
        buttonBar.setLayout(buttons);
        this.btnUpdateImage = new JButton("Neue VM-Version hochladen", Gui.getScaledIconResource("/img/upload-icon.png", "New VM", 24, buttonBar));
        buttonBar.add(this.btnUpdateImage);
        this.btnUploadToMaster = new JButton("Landesweit ver\u00f6ffentlichen", Gui.getScaledIconResource("/img/publish-icon.png", "Publish VM", 24, buttonBar));
        buttonBar.add(this.btnUploadToMaster);
        grid.add(buttonBar, 3).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.finish(false);
        JPanel pnlTabVersions = new JPanel();
        this.tblVersions = new ImageVersionTable();
        this.scpVersions = new QScrollPane(this.tblVersions);
        GridManager grdVersions = new GridManager(pnlTabVersions, 1, false, new Insets(8, 2, 8, 2));
        grdVersions.add(this.scpVersions).fill(true, true).expand(true, true);
        grdVersions.finish(false);
        JPanel pnlTabPermissions = new JPanel();
        this.ctlImagePermissionConfigurator = new ImagePermissionConfigurator();
        GridManager grdImagePermissionConfigurator = new GridManager(pnlTabPermissions, 1, false, new Insets(8, 2, 8, 2));
        grdImagePermissionConfigurator.add(this.ctlImagePermissionConfigurator).fill(true, true).expand(true, true);
        JPanel defaultPermissionPane = new JPanel();
        defaultPermissionPane.setBorder(BorderFactory.createTitledBorder("Andere Nutzer"));
        defaultPermissionPane.setLayout(new BoxLayout(defaultPermissionPane, 3));
        JLabel txtDefaultPerms = new JLabel(infoTextDefPerms);
        JPanel txtDefaultPermsPanel = new JPanel();
        txtDefaultPermsPanel.setLayout(new BoxLayout(txtDefaultPermsPanel, 2));
        txtDefaultPermsPanel.add(txtDefaultPerms);
        JPanel defaultPermsSubPanel = new JPanel();
        defaultPermsSubPanel.setLayout(new BoxLayout(defaultPermsSubPanel, 2));
        this.chkDefaultPermAdmin = new JCheckBox("Admin");
        this.chkDefaultPermDownload = new JCheckBox("Download");
        this.chkDefaultPermEdit = new JCheckBox("Bearbeiten");
        this.chkDefaultPermLink = new JCheckBox("Verlinken");
        defaultPermsSubPanel.add(this.chkDefaultPermLink);
        defaultPermsSubPanel.add(this.chkDefaultPermDownload);
        defaultPermsSubPanel.add(this.chkDefaultPermEdit);
        defaultPermsSubPanel.add(this.chkDefaultPermAdmin);
        defaultPermissionPane.add(txtDefaultPermsPanel);
        defaultPermissionPane.add(Box.createVerticalStrut(10));
        defaultPermissionPane.add(defaultPermsSubPanel);
        grdImagePermissionConfigurator.add(defaultPermissionPane).fill(true, false).expand(false, false);
        grdImagePermissionConfigurator.finish(false);
        JPanel pnlButtons = new JPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        pnlButtons.setLayout(new BoxLayout(pnlButtons, 2));
        this.btnSaveChanges = new JButton("Speichern");
        this.btnClose = new JButton("Schlie\u00dfen");
        this.lblError = new QLabel("");
        this.lblError.setForeground(Color.RED);
        pnlButtons.add(this.lblError);
        pnlButtons.add(Box.createGlue());
        pnlButtons.add(this.btnClose);
        pnlButtons.add(this.btnSaveChanges);
        this.pnlTabs = new JTabbedPane();
        this.pnlTabs.addTab("\u00dcbersicht", pnlTabOverview);
        this.pnlTabs.addTab("VM-Versionen", pnlTabVersions);
        this.pnlTabs.addTab("Berechtigungen", pnlTabPermissions);
        this.add((Component)this.pnlTabs, "Center");
        this.add((Component)pnlButtons, "Last");
    }
}

