/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.Organization;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.ImageDetailsWindow;
import org.openslx.dozmod.gui.window.layout.ImagePublishedWindowLayout;
import org.openslx.dozmod.thrift.ImagePublishedDetailsActions;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.dozmod.thrift.cache.ImagePublishedCache;
import org.openslx.dozmod.thrift.cache.OrganizationCache;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.sat.thrift.version.Feature;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class ImagePublishedWindow
extends ImagePublishedWindowLayout
implements UiFeedback,
ThriftActions.DownloadCallback {
    private static final Logger LOGGER = Logger.getLogger(ImagePublishedWindow.class);
    private final ImagePublishedWindow me = this;
    private Pattern searchFieldPattern = null;
    private final RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer> filterSearchTerm = new RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>(){

        @Override
        public boolean include(RowFilter.Entry<? extends ListTable.ListModel<ImageSummaryRead>, ? extends Integer> entry) {
            ImageSummaryRead image = (ImageSummaryRead)ImagePublishedWindow.this.imagePublishedTable.getModelRow(entry.getIdentifier());
            if (ImagePublishedWindow.this.searchFieldPattern.matcher(image.imageName).find()) {
                return true;
            }
            UserInfo user = UserCache.find(image.ownerId);
            if (user == null) {
                return false;
            }
            if (ImagePublishedWindow.this.searchFieldPattern.matcher(user.firstName).find()) {
                return true;
            }
            if (ImagePublishedWindow.this.searchFieldPattern.matcher(user.lastName).find()) {
                return true;
            }
            if (ImagePublishedWindow.this.searchFieldPattern.matcher(user.eMail).find()) {
                return true;
            }
            Organization org = OrganizationCache.find(user);
            if (org == null) {
                return false;
            }
            return ImagePublishedWindow.this.searchFieldPattern.matcher(org.displayName).find();
        }
    };

    public ImagePublishedWindow(Frame modalParent) {
        super((Window)modalParent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImagePublishedWindow.this.dispose();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagePublishedWindow.this.dispose();
            }
        });
        this.btnSatDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageSummaryRead item = (ImageSummaryRead)ImagePublishedWindow.this.imagePublishedTable.getSelectedItem();
                if (item == null) {
                    return;
                }
                String transferToken = null;
                try {
                    transferToken = ThriftManager.getSatClient().requestImageReplication(Session.getSatelliteToken(), item.latestVersionId);
                }
                catch (TException ex) {
                    ThriftError.showMessage(ImagePublishedWindow.this.me, LOGGER, ex, "Could not start download");
                    return;
                }
                MainWindow.addPassiveTransfer(transferToken, item.imageName, false);
                Gui.showMessageBox(ImagePublishedWindow.this, "Die \u00dcbertragung l\u00e4uft direkt zwischen Satellitenserver und dem " + Branding.getServiceName() + " Zentral-Server.\nWenn Sie die " + Branding.getApplicationName() + " schlie\u00dfen, wird der Transfer trotzdemweiterlaufen.", MessageType.INFO, null, null);
            }
        });
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageSummaryRead item = (ImageSummaryRead)ImagePublishedWindow.this.imagePublishedTable.getSelectedItem();
                if (item == null) {
                    return;
                }
                ImagePublishedWindow.this.btnDownload.setEnabled(false);
                ThriftActions.initDownload((JFrame)SwingUtilities.getWindowAncestor(ImagePublishedWindow.this.me), item.latestVersionId, item.imageName, item.virtId, item.osId, item.fileSize, null);
            }
        });
        this.txtSearch.getDocument().addDocumentListener(new TextChangeListener(){

            @Override
            public void changed() {
                String str = ImagePublishedWindow.this.txtSearch.getText();
                if (str == null || str.isEmpty()) {
                    ImagePublishedWindow.this.searchFieldPattern = null;
                } else {
                    try {
                        ImagePublishedWindow.this.searchFieldPattern = Pattern.compile(str, 2);
                        ImagePublishedWindow.this.txtSearch.setForeground(UIManager.getColor("TextField.foreground"));
                    }
                    catch (PatternSyntaxException ex) {
                        ImagePublishedWindow.this.txtSearch.setForeground(Color.RED);
                    }
                }
                ImagePublishedWindow.this.applyFilterOnTable();
            }
        });
        this.imagePublishedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImageSummaryRead item = (ImageSummaryRead)ImagePublishedWindow.this.imagePublishedTable.getSelectedItem();
                ImagePublishedWindow.this.updateAvailableOptions(item);
            }
        });
        this.imagePublishedTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ImageSummaryRead item = (ImageSummaryRead)ImagePublishedWindow.this.imagePublishedTable.getSelectedItem();
                    if (item == null || item.getImageBaseId() == null) {
                        return;
                    }
                    ImageDetailsWindow.open(JOptionPane.getFrameForComponent(ImagePublishedWindow.this), item.getImageBaseId(), null, new ImagePublishedDetailsActions(JOptionPane.getFrameForComponent(ImagePublishedWindow.this)));
                }
                this.processClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.processClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processClick(e);
            }

            private void processClick(MouseEvent e) {
            }
        });
        this.btnSatDownload.setVisible(Session.isImagePublishSupported());
        this.updateAvailableOptions(null);
        this.refreshList(true, 0);
    }

    private void updateAvailableOptions(ImageSummaryRead item) {
        this.btnDownload.setEnabled(item != null);
        if (Session.isImagePublishSupported()) {
            this.btnSatDownload.setEnabled(item != null);
        }
    }

    private void applyFilterOnTable() {
        ArrayList<RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>> filters = new ArrayList<RowFilter<ListTable.ListModel<ImageSummaryRead>, Integer>>();
        if (this.searchFieldPattern != null) {
            filters.add(this.filterSearchTerm);
        }
        RowFilter andFilters = RowFilter.andFilter(filters);
        ((DefaultRowSorter)this.imagePublishedTable.getRowSorter()).setRowFilter(andFilters);
    }

    @Override
    public void downloadInitialized(boolean success) {
        if (!success) {
            Gui.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImagePublishedWindow.this.btnDownload.setEnabled(true);
                }
            });
        }
    }

    public void refreshList(final boolean forceRefresh, int delay) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                final List<ImageSummaryRead> imagePublishedList = ImagePublishedCache.get(forceRefresh);
                if (imagePublishedList == null) {
                    return;
                }
                if (Session.hasFeature(Feature.MULTIPLE_HYPERVISORS)) {
                    ListIterator<ImageSummaryRead> iter = imagePublishedList.listIterator();
                    while (iter.hasNext()) {
                        ImageSummaryRead current = (ImageSummaryRead)iter.next();
                        if (current == null || current.virtId.equals("vmware")) continue;
                        iter.remove();
                    }
                }
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImagePublishedWindow.this.imagePublishedTable.setData(imagePublishedList, true);
                    }
                });
            }
        }, delay);
    }

    public static void open(Frame modalParent) {
        ImagePublishedWindow win = new ImagePublishedWindow(modalParent);
        win.setVisible(true);
    }

    @Override
    public void show() {
        if (!this.isVisible()) {
            this.pack();
            MainWindow.centerShell(this);
        }
        super.show();
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }
}

