/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.UIManager;
import org.openslx.bwlp.thrift.iface.LdapFilter;
import org.openslx.dozmod.gui.control.table.CheckListTable;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.gui.helper.ColorUtil;

public class LectureLdapFilterTable
extends CheckListTable<LdapFilter> {
    public static final ListTable.ListTableColumn COL_TITLE = new ListTable.ListTableColumn("Name");
    public static final ListTable.ListTableColumn COL_ATTRIBUTE = new ListTable.ListTableColumn("Attribut");
    public static final ListTable.ListTableColumn COL_VALUE = new ListTable.ListTableColumn("Wert");
    private final Color invalidColor;

    public LectureLdapFilterTable() {
        super(COL_TITLE, COL_ATTRIBUTE, COL_VALUE);
        Color fg = UIManager.getColor("Table.foreground");
        Color bg = UIManager.getColor("Table.background");
        this.invalidColor = ColorUtil.blend(fg, bg, 0.66f);
    }

    @Override
    protected Object getValueAtInternal2(LdapFilter item, ListTable.ListTableColumn columnIndex) {
        if (columnIndex == COL_TITLE) {
            if (item.filterId == 0) {
                return "";
            }
            return item.title;
        }
        if (columnIndex == COL_ATTRIBUTE) {
            return item.attribute;
        }
        if (columnIndex == COL_VALUE) {
            return item.value;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Component prepareRenderHook2(Component component, LdapFilter row, ListTable.ListTableColumn listTableColumn, boolean isSelected) {
        if (row.filterId == 0) {
            component.setForeground(isSelected ? this.getSelectionForeground() : this.getForeground());
        } else {
            component.setForeground(this.invalidColor);
        }
        return component;
    }

    @Override
    protected boolean isItemCheckable(LdapFilter item) {
        return item.filterId > 0;
    }
}

