/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import org.apache.log4j.Logger;
import org.openslx.dozmod.gui.control.table.ListTable;

public abstract class CheckListTable<T>
extends ListTable<Wrapper<T>> {
    private static final long serialVersionUID = 5667297891670398732L;
    private static final Logger LOGGER = Logger.getLogger(CheckListTable.class);
    public static final ListTable.ListTableColumn COL_CHECKBOX = new ListTable.ListTableColumn("", Boolean.class, null, true);
    private static final Component LBL_EMPTY_CELL = Box.createHorizontalGlue();

    public CheckListTable(ListTable.ListTableColumn ... columns) {
        this((Comparator<T>)null, columns);
    }

    public CheckListTable(final Comparator<T> itemComparator, ListTable.ListTableColumn ... columns) {
        super(itemComparator == null ? null : new Comparator<Wrapper<T>>(){

            @Override
            public int compare(Wrapper<T> o1, Wrapper<T> o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return itemComparator.compare(o1.item, o2.item);
            }
        }, CheckListTable.copyColumns(columns));
    }

    private static ListTable.ListTableColumn[] copyColumns(ListTable.ListTableColumn[] columns) {
        ListTable.ListTableColumn[] ncolumns = new ListTable.ListTableColumn[columns.length + 1];
        ncolumns[0] = COL_CHECKBOX;
        System.arraycopy(columns, 0, ncolumns, 1, columns.length);
        return ncolumns;
    }

    @Override
    public void setValueAt(Object newValue, Wrapper<T> row, ListTable.ListTableColumn column) {
        if (column == COL_CHECKBOX && newValue != null && newValue.getClass() == Boolean.class) {
            row.isChecked = (Boolean)newValue;
        }
    }

    @Override
    protected final Object getValueAtInternal(Wrapper<T> row, ListTable.ListTableColumn columnIndex) {
        if (row.item == null) {
            return null;
        }
        if (columnIndex == COL_CHECKBOX) {
            return row.isChecked;
        }
        return this.getValueAtInternal2(row.item, columnIndex);
    }

    protected abstract Object getValueAtInternal2(T var1, ListTable.ListTableColumn var2);

    @Override
    public final Component prepareRenderHook(Component component, Wrapper<T> row, ListTable.ListTableColumn listTableColumn, boolean isSelected) {
        if (listTableColumn == COL_CHECKBOX) {
            if (row == null || row.item == null || !this.isItemCheckable(row.item)) {
                return LBL_EMPTY_CELL;
            }
        } else if (row.item != null) {
            component = this.prepareRenderHook2(component, row.item, listTableColumn, isSelected);
        }
        return component;
    }

    public Component prepareRenderHook2(Component component, T row, ListTable.ListTableColumn listTableColumn, boolean isSelected) {
        return component;
    }

    public void setData(List<T> data, Set<T> preChecked, boolean sort) {
        ArrayList<Wrapper<T>> list = new ArrayList<Wrapper<T>>(data.size());
        for (T item : data) {
            list.add(new Wrapper<T>(item, preChecked != null && preChecked.contains(item)));
        }
        super.setData(list, sort);
    }

    protected abstract boolean isItemCheckable(T var1);

    public T getSelectedItem2() {
        Wrapper ret = (Wrapper)this.getSelectedItem();
        if (ret == null) {
            return null;
        }
        return (T)ret.item;
    }

    public static class Wrapper<S> {
        protected boolean isChecked;
        public final S item;

        public Wrapper(S item, boolean checked) {
            this.item = item;
            this.isChecked = checked;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Wrapper) {
                return this.item.equals(((Wrapper)obj).item);
            }
            return false;
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public String toString() {
            return "(" + this.item.hashCode() + "=" + this.isChecked + ")";
        }

        public boolean isChecked() {
            return this.isChecked;
        }
    }
}

