/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;

public class WordWrapLabel
extends JLabel {
    private static final long serialVersionUID = -2454459023556745689L;
    private String realText = "";
    private boolean bold = false;
    private boolean italic = false;

    public WordWrapLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public WordWrapLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public WordWrapLabel(String text) {
        this(text, null, 10);
    }

    public WordWrapLabel(String text, boolean bold, boolean italic) {
        this(null, null, 10);
        this.bold = bold;
        this.italic = italic;
        this.setText(text);
    }

    public WordWrapLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public WordWrapLabel(Icon image) {
        this(null, image, 0);
    }

    public WordWrapLabel() {
        this("", null, 10);
    }

    @Override
    public void setText(String text) {
        this.realText = text;
        if (text != null && !text.isEmpty()) {
            if (text.indexOf(38) != -1) {
                text = text.replace("&", "&amp;");
            }
            if (text.indexOf(60) != -1) {
                text = text.replace("<", "&lt;");
            }
            if (text.indexOf(62) != -1) {
                text = text.replace(">", "&gt;");
            }
            String tmp = "<html>";
            if (this.bold) {
                tmp = tmp + "<b>";
            }
            if (this.italic) {
                tmp = tmp + "<i>";
            }
            text = tmp + text;
            if (this.italic) {
                text = text + "</i>";
            }
            if (this.bold) {
                text = text + "</b>";
            }
            if (text.contains("\n")) {
                text = text.replace("\n", "<br>");
            }
        }
        super.setText(text);
    }

    @Override
    public Dimension getMaximumSize() {
        Container parent = this.getParent();
        if (parent == null) {
            return super.getMaximumSize();
        }
        return ((Component)parent).getMaximumSize();
    }

    public String getPlainText() {
        return this.realText;
    }
}

