/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openslx.bwlp.thrift.iface.Location;
import org.openslx.dozmod.util.FormatHelper;

public class JCheckBoxTree
extends JTree {
    private static final long serialVersionUID = -4194122328392241790L;
    JCheckBoxTree selfPointer = this;
    HashMap<TreePath, CheckedNode> nodesCheckingState;
    HashSet<TreePath> checkedPaths = new HashSet();

    public void addCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.add(CheckChangeEventListener.class, listener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener listener) {
        this.listenerList.remove(CheckChangeEventListener.class, listener);
    }

    void fireCheckChangeEvent(CheckChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)listeners[i + 1]).checkStateChanged(evt);
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        int i;
        super.setModel(newModel);
        this.resetCheckingState();
        for (i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
        for (i = 0; i < this.getRowCount(); ++i) {
            TreePath path = this.getPathForRow(i);
            if (path.getPathCount() <= 1) continue;
            this.collapseRow(i);
        }
    }

    public void setCheckedState(List<TreePath> paths, boolean check) {
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            if (path == null) continue;
            this.checkSubTree(path, check);
            if (!check) continue;
            this.expandPath(path);
        }
        this.collapseFullySelectedNodes();
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[this.checkedPaths.size()]);
    }

    public boolean isSelectedPartially(TreePath path) {
        CheckedNode cn = this.nodesCheckingState.get(path);
        return cn.isSelected && cn.hasChildren && !cn.allChildrenSelected;
    }

    private void collapseFullySelectedNodes() {
        for (Map.Entry<TreePath, CheckedNode> it : this.nodesCheckingState.entrySet()) {
            TreePath path = it.getKey();
            CheckedNode cn = it.getValue();
            if (!cn.hasChildren || !cn.allChildrenSelected || this.isCollapsed(path)) continue;
            this.collapsePath(path);
        }
    }

    private void resetCheckingState() {
        this.nodesCheckingState = new HashMap();
        this.checkedPaths = new HashSet();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(node);
    }

    private void addSubtreeToCheckingStateTracking(DefaultMutableTreeNode node) {
        Object[] path = node.getPath();
        TreePath tp = new TreePath(path);
        CheckedNode cn = new CheckedNode(false, node.getChildCount() > 0, false);
        this.nodesCheckingState.put(tp, cn);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.addSubtreeToCheckingStateTracking((DefaultMutableTreeNode)tp.pathByAddingChild(node.getChildAt(i)).getLastPathComponent());
        }
    }

    public JCheckBoxTree() {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).removeAllChildren();
        this.setToggleClickCount(0);
        CheckBoxCellRenderer cellRenderer = new CheckBoxCellRenderer();
        this.setCellRenderer(cellRenderer);
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -8190634240451667286L;

            @Override
            public void setSelectionPath(TreePath path) {
            }

            @Override
            public void addSelectionPath(TreePath path) {
            }

            @Override
            public void removeSelectionPath(TreePath path) {
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
            }
        };
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                TreePath tp = JCheckBoxTree.this.selfPointer.getPathForLocation(arg0.getX(), arg0.getY());
                if (tp == null) {
                    return;
                }
                boolean checkMode = !JCheckBoxTree.this.nodesCheckingState.get((Object)tp).isSelected;
                JCheckBoxTree.this.checkSubTree(tp, checkMode);
                JCheckBoxTree.this.updatePredecessorsWithCheckMode(tp, checkMode);
                JCheckBoxTree.this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
                JCheckBoxTree.this.selfPointer.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.setSelectionModel(dtsm);
    }

    protected void updatePredecessorsWithCheckMode(TreePath tp, boolean check) {
        TreePath parentPath = tp.getParentPath();
        if (parentPath == null) {
            return;
        }
        CheckedNode parentCheckedNode = this.nodesCheckingState.get(parentPath);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        parentCheckedNode.allChildrenSelected = true;
        parentCheckedNode.isSelected = false;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreePath childPath = parentPath.pathByAddingChild(parentNode.getChildAt(i));
            CheckedNode childCheckedNode = this.nodesCheckingState.get(childPath);
            if (childCheckedNode.allChildrenSelected) continue;
            parentCheckedNode.allChildrenSelected = false;
        }
        if (parentCheckedNode.allChildrenSelected) {
            parentCheckedNode.isSelected = true;
        }
        if (parentCheckedNode.isSelected) {
            this.checkedPaths.add(parentPath);
        } else {
            this.checkedPaths.remove(parentPath);
        }
        this.updatePredecessorsWithCheckMode(parentPath, check);
    }

    protected void checkSubTree(TreePath tp, boolean check) {
        CheckedNode cn = this.nodesCheckingState.get(tp);
        cn.isSelected = check;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.checkSubTree(tp.pathByAddingChild(node.getChildAt(i)), check);
        }
        cn.allChildrenSelected = check;
        if (check) {
            this.checkedPaths.add(tp);
        } else {
            this.checkedPaths.remove(tp);
        }
    }

    private class CheckBoxCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7341833835878991719L;
        JCheckBox checkBox;

        public CheckBoxCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.add((Component)this.checkBox, "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            TreePath tp = new TreePath(node.getPath());
            CheckedNode cn = JCheckBoxTree.this.nodesCheckingState.get(tp);
            if (cn == null) {
                return this;
            }
            String textString = obj instanceof Location ? FormatHelper.locName((Location)obj) : obj.toString();
            this.checkBox.setSelected(cn.isSelected);
            this.checkBox.setText(textString);
            this.checkBox.setOpaque(cn.isSelected && cn.hasChildren && !cn.allChildrenSelected);
            return this;
        }
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public class CheckChangeEvent
    extends EventObject {
        private static final long serialVersionUID = -8100230309044193368L;

        public CheckChangeEvent(Object source) {
            super(source);
        }
    }

    private class CheckedNode {
        boolean isSelected;
        boolean hasChildren;
        boolean allChildrenSelected;

        public CheckedNode(boolean isSelected_, boolean hasChildren_, boolean allChildrenSelected_) {
            this.isSelected = isSelected_;
            this.hasChildren = hasChildren_;
            this.allChildrenSelected = allChildrenSelected_;
        }
    }
}

