/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.changemonitor.GenericControlWindow;
import org.openslx.dozmod.gui.control.table.LecturePermissionTable;
import org.openslx.dozmod.gui.control.table.QScrollPane;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.window.UserListWindow;

public class LecturePermissionConfigurator
extends JPanel
implements GenericControlWindow<Map<String, LecturePermissions>> {
    private LecturePermissionConfigurator me;
    protected LecturePermissionTable permissionTable;
    protected JButton btnAddUser;
    protected JButton btnRemoveUser;
    private final ArrayList<LecturePermissionTable.UserLecturePermissions> permissionList = new ArrayList();
    private LecturePermissions defaultPermissions;
    private String ownerId = null;
    private static final Logger LOGGER = Logger.getLogger(LecturePermissionConfigurator.class);
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(1);

    public LecturePermissionConfigurator() {
        this.me = this;
        GridManager grid = new GridManager(this, 1);
        this.permissionTable = new LecturePermissionTable();
        JPanel userButtonPane = new JPanel();
        userButtonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        userButtonPane.setLayout(new BoxLayout(userButtonPane, 2));
        this.btnAddUser = new JButton("Benutzer hinzuf\u00fcgen");
        userButtonPane.add(this.btnAddUser);
        this.btnRemoveUser = new JButton("Benutzer entfernen");
        userButtonPane.add(this.btnRemoveUser);
        userButtonPane.add(Box.createGlue());
        QScrollPane jsp = new QScrollPane(this.permissionTable);
        jsp.setBackground(UIManager.getColor("Table.background"));
        grid.add(jsp).fill(true, true).expand(true, true);
        grid.nextRow();
        grid.add(userButtonPane).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.finish(false);
        this.btnAddUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserListWindow.open(SwingUtilities.getWindowAncestor(LecturePermissionConfigurator.this.me), new UserListWindow.UserAddedCallback(){

                    @Override
                    public void userAdded(UserInfo newUser, UserListWindow window) {
                        for (LecturePermissionTable.UserLecturePermissions current : LecturePermissionConfigurator.this.permissionList) {
                            if (!current.userId.equals(newUser.userId)) continue;
                            LOGGER.debug("User already present in the list, skipping!");
                            return;
                        }
                        LecturePermissionConfigurator.this.permissionList.add(new LecturePermissionTable.UserLecturePermissions(newUser.userId, new LecturePermissions(LecturePermissionConfigurator.this.defaultPermissions)));
                        LecturePermissionConfigurator.this.permissionTable.setData(LecturePermissionConfigurator.this.permissionList, false);
                        LecturePermissionConfigurator.this.fireUserChangeEvent();
                    }
                }, "Hinzuf\u00fcgen", LecturePermissionConfigurator.this.ownerId);
            }
        });
        this.btnRemoveUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LecturePermissionTable.UserLecturePermissions selected = (LecturePermissionTable.UserLecturePermissions)LecturePermissionConfigurator.this.permissionTable.getSelectedItem();
                if (selected != null && !LecturePermissionConfigurator.this.permissionList.remove(selected)) {
                    LOGGER.debug("Could not remove: " + selected);
                }
                LecturePermissionConfigurator.this.permissionTable.setData(LecturePermissionConfigurator.this.permissionList, false);
                LecturePermissionConfigurator.this.fireUserChangeEvent();
            }
        });
        this.permissionTable.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.permissionTable.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LecturePermissionConfigurator.this.btnRemoveUser.doClick();
            }
        });
        this.permissionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LecturePermissionConfigurator.this.fireUserChangeEvent();
            }
        });
    }

    public void initPanel(Map<String, LecturePermissions> permissionMap, LecturePermissions defaultPermissions, String ownerId) {
        this.ownerId = ownerId;
        this.defaultPermissions = defaultPermissions;
        this.permissionList.clear();
        if (permissionMap != null) {
            for (Map.Entry<String, LecturePermissions> e : permissionMap.entrySet()) {
                this.permissionList.add(new LecturePermissionTable.UserLecturePermissions(e.getKey(), e.getValue()));
            }
        }
        this.permissionTable.setData(this.permissionList, false);
    }

    public Map<String, LecturePermissions> getPermissions() {
        HashMap<String, LecturePermissions> newPermissionMap = new HashMap<String, LecturePermissions>(this.permissionList.size());
        for (LecturePermissionTable.UserLecturePermissions perm : this.permissionList) {
            newPermissionMap.put(perm.userId, new LecturePermissions(perm.permissions));
        }
        return newPermissionMap;
    }

    void fireUserChangeEvent() {
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(null);
        }
    }

    @Override
    public Map<String, LecturePermissions> getState() {
        return this.getPermissions();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }
}

