/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.changemonitor;

import java.util.Comparator;
import javax.swing.tree.TreePath;
import org.openslx.dozmod.gui.changemonitor.AbstractControlWrapper;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.control.JCheckBoxTree;

class CheckBoxTreeWrapper
extends AbstractControlWrapper<TreePath[]> {
    private static final Comparator<TreePath[]> COMPARATOR = new Comparator<TreePath[]>(){

        @Override
        public int compare(TreePath[] o1, TreePath[] o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return o2.length;
            }
            if (o2 == null) {
                return -o1.length;
            }
            if (o1.length != o2.length) {
                return o2.length - o1.length;
            }
            for (int i = 0; i < o1.length; ++i) {
                TreePath p2;
                TreePath p1 = o1[i];
                if (p1.getPathCount() != p2.getPathCount()) {
                    return p2.getPathCount() - p1.getPathCount();
                }
                for (p2 = o2[i]; p1 != null && p2 != null; p1 = p1.getParentPath(), p2 = p2.getParentPath()) {
                    long diff = p1.getLastPathComponent().hashCode() - p2.getLastPathComponent().hashCode();
                    if (diff == 0L) continue;
                    return (int)diff;
                }
            }
            return 0;
        }
    };
    private final JCheckBoxTree tree;

    public CheckBoxTreeWrapper(DialogChangeMonitor dcm, JCheckBoxTree t) {
        super(dcm, COMPARATOR);
        this.tree = t;
        this.tree.addCheckChangeEventListener(new JCheckBoxTree.CheckChangeEventListener(){

            @Override
            public void checkStateChanged(JCheckBoxTree.CheckChangeEvent event) {
                CheckBoxTreeWrapper.this.contentChanged();
            }
        });
    }

    @Override
    TreePath[] getCurrentValue() {
        return this.tree.getCheckedPaths();
    }
}

