/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod;

import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ContainerEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.util.ClientVersion;
import org.openslx.dozmod.util.FormatHelper;
import org.openslx.dozmod.util.ProxyConfigurator;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.Util;

public class App {
    private static final Logger LOGGER = Logger.getLogger(App.class);
    public static final int THRIFT_PORT = 9090;
    public static final int THRIFT_SSL_PORT = 9091;
    public static final int THRIFT_TIMEOUT_MS = 15000;
    private static CountDownLatch proxyLatch = new CountDownLatch(1);
    private static boolean proxyInitDone = false;
    private static String masterServerHost = null;

    private static void setupLogger() {
        String logFilePath = Config.getPath() + File.separator + Branding.getConfigDirectory() + ".log";
        File logFile = new File(logFilePath);
        if (logFile.exists() && !logFile.isDirectory()) {
            LOGGER.info("renaming old log file");
            try {
                File oldFile = new File(logFilePath + ".old");
                oldFile.delete();
                logFile.renameTo(oldFile);
                logFile.delete();
            }
            catch (Exception e) {
                LOGGER.error("Could not move '" + logFilePath + "' to '" + logFilePath + ".old'", e);
            }
        }
        FileAppender fa = null;
        try {
            fa = new FileAppender((Layout)new PatternLayout("%d [%F:%M] %m%n"), logFilePath);
            fa.setEncoding("UTF-8");
        }
        catch (IOException e) {
            LOGGER.error("Failed to set logfile path to '" + logFilePath + "': ", e);
            BasicConfigurator.configure();
            return;
        }
        final FileAppender ffa = fa;
        final Pattern re = Pattern.compile("authorization:(\\w|\\+|/|\\s)+", 10);
        AppenderSkeleton ap = new AppenderSkeleton(){

            @Override
            public boolean requiresLayout() {
                return ffa.requiresLayout();
            }

            @Override
            public void close() {
                ffa.close();
            }

            @Override
            protected void append(LoggingEvent event) {
                Matcher m;
                if ("org.apache.http.wire".equals(event.getLoggerName())) {
                    return;
                }
                String s = event.getRenderedMessage();
                if (s.contains("uthorization") && (m = re.matcher(s)).find()) {
                    s = m.replaceAll("Authorization: ***********");
                }
                ffa.append(new LoggingEvent(event.getFQNOfLoggerClass(), event.getLogger(), event.getTimeStamp(), event.getLevel(), s, event.getThreadName(), event.getThrowableInformation(), event.getNDC(), event.getLocationInformation(), event.getProperties()));
            }
        };
        BasicConfigurator.configure(ap);
        LOGGER.info("Starting logging to:           " + logFilePath);
        LOGGER.info(Branding.getApplicationName() + " Version:   " + ClientVersion.getLocalRevision());
        LOGGER.info("                               " + FormatHelper.longDate(ClientVersion.getLocalRevTimestamp()));
        LOGGER.info("os.name:                       " + System.getProperty("os.name"));
        LOGGER.info("java.specification.vendor:     " + System.getProperty("java.specification.vendor"));
        LOGGER.info("java.specification.name:       " + System.getProperty("java.specification.name"));
        LOGGER.info("java.specification.version:    " + System.getProperty("java.specification.version"));
        LOGGER.info("java.version:                  " + System.getProperty("java.version"));
        LOGGER.info("java.vm.version:               " + System.getProperty("java.vm.version"));
        LOGGER.info("java.runtime.version:          " + System.getProperty("java.runtime.version"));
    }

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {
        boolean useSsl;
        int port;
        String host;
        if (args.length >= 2) {
            if (args[0].equals("--json")) {
                App.writeJsonUpdateFile(args[1]);
                return;
            }
            if (args[0].equals("--dump")) {
                Branding.dump(args[1]);
                return;
            }
        }
        if (args.length >= 3 && args[0].equals("--pack")) {
            Branding.pack(args[1], args[2]);
            return;
        }
        try {
            Config.init();
        }
        catch (Exception e) {
            Gui.showMessageBox(null, "Error loading configuration", MessageType.ERROR, LOGGER, e);
            return;
        }
        App.setupLogger();
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        try {
            if (System.getProperty("swing.defaultlaf") != null) {
                UIManager.setLookAndFeel(System.getProperty("swing.defaultlaf"));
            } else if (Config.getLookAndFeel() != null) {
                UIManager.setLookAndFeel(Config.getLookAndFeel());
            } else {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                Config.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
        }
        catch (Exception e1) {
            try {
                LOGGER.error("Something went wrong with the chosen 'LookAndFeel'. Falling back to default 'SystemLookAndFeel'");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                if (Config.getLookAndFeel() == null) {
                    Config.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        App.adjustFontSize(Config.getFontScaling());
        if (args.length == 3) {
            host = args[0];
            port = Util.parseInt(args[1], -1);
            useSsl = Boolean.parseBoolean(args[2]);
        } else {
            host = Branding.getMasterServerAddress();
            port = 9091;
            useSsl = true;
        }
        masterServerHost = host;
        if (Config.getProxyMode() == Config.ProxyMode.AUTO) {
            new Thread(){

                @Override
                public void run() {
                    ProxyConfigurator.init();
                    proxyInitDone = true;
                    proxyLatch.countDown();
                }
            }.start();
        } else {
            proxyInitDone = true;
            proxyLatch.countDown();
        }
        if (useSsl) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                ctx.init(null, null, null);
                ThriftManager.setMasterServerAddress(ctx, host, port, 15000);
            }
            catch (Exception e1) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        boolean ret = Gui.showMessageBox(null, "SSL nicht verf\u00fcgbar. Wollen Sie sich trotzdem unverschl\u00fcsselt verbinden?", MessageType.QUESTION_YESNO, LOGGER, e1);
                        if (!ret) {
                            System.exit(1);
                        }
                    }
                });
                useSsl = false;
                --port;
            }
        }
        if (!useSsl) {
            ThriftManager.setMasterServerAddress(null, host, port, 15000);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        if (e instanceof ClassCastException && e.getMessage().contains("SurfaceData")) {
                            return;
                        }
                        Gui.showMessageBox(null, "Ungefangene Ausnahme in Faden " + t.getName() + "\n\nDie Anwendung k\u00f6nnte instabil laufen.\nZur Sicherheit sollten Sie sie neustarten.", MessageType.WARNING, LOGGER, e);
                    }
                });
                MainWindow.open();
            }
        });
    }

    private static void writeJsonUpdateFile(String destination) {
        try {
            ClientVersion.createJson(destination);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON update file to '" + destination + "': ", e);
        }
    }

    private static void adjustFontSize(int percent) {
        if (percent == 100 || percent <= 0 || percent > 1000) {
            return;
        }
        final float scaling = 0.01f * (float)percent;
        int size = App.determineDefaultFontSize(UIManager.getLookAndFeelDefaults());
        if (size == -1) {
            size = App.determineDefaultFontSize(UIManager.getDefaults());
        }
        if (size == -1) {
            size = 12;
        }
        final float defaultSize = size;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Font font;
                ContainerEvent containerEvent;
                if (event instanceof ContainerEvent && (containerEvent = (ContainerEvent)event).getID() == 300 && (font = containerEvent.getChild().getFont()) != null && font.getSize2D() <= defaultSize) {
                    containerEvent.getChild().setFont(new Font(font.getName(), font.getStyle(), Math.round(font.getSize2D() * scaling)));
                }
            }
        }, 3L);
        Font tbFont = UIManager.getFont("TitledBorder.font");
        if (tbFont != null) {
            UIManager.put("TitledBorder.font", tbFont.deriveFont(tbFont.getSize2D() * scaling));
        }
    }

    private static int determineDefaultFontSize(UIDefaults defaults) {
        if (defaults == null) {
            return -1;
        }
        int[] sizes = new int[100];
        HashSet keys = new HashSet(defaults.keySet());
        for (Object key : keys) {
            Font font;
            Object value;
            if (key == null || (value = defaults.get(key)) == null || !(value instanceof Font) || (font = (Font)value).getSize() <= 0 || font.getSize() >= sizes.length) continue;
            int n = font.getSize();
            sizes[n] = sizes[n] + 1;
        }
        int best = -1;
        for (int index = 0; index < sizes.length; ++index) {
            if (best != -1 && sizes[best] >= sizes[index]) continue;
            best = index;
        }
        return sizes[best];
    }

    public static void waitForInit() {
        if (proxyInitDone) {
            return;
        }
        try {
            proxyLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static synchronized boolean isInitDone() {
        return proxyInitDone;
    }

    public static synchronized String getMasterServerAddress() {
        return masterServerHost;
    }
}

