/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker.constraints;

import java.util.Calendar;
import java.util.Date;
import org.jdatepicker.DateModel;
import org.jdatepicker.constraints.DateSelectionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeConstraint
implements DateSelectionConstraint {
    private final Calendar after;
    private final Calendar before;

    public RangeConstraint(Calendar after, Calendar before) {
        this.after = after;
        this.before = before;
        this.cleanTime();
    }

    public RangeConstraint(Date after, Date before) {
        Calendar _after = Calendar.getInstance();
        Calendar _before = Calendar.getInstance();
        _after.setTime(after);
        _before.setTime(before);
        this.after = _after;
        this.before = _before;
        this.cleanTime();
    }

    private void cleanTime() {
        if (this.after != null) {
            this.after.set(11, 0);
            this.after.set(12, 0);
            this.after.set(13, 0);
            this.after.set(14, 0);
        }
        if (this.before != null) {
            this.before.set(11, 23);
            this.before.set(12, 59);
            this.before.set(13, 59);
            this.before.set(14, 999);
        }
    }

    @Override
    public boolean isValidSelection(DateModel<?> model) {
        Calendar value;
        boolean result = true;
        if (model.isSelected() && this.after != null) {
            value = Calendar.getInstance();
            value.set(model.getYear(), model.getMonth(), model.getDay());
            value.set(10, 0);
            value.set(12, 0);
            value.set(13, 0);
            value.set(14, 0);
            result &= value.after(this.after);
        }
        if (model.isSelected() && this.before != null) {
            value = Calendar.getInstance();
            value.set(model.getYear(), model.getMonth(), model.getDay());
            value.set(10, 0);
            value.set(12, 0);
            value.set(13, 0);
            value.set(14, 0);
            result &= value.before(this.before);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.after == null ? 0 : this.after.hashCode());
        result = 31 * result + (this.before == null ? 0 : this.before.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeConstraint other = (RangeConstraint)obj;
        if (this.after == null ? other.after != null : !this.after.equals(other.after)) {
            return false;
        }
        return !(this.before == null ? other.before != null : !this.before.equals(other.before));
    }
}

