/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.scc.dei.ecplean;

import edu.kit.scc.dei.ecplean.ECPAuthenticationException;
import edu.kit.scc.dei.ecplean.ECPAuthenticationInfo;
import edu.kit.scc.dei.ecplean.ECPAuthenticatorBase;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ECPIdPAuth
extends ECPAuthenticatorBase {
    public ECPIdPAuth(String username, String password, URI idpEcpEndpoint) {
        this.authInfo = new ECPAuthenticationInfo(username, password, idpEcpEndpoint, null);
    }

    public ECPIdPAuth(CloseableHttpClient client, String username, String password, URI idpEcpEndpoint) {
        super(client);
        this.authInfo = new ECPAuthenticationInfo(username, password, idpEcpEndpoint, null);
    }

    public String authenticate(String paosMessage) throws ECPAuthenticationException {
        String responseConsumerUrl;
        String relayState;
        Document initResponse;
        try {
            initResponse = this.buildDocumentFromString(paosMessage);
        }
        catch (IOException e) {
            logger.debug("Parsing SP Request failed");
            throw new ECPAuthenticationException(e);
        }
        catch (ParserConfigurationException e) {
            logger.debug("Parsing SP Request failed");
            throw new ECPAuthenticationException(e);
        }
        catch (SAXException e) {
            logger.debug("Parsing SP Request failed");
            throw new ECPAuthenticationException(e);
        }
        try {
            relayState = (String)this.queryDocument(initResponse, "//ecp:RelayState", XPathConstants.STRING);
        }
        catch (XPathException e) {
            logger.debug("Could not find relay state in PAOS answer from SP");
            throw new ECPAuthenticationException(e);
        }
        logger.info("Got relayState: " + relayState);
        try {
            responseConsumerUrl = (String)this.queryDocument(initResponse, "/S:Envelope/S:Header/paos:Request/@responseConsumerURL", XPathConstants.STRING);
        }
        catch (XPathException e) {
            logger.debug("Could not find response consumer url in PAOS answer from SP");
            throw new ECPAuthenticationException(e);
        }
        logger.info("Got responseConsumerUrl: " + responseConsumerUrl);
        Node firstChild = initResponse.getDocumentElement().getFirstChild();
        initResponse.getDocumentElement().removeChild(firstChild);
        Document idpResponse = this.authenticateIdP(initResponse);
        idpResponse.getDocumentElement().getFirstChild().getFirstChild().setTextContent(relayState);
        try {
            return this.documentToString(idpResponse);
        }
        catch (TransformerException e) {
            logger.debug("documentToString failed");
            throw new ECPAuthenticationException(e);
        }
    }
}

