/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.misc;

import com.btr.proxy.selector.direct.NoProxySelector;
import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.util.Logger;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtocolDispatchSelector
extends ProxySelector {
    private Map<String, ProxySelector> selectors = new ConcurrentHashMap<String, ProxySelector>();
    private ProxySelector fallbackSelector = NoProxySelector.getInstance();

    public void setSelector(String protocol, ProxySelector selector) {
        if (protocol == null) {
            throw new NullPointerException("Protocol must not be null.");
        }
        if (selector == null) {
            throw new NullPointerException("Selector must not be null.");
        }
        if (protocol.toLowerCase().startsWith("socks")) {
            protocol = "socket";
        }
        this.selectors.put(protocol, selector);
    }

    public ProxySelector removeSelector(String protocol) {
        return this.selectors.remove(protocol);
    }

    public ProxySelector getSelector(String protocol) {
        return this.selectors.get(protocol);
    }

    public void setFallbackSelector(ProxySelector selector) {
        if (selector == null) {
            throw new NullPointerException("Selector must not be null.");
        }
        this.fallbackSelector = selector;
    }

    private ProxySelector selectorForUri(URI uri) {
        if (uri == null || uri.getScheme() == null) {
            return this.fallbackSelector;
        }
        String protocol = uri.getScheme();
        ProxySelector selector = this.selectors.get(protocol);
        if (selector == null) {
            selector = this.fallbackSelector;
        }
        return selector;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        ProxySelector selector = this.selectorForUri(uri);
        selector.connectFailed(uri, sa, ioe);
    }

    @Override
    public List<Proxy> select(URI uri) {
        ProxySelector selector = this.selectorForUri(uri);
        List<Proxy> ret = selector.select(uri);
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Selector {0} for {1} -> {2}", selector.getClass(), uri, ret);
        return ret;
    }

    public void setFallbackSocksSelector(FixedProxySelector ... pslist) {
        if (!(this.fallbackSelector instanceof NoProxySelector)) {
            return;
        }
        for (FixedProxySelector ps : pslist) {
            if (ps == null || ps.getType() != Proxy.Type.SOCKS) continue;
            this.fallbackSelector = ps;
            return;
        }
    }

    public boolean isEmpty() {
        return this.selectors.isEmpty() && this.fallbackSelector instanceof NoProxySelector;
    }
}

