/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util.vm;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.util.vm.QemuMetaData;
import org.openslx.util.vm.UnsupportedVirtualizerFormatException;
import org.openslx.util.vm.VboxMetaData;
import org.openslx.util.vm.VmwareMetaData;

public abstract class VmMetaData<T, U, V, W> {
    private static final Logger LOGGER = Logger.getLogger(VmMetaData.class);
    protected Map<SoundCardType, T> soundCards = new HashMap<SoundCardType, T>();
    protected Map<DDAcceleration, U> ddacc = new HashMap<DDAcceleration, U>();
    protected Map<HWVersion, V> hwversion = new HashMap<HWVersion, V>();
    protected Map<EthernetDevType, W> networkCards = new HashMap<EthernetDevType, W>();
    protected final List<HardDisk> hdds = new ArrayList<HardDisk>();
    private final List<OperatingSystem> osList;
    private OperatingSystem os = null;
    protected String displayName = null;
    protected boolean isMachineSnapshot;

    public List<SoundCardType> getSupportedSoundCards() {
        ArrayList<SoundCardType> availables = new ArrayList<SoundCardType>(this.soundCards.keySet());
        Collections.sort(availables);
        return availables;
    }

    public List<DDAcceleration> getSupportedDDAccs() {
        ArrayList<DDAcceleration> availables = new ArrayList<DDAcceleration>(this.ddacc.keySet());
        Collections.sort(availables);
        return availables;
    }

    public List<HWVersion> getSupportedHWVersions() {
        ArrayList<HWVersion> availables = new ArrayList<HWVersion>(this.hwversion.keySet());
        Collections.sort(availables);
        return availables;
    }

    public List<EthernetDevType> getSupportedEthernetDevices() {
        ArrayList<EthernetDevType> availables = new ArrayList<EthernetDevType>(this.networkCards.keySet());
        Collections.sort(availables);
        return availables;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public List<HardDisk> getHdds() {
        return Collections.unmodifiableList(this.hdds);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isMachineSnapshot() {
        return this.isMachineSnapshot;
    }

    public abstract byte[] getFilteredDefinitionArray();

    public final ByteBuffer getFilteredDefinition() {
        return ByteBuffer.wrap(this.getFilteredDefinitionArray());
    }

    public VmMetaData(List<OperatingSystem> osList) {
        this.osList = osList;
    }

    protected final void setOs(String virtId, String virtOsId) {
        OperatingSystem lazyMatch = null;
        for (OperatingSystem os : this.osList) {
            if (os.getVirtualizerOsId() == null) continue;
            for (Map.Entry<String, String> entry : os.getVirtualizerOsId().entrySet()) {
                if (!entry.getValue().equals(virtOsId)) continue;
                if (entry.getKey().equals(virtId)) {
                    this.os = os;
                    return;
                }
                lazyMatch = os;
            }
        }
        this.os = lazyMatch;
    }

    public abstract void applySettingsForLocalEdit();

    public static VmMetaData<?, ?, ?, ?> getInstance(List<OperatingSystem> osList, File file) throws IOException {
        try {
            return new VmwareMetaData(osList, file);
        }
        catch (UnsupportedVirtualizerFormatException e) {
            LOGGER.info("Not a VMware file", e);
            try {
                return new VboxMetaData(osList, file);
            }
            catch (UnsupportedVirtualizerFormatException e2) {
                LOGGER.info("Not a VirtualBox file", e2);
                try {
                    return new QemuMetaData(osList, file);
                }
                catch (Exception e3) {
                    LOGGER.info("Not a QEmu file", e3);
                    LOGGER.error("Could not detect any known virtualizer format");
                    return null;
                }
            }
        }
    }

    public static VmMetaData<?, ?, ?, ?> getInstance(List<OperatingSystem> osList, byte[] vmContent, int length) throws IOException {
        try {
            return new VmwareMetaData(osList, vmContent, length);
        }
        catch (UnsupportedVirtualizerFormatException e) {
            LOGGER.info("Not a VMware file", e);
            try {
                return new VboxMetaData(osList, vmContent, length);
            }
            catch (UnsupportedVirtualizerFormatException e2) {
                LOGGER.info("Not a VirtualBox file", e2);
                LOGGER.error("Could not detect any known virtualizer format");
                return null;
            }
        }
    }

    public abstract boolean addHddTemplate(File var1, String var2, String var3);

    public abstract boolean addHddTemplate(String var1, String var2, String var3);

    public abstract boolean addDefaultNat();

    public abstract void setOs(String var1);

    public abstract boolean addDisplayName(String var1);

    public abstract boolean addRam(int var1);

    public abstract void addFloppy(int var1, String var2, boolean var3);

    public abstract boolean addCdrom(String var1);

    public abstract boolean addCpuCoreCount(int var1);

    public abstract void setSoundCard(SoundCardType var1);

    public abstract SoundCardType getSoundCard();

    public abstract void setDDAcceleration(DDAcceleration var1);

    public abstract DDAcceleration getDDAcceleration();

    public abstract void setHWVersion(HWVersion var1);

    public abstract HWVersion getHWVersion();

    public abstract void setEthernetDevType(int var1, EthernetDevType var2);

    public abstract EthernetDevType getEthernetDevType(int var1);

    public abstract byte[] getDefinitionArray();

    public abstract boolean addEthernet(EtherType var1);

    public abstract Virtualizer getVirtualizer();

    public abstract void enableUsb(boolean var1);

    public abstract boolean disableSuspend();

    public abstract void registerVirtualHW();

    public static enum EtherType {
        NAT,
        BRIDGED,
        HOST_ONLY;

    }

    public static class HardDisk {
        public final String chipsetDriver;
        public final DriveBusType bus;
        public final String diskImage;

        public HardDisk(String chipsetDriver, DriveBusType bus, String diskImage) {
            this.chipsetDriver = chipsetDriver;
            this.bus = bus;
            this.diskImage = diskImage;
        }
    }

    public static enum DriveBusType {
        SCSI,
        IDE,
        SATA;

    }

    public static enum EthernetDevType {
        AUTO("(default)"),
        PCNET32("AMD PCnet32"),
        E1000("Intel E1000 (PCI)"),
        E1000E("Intel E1000e (PCI-Express)"),
        VMXNET("VMXnet"),
        VMXNET3("VMXnet 3"),
        PCNETPCI2("PCnet-PCI II"),
        PCNETFAST3("PCnet-FAST III"),
        PRO1000MTD("Intel PRO/1000 MT Desktop"),
        PRO1000TS("Intel PRO/1000 T Server"),
        PRO1000MTS("Intel PRO/1000 MT Server"),
        PARAVIRT("Paravirtualized Network"),
        NONE("No Network Card");

        public final String displayName;

        private EthernetDevType(String dName) {
            this.displayName = dName;
        }
    }

    public static enum HWVersion {
        NONE("(invalid)"),
        THREE("  3 (Workstation 4/5, Player 1)"),
        FOUR("  4 (Workstation 4/5, Player 1/2, Fusion 1)"),
        SIX("  6 (Workstation 6)"),
        SEVEN("  7 (Workstation 6.5/7, Player 3, Fusion 2/3)"),
        EIGHT("  8 (Workstation 8, Player/Fusion 4)"),
        NINE("  9 (Workstation 9, Player/Fusion 5)"),
        TEN("10 (Workstation 10, Player/Fusion 6)"),
        ELEVEN("11 (Workstation 11, Player/Fusion 7)"),
        TWELVE("12 (Workstation/Player 12, Fusion 8)"),
        DEFAULT("default");

        public final String displayName;

        private HWVersion(String dName) {
            this.displayName = dName;
        }
    }

    public static enum DDAcceleration {
        OFF("Off"),
        ON("On");

        public final String displayName;

        private DDAcceleration(String dName) {
            this.displayName = dName;
        }
    }

    public static enum SoundCardType {
        NONE("None"),
        DEFAULT("(default)"),
        SOUND_BLASTER("Sound Blaster 16"),
        ES("ES 1371"),
        HD_AUDIO("Intel Integrated HD Audio"),
        AC("Intel ICH Audio Codec 97");

        public final String displayName;

        private SoundCardType(String dName) {
            this.displayName = dName;
        }
    }
}

