/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GrowingThreadPoolExecutor
extends ThreadPoolExecutor {
    private int userSpecifiedCorePoolSize;
    private int taskCount;
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();

    public GrowingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, defaultHandler);
    }

    public GrowingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public GrowingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public GrowingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.userSpecifiedCorePoolSize = corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        GrowingThreadPoolExecutor growingThreadPoolExecutor = this;
        synchronized (growingThreadPoolExecutor) {
            ++this.taskCount;
            this.setCorePoolSizeToTaskCountWithinBounds();
        }
        super.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        GrowingThreadPoolExecutor growingThreadPoolExecutor = this;
        synchronized (growingThreadPoolExecutor) {
            --this.taskCount;
            this.setCorePoolSizeToTaskCountWithinBounds();
        }
    }

    private void setCorePoolSizeToTaskCountWithinBounds() {
        int threads = this.taskCount;
        if (threads < this.userSpecifiedCorePoolSize) {
            threads = this.userSpecifiedCorePoolSize;
        }
        if (threads > this.getMaximumPoolSize()) {
            threads = this.getMaximumPoolSize();
        }
        super.setCorePoolSize(threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int corePoolSize) {
        GrowingThreadPoolExecutor growingThreadPoolExecutor = this;
        synchronized (growingThreadPoolExecutor) {
            this.userSpecifiedCorePoolSize = corePoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCorePoolSize() {
        GrowingThreadPoolExecutor growingThreadPoolExecutor = this;
        synchronized (growingThreadPoolExecutor) {
            return this.userSpecifiedCorePoolSize;
        }
    }
}

