/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.TransferInformation;
import org.openslx.filetransfer.Uploader;
import org.openslx.filetransfer.util.AbstractTransfer;

public abstract class OutgoingTransferBase
extends AbstractTransfer {
    private static final Logger LOGGER = Logger.getLogger(OutgoingTransferBase.class);
    private static final long INACTIVITY_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    protected static int MAX_CONNECTIONS_PER_TRANSFER = 2;
    private final List<Uploader> uploads = new ArrayList<Uploader>();
    private final File sourceFile;
    private final TransferInformation transferInformation;

    public OutgoingTransferBase(String transferId, File sourceFile, int plainPort, int sslPort) {
        super(transferId);
        this.sourceFile = sourceFile;
        this.transferInformation = new TransferInformation(transferId, plainPort, sslPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addConnection(Uploader connection, ExecutorService pool) {
        List<Uploader> list = this.uploads;
        synchronized (list) {
            if (this.uploads.size() >= MAX_CONNECTIONS_PER_TRANSFER) {
                return false;
            }
            this.uploads.add(connection);
        }
        return this.runConnectionInternal(connection, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runConnectionInternal(final Uploader connection, ExecutorService pool) {
        try {
            pool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean ret = connection.upload(OutgoingTransferBase.this.sourceFile.getAbsolutePath());
                    List list = OutgoingTransferBase.this.uploads;
                    synchronized (list) {
                        OutgoingTransferBase.this.uploads.remove(connection);
                    }
                    if (ret) {
                        OutgoingTransferBase.this.connectFails.set(0);
                    }
                    if (ret && OutgoingTransferBase.this.uploads.isEmpty() && OutgoingTransferBase.this.potentialFinishTime.get() == 0L) {
                        OutgoingTransferBase.this.potentialFinishTime.set(System.currentTimeMillis());
                    }
                    if (!ret && OutgoingTransferBase.this.uploads.isEmpty()) {
                        OutgoingTransferBase.this.connectFails.incrementAndGet();
                    }
                    OutgoingTransferBase.this.lastActivityTime.set(System.currentTimeMillis());
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("threadpool rejected the incoming file transfer", e);
            List<Uploader> list = this.uploads;
            synchronized (list) {
                this.uploads.remove(connection);
            }
            return false;
        }
        return true;
    }

    @Override
    public TransferInformation getTransferInfo() {
        return this.transferInformation;
    }

    @Override
    public final boolean isActive() {
        return this.uploads.size() > 0 || this.lastActivityTime.get() + INACTIVITY_TIMEOUT > System.currentTimeMillis();
    }

    @Override
    public void cancel() {
    }

    @Override
    public final int getActiveConnectionCount() {
        return this.uploads.size();
    }
}

