/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.openslx.dozmod.App;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.util.OsHelper;

public class DesktopEnvironment {
    private static final Logger LOGGER = Logger.getLogger(DesktopEnvironment.class);
    private static final Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;

    public static boolean openWebpage(Link location) {
        return DesktopEnvironment.openWebpageUri(location.uri);
    }

    public static boolean openWebpageUri(URI uri) {
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Got exception in openWebpage: ", e);
            }
        }
        return DesktopEnvironment.fallbackExec(uri.toString());
    }

    public static boolean openLocal(File path) {
        try {
            desktop.open(path);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Got exception in openLocal: ", e);
            return DesktopEnvironment.fallbackExec(path.getAbsolutePath());
        }
    }

    public static boolean sendMail(String address, String subject) {
        URI mailToUri = null;
        try {
            mailToUri = subject != null ? new URI("mailto:" + address + "?subject=" + URLEncoder.encode(subject, "UTF-8")) : new URI("mailto:" + address);
            if (desktop != null && desktop.isSupported(Desktop.Action.MAIL)) {
                desktop.mail(mailToUri);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Got exception in sendMail: ", e);
        }
        return mailToUri != null && DesktopEnvironment.fallbackExec(mailToUri.toString());
    }

    public static boolean fallbackExec(String link) {
        Object[] execCommand;
        if (OsHelper.isLinux()) {
            execCommand = new String[]{"xdg-open", link};
        } else if (OsHelper.isWindows()) {
            execCommand = new String[]{"cmd.exe", "/c", "start", link};
        } else {
            LOGGER.error("Could not set command for unknown operating system: " + OsHelper.osName);
            return false;
        }
        int exitCode = -1;
        try {
            exitCode = Runtime.getRuntime().exec((String[])execCommand).waitFor();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug("Failed to execute: " + Arrays.toString(execCommand) + " -- Trace: ", e);
            return false;
        }
        return exitCode == 0;
    }

    public static enum Link {
        FAQ(Branding.getServiceFAQWebsite()),
        VMWARE("https://my.vmware.com/web/vmware/free#desktop_end_user_computing/vmware_workstation_player/12_0"),
        DOZMOD("https://" + App.getMasterServerAddress() + "/dozmod/"),
        REGISTER_BWIDM("https://" + App.getMasterServerAddress() + "/webif/");

        public final URI uri;

        private Link(String uri) {
            this.uri = URI.create(uri);
        }
    }
}

