/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.LdapFilter;
import org.openslx.bwlp.thrift.iface.Location;
import org.openslx.bwlp.thrift.iface.NetShare;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.PredefinedData;
import org.openslx.bwlp.thrift.iface.PresetNetRule;
import org.openslx.bwlp.thrift.iface.PresetRunScript;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.dozmod.thrift.Session;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.GenericDataCache;

public class MetaDataCache {
    private static final Logger LOGGER = Logger.getLogger(MetaDataCache.class);
    private static final int CACHE_TIME_LONG_MS = 3600000;
    private static final int CACHE_TIME_SHORT_MS = 600000;
    private static final GenericDataCache<List<OperatingSystem>> osCache = new GenericDataCache<List<OperatingSystem>>(3600000){

        @Override
        protected List<OperatingSystem> update() throws TException {
            try {
                return ThriftManager.getSatClient().getOperatingSystems();
            }
            catch (Exception e) {
                LOGGER.warn("Could not get OS list from satellite, trying master for backup...", e);
                return ThriftManager.getMasterClient().getOperatingSystems();
            }
        }
    };
    private static final GenericDataCache<List<Virtualizer>> virtualizerCache = new GenericDataCache<List<Virtualizer>>(3600000){

        @Override
        protected List<Virtualizer> update() throws TException {
            try {
                return ThriftManager.getSatClient().getVirtualizers();
            }
            catch (TException e) {
                LOGGER.warn("Could not get virtualizer list from satellite, trying master for backup...", e);
                return ThriftManager.getMasterClient().getVirtualizers();
            }
        }
    };
    private static int locationFails = 0;
    private static final GenericDataCache<List<Location>> locationCache = new GenericDataCache<List<Location>>(600000){

        @Override
        protected List<Location> update() throws TException {
            if (locationFails > 2) {
                return null;
            }
            try {
                List<Location> ret = ThriftManager.getSatClient().getLocations();
                locationFails = 0;
                return ret;
            }
            catch (TApplicationException e) {
                locationFails++;
                if (locationFails == 1) {
                    LOGGER.info("Satellite doesn't seem to support locations");
                }
            }
            catch (TException e) {
                LOGGER.warn("Could not get locations list from the satellite...", e);
            }
            return null;
        }
    };
    private static final GenericDataCache<PredefinedData> predefinedData = new GenericDataCache<PredefinedData>(600000){

        @Override
        protected PredefinedData update() throws TException {
            try {
                return ThriftManager.getSatClient().getPredefinedData(Session.getSatelliteToken());
            }
            catch (TException e) {
                LOGGER.warn("Could not get predefined Data from sat...", e);
                return null;
            }
        }
    };

    public static List<OperatingSystem> getOperatingSystems() {
        return osCache.get();
    }

    public static OperatingSystem getOsById(int id) {
        return MetaDataCache.getOsById(id, false);
    }

    public static OperatingSystem getOsById(int id, boolean forceCache) {
        List<OperatingSystem> list = osCache.get(GenericDataCache.CacheMode.FORCE_CACHED);
        OperatingSystem os = MetaDataCache.getOsById(id, list);
        if (os != null || forceCache) {
            return os;
        }
        List<OperatingSystem> newList = osCache.get(GenericDataCache.CacheMode.DEFAULT);
        if (list == newList) {
            return null;
        }
        return MetaDataCache.getOsById(id, newList);
    }

    private static OperatingSystem getOsById(int id, List<OperatingSystem> list) {
        if (list != null) {
            for (OperatingSystem os : list) {
                if (os.getOsId() != id) continue;
                return os;
            }
        }
        return null;
    }

    public static List<Virtualizer> getVirtualizers() {
        return virtualizerCache.get();
    }

    public static Virtualizer getVirtualizerById(String virtId) {
        return MetaDataCache.getVirtualizerById(virtId, false);
    }

    public static Virtualizer getVirtualizerById(String virtId, boolean forceCache) {
        List<Virtualizer> list = virtualizerCache.get(GenericDataCache.CacheMode.FORCE_CACHED);
        Virtualizer virt = MetaDataCache.getVirtualizerById(virtId, list);
        if (virt != null || forceCache) {
            return virt;
        }
        List<Virtualizer> newList = virtualizerCache.get(GenericDataCache.CacheMode.DEFAULT);
        if (list == newList) {
            return null;
        }
        return MetaDataCache.getVirtualizerById(virtId, newList);
    }

    private static Virtualizer getVirtualizerById(String virtId, List<Virtualizer> list) {
        if (list != null) {
            for (Virtualizer virt : list) {
                if (!virt.getVirtId().equals(virtId)) continue;
                return virt;
            }
        }
        return null;
    }

    public static List<Location> getLocations() {
        return locationCache.get();
    }

    public static Location getLocationById(int id) {
        return MetaDataCache.getLocationById(id, false);
    }

    public static Location getLocationById(int id, boolean forceCache) {
        List<Location> list = locationCache.get(GenericDataCache.CacheMode.FORCE_CACHED);
        Location location = MetaDataCache.getLocationById(id, list);
        if (location != null || forceCache) {
            return location;
        }
        List<Location> newList = locationCache.get(GenericDataCache.CacheMode.DEFAULT);
        if (list == newList) {
            return null;
        }
        return MetaDataCache.getLocationById(id, newList);
    }

    private static Location getLocationById(int id, List<Location> list) {
        if (list != null) {
            for (Location loc : list) {
                if (loc.getLocationId() != id) continue;
                return loc;
            }
        }
        return null;
    }

    public static List<LdapFilter> getPredefinedLdapFilters() {
        PredefinedData pd = predefinedData.get();
        if (pd == null || pd.ldapFilter == null) {
            return new ArrayList<LdapFilter>(0);
        }
        return pd.ldapFilter;
    }

    public static List<NetShare> getPredefinedNetshares() {
        PredefinedData pd = predefinedData.get();
        if (pd == null || pd.netShares == null) {
            return new ArrayList<NetShare>(0);
        }
        return pd.netShares;
    }

    public static List<PresetRunScript> getPredefinedRunScripts() {
        PredefinedData pd = predefinedData.get();
        if (pd == null || pd.runScripts == null) {
            return new ArrayList<PresetRunScript>(0);
        }
        return pd.runScripts;
    }

    public static List<PresetNetRule> getPredefinedNetRules() {
        PredefinedData pd = predefinedData.get();
        if (pd == null || pd.networkExceptions == null) {
            return new ArrayList<PresetNetRule>(0);
        }
        return pd.networkExceptions;
    }
}

