/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.SatelliteStatus;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TTransferRejectedException;
import org.openslx.bwlp.thrift.iface.TransferInformation;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.filetransfer.AsyncHashGenerator;
import org.openslx.dozmod.filetransfer.UploadTask;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.WrappedException;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class UploadInitiator {
    private static final Logger LOGGER = Logger.getLogger(UploadInitiator.class);
    private static final long SIZE_CHECK_EXTRA_UL = 0x9600000L;
    private final File diskFile;
    private final long fileSize;
    private final String imageBaseId;
    private final ByteBuffer machineDescription;
    private final AsyncHashGenerator hashGen;
    private TransferInformation transferInformation = null;
    private UploadTask uploadTask;
    private UploadInitState initState = UploadInitState.IDLE;
    private String errorMessage = null;
    GotUploadTokenCallback gotTokenCallback = null;
    private QuickTimer.Task startUploadInternal = new QuickTimer.Task(){

        @Override
        public void fire() {
            LOGGER.debug("start upload internal");
            try {
                UploadInitiator.this.transferInformation = ThriftManager.getSatClient().requestImageVersionUpload(Session.getSatelliteToken(), UploadInitiator.this.imageBaseId, UploadInitiator.this.fileSize, null, UploadInitiator.this.machineDescription);
            }
            catch (TAuthorizationException e) {
                UploadInitiator.this.errorMessage = "Upload vom Server verweigert";
                UploadInitiator.this.cancelError();
                this.cancel();
                return;
            }
            catch (TTransferRejectedException e) {
                if (e.message != null && e.message.startsWith("Server busy")) {
                    UploadInitiator.this.initState = UploadInitState.WAITING_FOR_SLOT;
                } else {
                    UploadInitiator.this.errorMessage = "Upload-Anfrage gescheitert!";
                    UploadInitiator.this.cancelError();
                    this.cancel();
                }
                return;
            }
            catch (TException e) {
                UploadInitiator.this.errorMessage = "Upload-Anfrage gescheitert!";
                UploadInitiator.this.cancelError();
                this.cancel();
                return;
            }
            LOGGER.info("Version upload granted, versionId: " + UploadInitiator.this.transferInformation.toString());
            if (UploadInitiator.this.gotTokenCallback != null) {
                UploadInitiator.this.gotTokenCallback.fire();
            }
            if (UploadInitiator.this.hashGen != null) {
                UploadInitiator.this.hashGen.setUploadToken(((UploadInitiator)UploadInitiator.this).transferInformation.token);
            }
            UploadInitiator.this.initState = UploadInitState.UPLOAD_STARTING;
            QuickTimer.scheduleAtFixedRate(UploadInitiator.this.launchUploadTask, 1L, 100L);
            this.cancel();
        }
    };
    private QuickTimer.Task launchUploadTask = new QuickTimer.Task(){

        @Override
        public void fire() {
            LOGGER.debug("launch upload task");
            if (UploadInitiator.this.initState != UploadInitState.UPLOAD_STARTING) {
                this.cancel();
                return;
            }
            if (UploadInitiator.this.uploadTask == null) {
                LOGGER.debug("Starting upload for: " + UploadInitiator.this.diskFile.getName());
                try {
                    UploadInitiator.this.uploadTask = new UploadTask(Session.getSatelliteAddress(), UploadInitiator.this.transferInformation.getPlainPort(), UploadInitiator.this.transferInformation.getToken(), UploadInitiator.this.diskFile);
                }
                catch (FileNotFoundException e) {
                    UploadInitiator.this.errorMessage = "Kann VM nicht hochladen: Datei nicht gefunden\n\n" + UploadInitiator.this.diskFile.getAbsolutePath();
                    UploadInitiator.this.cancelError();
                    this.cancel();
                    return;
                }
                UploadInitiator.this.uploadTask.setMinConnections(Config.getTransferConnectionCount());
                Thread uploadThread = new Thread(UploadInitiator.this.uploadTask);
                uploadThread.setDaemon(true);
                uploadThread.start();
            }
            if (UploadInitiator.this.uploadTask.getFailCount() == 0 && UploadInitiator.this.uploadTask.getTransferCount() == 0 && !UploadInitiator.this.uploadTask.isCanceled()) {
                return;
            }
            if (!UploadInitiator.this.uploadTask.isComplete() && UploadInitiator.this.uploadTask.getTransferCount() == 0) {
                UploadInitiator.this.errorMessage = "Aufbau der Verbindung zum Hochladen fehlgeschlagen";
                UploadInitiator.this.cancelError();
                this.cancel();
                return;
            }
            UploadInitiator.this.initState = UploadInitState.UPLOAD_STARTED;
            this.cancel();
        }
    };

    public UploadInitiator(String imageBaseId, File diskFile, ByteBuffer machineDescription) throws WrappedException, IOException {
        AsyncHashGenerator hg;
        SatelliteStatus status;
        if (!diskFile.canRead()) {
            throw new FileNotFoundException(diskFile.getName());
        }
        this.fileSize = diskFile.length();
        try {
            status = ThriftManager.getSatClient().getStatus();
        }
        catch (TException e1) {
            throw new WrappedException(e1, "Konnte Status des Satelliten nicht abfragen!");
        }
        if (status.getAvailableStorageBytes() != -1L && status.getAvailableStorageBytes() < this.fileSize + 0x9600000L) {
            throw new IOException("Nicht gen\u00fcgend Speicherplatz auf dem Satelliten.\nL\u00f6schen Sie nicht verwendete VMs oder kontaktieren Sie den Satelliten-Administrator.");
        }
        this.diskFile = diskFile;
        try {
            hg = new AsyncHashGenerator(diskFile);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn("Cannot instantiate hash generator: No error correction available!");
            hg = null;
        }
        this.hashGen = hg;
        this.machineDescription = machineDescription;
        this.imageBaseId = imageBaseId;
    }

    public synchronized void startHashing() throws IllegalThreadStateException {
        if (this.hashGen == null) {
            return;
        }
        this.hashGen.start();
    }

    public synchronized void startUpload(GotUploadTokenCallback gotTokenCallback) {
        if (this.initState != UploadInitState.IDLE) {
            throw new IllegalStateException("Upload already started");
        }
        this.gotTokenCallback = gotTokenCallback;
        this.initState = UploadInitState.REQUESTING;
        QuickTimer.scheduleAtFixedRate(this.startUploadInternal, 1L, TimeUnit.SECONDS.toMillis(15L));
    }

    public synchronized void cancelError() {
        if (this.initState == UploadInitState.ERROR) {
            return;
        }
        this.initState = UploadInitState.ERROR;
        if (this.hashGen != null) {
            this.hashGen.cancel();
        }
        if (this.uploadTask != null) {
            this.uploadTask.cancel();
        }
        if (this.transferInformation != null) {
            try {
                ThriftManager.getSatClient().cancelUpload(this.transferInformation.token);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public UploadInitState getState() {
        return this.initState;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public AsyncHashGenerator getHasher() {
        return this.hashGen;
    }

    public UploadTask getUploadTask() {
        return this.uploadTask;
    }

    public String getToken() {
        return this.transferInformation == null ? null : this.transferInformation.token;
    }

    public static interface GotUploadTokenCallback {
        public void fire();
    }

    public static enum UploadInitState {
        IDLE,
        REQUESTING,
        WAITING_FOR_SLOT,
        UPLOAD_STARTING,
        UPLOAD_STARTED,
        ERROR;

    }
}

