/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift;

import java.awt.Frame;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImageBaseWrite;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.thrift.ImageDetailsActions;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class ImageLocalDetailsActions
implements ImageDetailsActions {
    private static final Logger LOGGER = Logger.getLogger(ImageLocalDetailsActions.class);
    private final Frame parent;

    public ImageLocalDetailsActions(Frame parent) {
        this.parent = parent;
    }

    @Override
    public void getImageDetails(final String imageBaseId, final ThriftActions.ImageMetaCallback callback) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            ImageDetailsRead details = null;
            Map<String, ImagePermissions> permissions = null;

            @Override
            public void fire() {
                this.details = ThriftActions.getImageDetails(ImageLocalDetailsActions.this.parent, imageBaseId);
                this.permissions = ThriftActions.getImagePermissions(ImageLocalDetailsActions.this.parent, imageBaseId);
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.fetchedImageDetails(details, permissions);
                        }
                    }
                });
            }
        });
    }

    @Override
    public boolean setImageOwner(String imageBaseId, UserInfo user) {
        return ThriftActions.setImageOwner(this.parent, imageBaseId, user);
    }

    @Override
    public void updateImageBase(String imageBaseId, ImageBaseWrite data) throws TException, TAuthorizationException, TNotFoundException, TInvocationException {
        ThriftActions.updateImageBase(imageBaseId, data);
    }

    @Override
    public void writeImagePermissions(final String imageBaseId, final Map<String, ImagePermissions> customPermissions) throws TException {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                try {
                    ThriftActions.writeImagePermissions(imageBaseId, customPermissions);
                }
                catch (TException e) {
                    ThriftError.showMessage(ImageLocalDetailsActions.this.parent, LOGGER, e, "Could not write permissions");
                }
            }
        });
        ThriftActions.writeImagePermissions(imageBaseId, customPermissions);
    }

    @Override
    public void deleteImageVersion(ImageVersionDetails version, ThriftActions.DeleteCallback callback) {
        ThriftActions.deleteImageVersion(this.parent, version, callback);
    }

    @Override
    public boolean isImagePublishSupported() {
        return Session.isImagePublishSupported();
    }

    @Override
    public void setVirtualizerConfig(final String imageVersionId, final ByteBuffer machineDescription, final ImageDetailsActions.VirtConfCallback callback) {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            boolean success = false;

            @Override
            public void fire() {
                try {
                    ThriftManager.getSatClient().setImageVersionVirtConfig(Session.getSatelliteToken(), imageVersionId, machineDescription);
                    this.success = true;
                }
                catch (TException e) {
                    ThriftError.showMessage(ImageLocalDetailsActions.this.parent, LOGGER, e, "Fehler beim Speichern der VM-Konfiguration!");
                }
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (success && callback != null) {
                            callback.virtConfCallback(success);
                        }
                    }
                });
            }
        });
    }
}

