/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.page;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.dozmod.gui.control.table.ImageTable;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.layout.LectureImageListPageLayout;
import org.openslx.dozmod.permissions.ImagePerms;
import org.openslx.dozmod.state.LectureWizardState;
import org.openslx.dozmod.thrift.cache.ImageCache;
import org.openslx.util.QuickTimer;

public class LectureImageListPage
extends LectureImageListPageLayout {
    private static final Logger LOGGER = Logger.getLogger(LectureImageListPage.class);
    private LectureWizardState state = null;
    private final ImageTable imageTable = this.ctlImageList.getImageTable();

    public LectureImageListPage(final Wizard wizard, LectureWizardState state) {
        super(wizard);
        this.state = state;
        this.setPageComplete(false);
        this.imageTable.setColumnVisible(ImageTable.COL_OS, false);
        this.imageTable.setColumnVisible(ImageTable.COL_TEMPLATE, false);
        this.imageTable.setColumnVisible(ImageTable.COL_SIZE, false);
        this.imageTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LectureImageListPage.this.reactToUserInput();
            }
        });
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                ImageCache.get(true);
            }
        });
        this.imageTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    wizard.doNext();
                }
            }
        });
    }

    @Override
    protected void onPageEnter() {
        this.ctlImageList.refreshList(false, 1);
    }

    private boolean reactToUserInput() {
        boolean b = this.isPageValid();
        this.setPageComplete(b);
        return b;
    }

    @Override
    protected boolean wantNextOrFinish() {
        return this.reactToUserInput();
    }

    private boolean isPageValid() {
        ImageSummaryRead selected = (ImageSummaryRead)this.imageTable.getSelectedItem();
        if (selected != null && selected.isValid && ImagePerms.canLink(selected)) {
            this.state.image = selected;
            this.state.imageVersionId = selected.getLatestVersionId();
            this.setDescription("Klicken Sie auf 'Weiter'");
            return true;
        }
        if (selected != null && ImagePerms.canLink(selected)) {
            this.setErrorMessage("Unzureichende Berechtigungen um auf diese VM zu verlinken.");
        } else {
            this.setErrorMessage("Ung\u00fcltige VM ausgew\u00e4hlt");
        }
        return false;
    }
}

