/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.page;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.QFileChooser;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.layout.ImageUploadPageLayout;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.dozmod.thrift.UploadInitiator;
import org.openslx.dozmod.thrift.WrappedException;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.sat.thrift.version.Feature;
import org.openslx.util.vm.DiskImage;
import org.openslx.util.vm.VmMetaData;
import org.openslx.util.vm.VmwareMetaData;

public class ImageUploadPage
extends ImageUploadPageLayout {
    private static final Logger LOGGER = Logger.getLogger(ImageUploadPage.class);
    private UploadWizardState state;
    private String lastDetectedName = null;
    private ImageDetailsRead existingImage = null;
    private final FileNameExtensionFilter allSupportedFilter;
    private final FileNameExtensionFilter vmxFilter = new FileNameExtensionFilter("VMware Virtual Machine", "vmx");
    private final FileNameExtensionFilter vboxFilter = new FileNameExtensionFilter("VirtualBox Virtual Machine", "vbox");

    public ImageUploadPage(Wizard wizard, UploadWizardState uploadWizardState, ImageDetailsRead existingImage) {
        super(wizard);
        this.setPageComplete(false);
        this.canComeBack = false;
        this.state = uploadWizardState;
        this.existingImage = existingImage;
        this.lblImageName.setVisible(existingImage == null);
        this.txtImageName.setVisible(existingImage == null);
        this.txtInfoText.setVisible(existingImage == null);
        this.chkLicenseRestricted.setVisible(existingImage != null);
        this.chkLicenseRestricted.setSelected(existingImage != null);
        this.btnBrowseForImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageUploadPage.this.browseForVm();
            }
        });
        this.txtImageFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ImageUploadPage.this.browseForVm();
                }
            }
        });
        this.allSupportedFilter = Session.hasFeature(Feature.MULTIPLE_HYPERVISORS) ? new FileNameExtensionFilter("All Supported", "vmx", "vbox") : new FileNameExtensionFilter("All Supported", "vmx");
        this.btnBrowseForImage.requestFocus();
    }

    private void browseForVm() {
        QFileChooser fc = new QFileChooser(Config.getUploadPath(), false);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(this.vmxFilter);
        if (Session.hasFeature(Feature.MULTIPLE_HYPERVISORS)) {
            fc.addChoosableFileFilter(this.vboxFilter);
        }
        fc.addChoosableFileFilter(this.allSupportedFilter);
        fc.setFileFilter(this.allSupportedFilter);
        if (this.existingImage != null) {
            if (this.existingImage.virtId.equals("vmware")) {
                fc.setFileFilter(this.vmxFilter);
            } else if (this.existingImage.virtId.equals("virtualbox")) {
                fc.setFileFilter(this.vboxFilter);
            }
        }
        int action = fc.showOpenDialog(this.getDialog());
        File file = fc.getSelectedFile();
        if (action != 0 || file == null) {
            return;
        }
        this.vmSelected(file.getAbsoluteFile());
    }

    private void vmSelected(File file) {
        String imageName;
        DiskImage diskImage;
        Config.setUploadPath(file.getParent());
        this.txtImageFile.setText("");
        this.txtImageName.setText("");
        try {
            this.state.meta = VmMetaData.getInstance(MetaDataCache.getOperatingSystems(), file);
        }
        catch (IOException e) {
            Gui.showMessageBox(this, "Konnte " + file.getPath() + " nicht lesen", MessageType.ERROR, LOGGER, e);
            this.setPageComplete(false);
            return;
        }
        if (this.state.meta == null || this.state.meta.getDisplayName() == null) {
            this.setErrorMessage("Ung\u00fcltige Konfigurationsdatei ausgew\u00e4hlt!");
            this.setPageComplete(false);
            return;
        }
        String fileformat = this.state.meta.getVirtualizer().virtName;
        if (!(this.state.meta instanceof VmwareMetaData) && !Session.hasFeature(Feature.MULTIPLE_HYPERVISORS)) {
            this.setErrorMessage("Der Hypervisor der gew\u00e4hlten VM (" + fileformat + ") wird vom aktuellen Satellitenserver nicht unterst\u00fctzt.");
            this.setPageComplete(false);
            return;
        }
        if (this.existingImage != null && !this.existingImage.virtId.equals(this.state.meta.getVirtualizer().virtId)) {
            Virtualizer existingImageVirtualizer = MetaDataCache.getVirtualizerById(this.existingImage.virtId);
            String existingImageVirtualizerName = "<error>";
            if (existingImageVirtualizer != null) {
                existingImageVirtualizerName = existingImageVirtualizer.virtName;
            }
            this.setErrorMessage("Neue Versionen m\u00fcssen vom Typ " + existingImageVirtualizerName + " sein.");
            this.setPageComplete(false);
            return;
        }
        List<VmMetaData.HardDisk> hdds = this.state.meta.getHdds();
        if (hdds.size() == 0 || hdds.get((int)0).diskImage == null) {
            this.setErrorMessage("Die gew\u00e4hlte " + fileformat + "-Datei enth\u00e4lt keine virtuelle Festplatte!");
            this.setPageComplete(false);
            return;
        }
        if (hdds.size() > 1) {
            this.setErrorMessage("Die gew\u00e4hlte " + fileformat + "-Datei enth\u00e4lt mehr als eine virtuelle Festplatte!");
            this.setPageComplete(false);
            return;
        }
        File vmDiskFileInfo = new File(hdds.get((int)0).diskImage);
        if (!vmDiskFileInfo.isAbsolute()) {
            File vmBaseDirectory = file.getParentFile();
            vmDiskFileInfo = new File(vmBaseDirectory, hdds.get((int)0).diskImage);
        }
        try {
            diskImage = new DiskImage(vmDiskFileInfo);
        }
        catch (FileNotFoundException e) {
            this.setErrorMessage("'" + vmDiskFileInfo.getName() + "' kann nicht gefunden werden!");
            this.setPageComplete(false);
            return;
        }
        catch (IOException e) {
            this.setErrorMessage("'" + vmDiskFileInfo.getName() + "' kann nicht gelesen werden!");
            this.setPageComplete(false);
            return;
        }
        catch (DiskImage.UnknownImageFormatException e) {
            this.setErrorMessage("'" + vmDiskFileInfo.getName() + "' hat unbekanntes Dateiformat!");
            LOGGER.debug("Selected disk file has unknown format.", e);
            this.setPageComplete(false);
            return;
        }
        if (diskImage.isSnapshot || this.state.meta.isMachineSnapshot()) {
            Gui.showMessageBox("Von der ausgew\u00e4hlten VM wurde ein Snapshot erstellt. In diesem Zustand kann\ndie VM leider nicht ins " + Branding.getServiceName() + "-System geladen werden. Bitte konsolidieren Sie zun\u00e4chst\nden Snapshot und versuchen Sie es erneut.", MessageType.WARNING, null, null);
            this.setErrorMessage("Die gew\u00e4hlte VM befindet sich im Snapshot-Zustand.");
            this.setPageComplete(false);
            return;
        }
        if (!diskImage.isStandalone) {
            Gui.showMessageBox("Die zu dieser VM geh\u00f6rige Virtuelle Festplatte ist im Format '" + diskImage.subFormat + "'.\nDieses Format wird von " + Branding.getApplicationName() + " nicht unterst\u00fctzt. Bitte konvertieren Sie die VM\nin das Format 'monolithicSparse'.", MessageType.WARNING, null, null);
            this.setErrorMessage("Die VMDK Datei der VM hat ein inkompatibles Format");
            this.setPageComplete(false);
            return;
        }
        this.state.diskFile = vmDiskFileInfo;
        this.state.descriptionFile = file;
        if (this.existingImage == null && ((imageName = this.txtImageName.getText()).isEmpty() || imageName.equals(this.lastDetectedName))) {
            this.txtImageName.setText(this.state.meta.getDisplayName());
        }
        this.lastDetectedName = this.state.meta.getDisplayName();
        this.state.detectedOs = this.state.meta.getOs();
        this.txtImageFile.setText(file.getAbsolutePath());
        this.setErrorMessage(null);
        this.setDescription("Sie k\u00f6nnen jetzt den Upload starten.");
        this.setPageComplete(true);
    }

    private boolean askCancelLockFile(String ... lockFiles) {
        for (String lockFile : lockFiles) {
            File file = new File(lockFile);
            if (!file.exists()) continue;
            return !Gui.showMessageBox(this, "Die gew\u00e4hlte VM scheint noch in Verwendung zu sein. Bitte fahren Sie die VM\nvor dem Hochladen herunter und schlie\u00dfen Sie den VMware Player, ansonsten\nkann die VM nach dem Hochladen besch\u00e4digt sein.\n\nM\u00f6chten Sie diese Warnung ignorieren und trotzdem fortfahren?\n(Sie sollten sich sicher sein, was sie tun, wenn Sie hier 'Ja' w\u00e4hlen)", MessageType.QUESTION_YESNO, null, null);
        }
        return false;
    }

    @Override
    protected boolean wantNextOrFinish() {
        if (this.askCancelLockFile(this.state.descriptionFile.getAbsolutePath() + ".lck", this.state.diskFile.getAbsolutePath() + ".lck")) {
            this.setErrorMessage("Die gew\u00e4hlte VM wird noch verwendet");
            return false;
        }
        String string = this.state.name = this.existingImage != null ? this.existingImage.getImageName() : this.txtImageName.getText();
        if (this.existingImage == null) {
            if (this.state.uuid == null) {
                this.state.uuid = ThriftActions.createImage(JOptionPane.getFrameForComponent(this), this.state.name);
                if (this.state.uuid == null) {
                    return false;
                }
                this.txtImageName.setEnabled(false);
                this.btnBrowseForImage.setEnabled(false);
                this.txtImageFile.setEnabled(false);
            }
        } else {
            this.state.uuid = this.existingImage.getImageBaseId();
        }
        if (this.state.upload == null) {
            try {
                this.state.upload = new UploadInitiator(this.state.uuid, this.state.diskFile, this.state.meta.getFilteredDefinition());
            }
            catch (WrappedException e) {
                ThriftError.showMessage(this, LOGGER, e.exception, e.displayMessage);
                return false;
            }
            catch (IOException e) {
                Gui.showMessageBox(this, "Upload-Initialisierung fehlgeschlagen", MessageType.ERROR, LOGGER, e);
                return false;
            }
        }
        this.state.upload.startHashing();
        return true;
    }
}

