/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard;

import java.awt.Window;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.LectureWrite;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.LectureListWindow;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.page.LectureCreationPage;
import org.openslx.dozmod.gui.wizard.page.LectureCustomPermissionPage;
import org.openslx.dozmod.gui.wizard.page.LectureImageListPage;
import org.openslx.dozmod.gui.wizard.page.LectureLocationSelectionPage;
import org.openslx.dozmod.gui.wizard.page.LectureOptionsPage;
import org.openslx.dozmod.state.LectureWizardState;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.cache.LectureCache;
import org.openslx.dozmod.thrift.cache.MetaDataCache;

public class LectureWizard
extends Wizard
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(LectureWizard.class);
    public final LectureWizardState state = new LectureWizardState();

    public LectureWizard(Window parent, ImageSummaryRead image, String imageVersionId) {
        super(parent);
        if (image != null && imageVersionId != null) {
            this.state.image = image;
            this.state.imageVersionId = imageVersionId;
        }
        this.state.defaultPermissions = Session.getSatelliteConfig().defaultLecturePermissions;
        this.addPage(new LectureCreationPage((Wizard)this, this.state));
        if (image == null && imageVersionId == null) {
            this.addPage(new LectureImageListPage((Wizard)this, this.state));
        }
        this.addPage(new LectureOptionsPage((Wizard)this, this.state));
        this.addPage(new LectureCustomPermissionPage((Wizard)this, this.state));
        if (MetaDataCache.getLocations() != null && !MetaDataCache.getLocations().isEmpty()) {
            this.addPage(new LectureLocationSelectionPage((Wizard)this, this.state));
        }
    }

    @Override
    public String getWindowTitle() {
        return "Neue Veranstaltung erzeugen";
    }

    @Override
    protected boolean onCancelRequest() {
        return Gui.showMessageBox(this, "M\u00f6chten Sie den Vorgang wirklich abbrechen?", MessageType.QUESTION_YESNO, null, null);
    }

    @Override
    public boolean wantConfirmQuit() {
        return this.state.uuid != null;
    }

    @Override
    public void escapePressed() {
        this.doCancel();
    }

    @Override
    public boolean wantFinish() {
        if (!this.isStateValid()) {
            return false;
        }
        if (this.state.uuid != null) {
            LOGGER.error("UUID for new lecture already present, something's bad...");
            return false;
        }
        String uuid = null;
        uuid = ThriftActions.createLecture(JOptionPane.getFrameForComponent(this), this.lectureWriteFromState());
        if (uuid == null) {
            return false;
        }
        this.state.uuid = uuid;
        if (this.state.permissionMap != null && !this.state.permissionMap.isEmpty() && !ThriftActions.writeLecturePermissions(JOptionPane.getFrameForComponent(this), this.state.uuid, this.state.permissionMap)) {
            return false;
        }
        Gui.showMessageBox(this, "Veranstaltung erstellt!", MessageType.INFO, null, null);
        LectureCache.get(true);
        MainWindow.showPage(LectureListWindow.class);
        return true;
    }

    private boolean isStateValid() {
        if (this.state.name == null || this.state.name.isEmpty()) {
            LOGGER.error("No name set in state!");
            return false;
        }
        if (this.state.description == null || this.state.description.isEmpty()) {
            LOGGER.error("No description set in state!");
            return false;
        }
        if (this.state.start == null) {
            LOGGER.error("No start date set in state!");
            return false;
        }
        if (this.state.end == null) {
            LOGGER.error("No start date set in state!");
            return false;
        }
        return true;
    }

    private LectureWrite lectureWriteFromState() {
        LectureWrite lw = new LectureWrite(this.state.name, this.state.description, this.state.imageVersionId, this.state.autoUpdate, this.state.isEnabled, this.state.start.getTime() / 1000L, this.state.end.getTime() / 1000L, this.state.runScriptText, null, this.state.isExam, this.state.internetAccess, this.state.defaultPermissions, this.state.locations, this.state.onlyInSelectedLocations, false, this.state.usbAllowed);
        lw.networkExceptions = this.state.netRules;
        return lw;
    }
}

