/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.LectureRead;
import org.openslx.bwlp.thrift.iface.LectureWrite;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.changemonitor.AbstractControlWrapper;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.configurator.NetrulesConfigurator;
import org.openslx.dozmod.gui.configurator.StartupConfigurator;
import org.openslx.dozmod.gui.helper.DateTimeHelper;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.LectureChangeImage;
import org.openslx.dozmod.gui.window.UserListWindow;
import org.openslx.dozmod.gui.window.layout.LectureDetailsWindowLayout;
import org.openslx.dozmod.permissions.ImagePerms;
import org.openslx.dozmod.permissions.LecturePerms;
import org.openslx.dozmod.thrift.ImageLocalDetailsActions;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;
import org.openslx.thrifthelper.Comparators;
import org.openslx.thrifthelper.ThriftManager;

public class LectureDetailsWindow
extends LectureDetailsWindowLayout
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(LectureDetailsWindow.class);
    private final LectureDetailsWindow me = this;
    private LectureUpdatedCallback callback = null;
    private LectureRead lecture = null;
    private final ImageLocalDetailsActions actionHandler;
    private ImageDetailsRead image = null;
    private Map<String, LecturePermissions> customPermissions;
    private boolean adminRightsFromDefaultPermissions;
    private final DialogChangeMonitor changeMonitor;
    private final AbstractControlWrapper<?> changeListenerPermissions;

    public LectureDetailsWindow(Frame modalParent, LectureUpdatedCallback callback) {
        super(modalParent);
        this.callback = callback;
        this.setDefaultCloseOperation(0);
        this.changeMonitor = new DialogChangeMonitor(new DialogChangeMonitor.Callback(){

            @Override
            public void validityChanged(String errorMessage) {
                LectureDetailsWindow.this.lblError.setText(errorMessage);
                LectureDetailsWindow.this.btnSaveChanges.setEnabled(LectureDetailsWindow.this.changeMonitor.isValid() && LectureDetailsWindow.this.changeMonitor.wasEverModified());
                LOGGER.info("Valid: " + LectureDetailsWindow.this.changeMonitor.isValid());
            }

            @Override
            public void modificationChanged() {
                LectureDetailsWindow.this.btnSaveChanges.setEnabled(LectureDetailsWindow.this.changeMonitor.isValid() && LectureDetailsWindow.this.changeMonitor.wasEverModified());
                LOGGER.info("Changed: " + LectureDetailsWindow.this.changeMonitor.isCurrentlyModified());
            }
        });
        this.changeMonitor.addFixedCombo(this.cboVersions, Comparators.imageVersionDetails).addConstraint(new DialogChangeMonitor.ValidationConstraint<ImageVersionDetails>(){

            @Override
            public String checkStateValid(ImageVersionDetails userInput) {
                if (userInput != null && userInput.isValid) {
                    return null;
                }
                return "Keine/Ung\u00fcltige VM-Version ausgew\u00e4hlt";
            }
        });
        Calendar c = Calendar.getInstance();
        c.add(5, Session.getSatelliteConfig().maxLectureValidityDays);
        final Date maxValidity = c.getTime();
        DialogChangeMonitor.ValidationConstraint<Object> dateRangeValidator = new DialogChangeMonitor.ValidationConstraint<Object>(){

            @Override
            public String checkStateValid(Object ignored) {
                Date start = DateTimeHelper.getDateFrom(LectureDetailsWindow.this.dtpStartDate, LectureDetailsWindow.this.spnStartTime);
                Date end = DateTimeHelper.getDateFrom(LectureDetailsWindow.this.dtpEndDate, LectureDetailsWindow.this.spnEndTime);
                if (!end.after(start)) {
                    return "Enddatum darf nicht vor dem Startdatum liegen";
                }
                if (end.after(maxValidity)) {
                    return "Enddatum liegt nach dem " + FormatHelper.shortDate(maxValidity);
                }
                return null;
            }
        };
        this.changeMonitor.add(this.chkAutoUpdate);
        this.changeMonitor.add(this.chkIsExam);
        this.changeMonitor.add(this.chkHasInternetAccess);
        this.changeMonitor.add(this.chkHasUsbAccess);
        this.changeMonitor.add(this.chkIsActive);
        this.changeMonitor.add(this.chkCustomPermAdmin);
        this.changeMonitor.add(this.chkCustomPermEdit);
        this.changeMonitor.add(this.txtTitle).addConstraint(new DialogChangeMonitor.TextNotEmptyConstraint("Veranstaltungsname darf nicht leer sein"));
        this.changeMonitor.add(this.txtDescription).addConstraint(new DialogChangeMonitor.TextNotEmptyConstraint("Beschreibung darf nicht leer sein"));
        this.changeMonitor.add(this.dtpEndDate).addConstraint(dateRangeValidator);
        this.changeMonitor.add(this.dtpStartDate).addConstraint(dateRangeValidator);
        this.changeMonitor.add(this.spnEndTime).addConstraint(dateRangeValidator);
        this.changeMonitor.add(this.spnStartTime).addConstraint(dateRangeValidator);
        this.changeMonitor.add(this.ctlNetrulesConfigurator).addConstraint(new DialogChangeMonitor.NotNullConstraint("Fehlerhafte Netzwerkregeln"));
        this.changeListenerPermissions = this.changeMonitor.add(this.ctlPermissionManager);
        this.ctlLocationSelector.addToChangeMonitor(this.changeMonitor);
        this.ctlRunscriptConfigurator.addToChangeMonitor(this.changeMonitor);
        this.ctlNetshareConfigurator.addToChangeMonitor(this.changeMonitor);
        this.ctlLdapFilterConfigurator.addToChangeMonitor(this.changeMonitor);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LectureDetailsWindow.this.safeClose();
            }
        });
        this.actionHandler = new ImageLocalDetailsActions(JOptionPane.getFrameForComponent(this));
        this.btnLinkImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ImageSummaryRead newImage = LectureChangeImage.open(LectureDetailsWindow.this, LectureDetailsWindow.this.changeMonitor);
                if (newImage == null) {
                    return;
                }
                ThriftActions.ImageMetaCallback callback = new ThriftActions.ImageMetaCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void fetchedImageDetails(ImageDetailsRead imageDetails, Map<String, ImagePermissions> permissions) {
                        if (imageDetails == null) {
                            return;
                        }
                        LectureDetailsWindow lectureDetailsWindow = LectureDetailsWindow.this.me;
                        synchronized (lectureDetailsWindow) {
                            LectureDetailsWindow.this.image = imageDetails;
                        }
                        ((LectureDetailsWindow)LectureDetailsWindow.this).lecture.imageBaseId = newImage.imageBaseId;
                        ((LectureDetailsWindow)LectureDetailsWindow.this).lecture.imageVersionId = newImage.latestVersionId;
                        LectureDetailsWindow.this.fillVersionsCombo();
                        LectureDetailsWindow.this.cboVersions.setEnabled(false);
                        LectureDetailsWindow.this.chkAutoUpdate.setSelected(true);
                        LectureDetailsWindow.this.txtImageName.setText(newImage.getImageName());
                    }
                };
                LectureDetailsWindow.this.actionHandler.getImageDetails(newImage.imageBaseId, callback);
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureDetailsWindow.this.safeClose();
            }
        });
        this.btnDownloadImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureDetailsWindow.this.performImageDownload();
            }
        });
        this.chkAutoUpdate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LectureDetailsWindow.this.cboVersions.setEnabled(!LectureDetailsWindow.this.chkAutoUpdate.isSelected());
            }
        });
        this.btnChangeOwner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserListWindow.open(LectureDetailsWindow.this.me, new UserListWindow.UserAddedCallback(){

                    @Override
                    public void userAdded(UserInfo user, UserListWindow window) {
                        window.dispose();
                        if (Gui.showMessageBox(LectureDetailsWindow.this.me, "Sind Sie sicher, dass sie die Besitzerrechte an einen anderen Account \u00fcbertragen wollen?", MessageType.QUESTION_YESNO, LOGGER, null)) {
                            LectureDetailsWindow.this.setLectureOwner(user);
                        }
                    }
                }, "Besitzer festlegen", ((LectureDetailsWindow)LectureDetailsWindow.this).lecture.ownerId);
            }
        });
        ItemListener updateDefaultPermissionListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() == LectureDetailsWindow.this.chkCustomPermAdmin) {
                    ((LectureDetailsWindow)LectureDetailsWindow.this).lecture.defaultPermissions.admin = LectureDetailsWindow.this.chkCustomPermAdmin.isSelected();
                } else {
                    ((LectureDetailsWindow)LectureDetailsWindow.this).lecture.defaultPermissions.edit = LectureDetailsWindow.this.chkCustomPermEdit.isSelected();
                }
            }
        };
        this.chkCustomPermAdmin.addItemListener(updateDefaultPermissionListener);
        this.chkCustomPermEdit.addItemListener(updateDefaultPermissionListener);
        this.btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LectureDetailsWindow.this.saveChanges();
            }
        });
        this.btnSaveChanges.setEnabled(false);
        this.toggleEditable(false);
    }

    public void setLecture(String lectureId) {
        ThriftActions.getLectureAndImageDetails(JOptionPane.getFrameForComponent(this.me), lectureId, new ThriftActions.LectureMetaCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fetchedLectureAndImageDetails(LectureRead lectureDetails, ImageDetailsRead imageDetails) {
                LectureDetailsWindow lectureDetailsWindow = LectureDetailsWindow.this.me;
                synchronized (lectureDetailsWindow) {
                    LectureDetailsWindow.this.lecture = lectureDetails;
                    LectureDetailsWindow.this.image = imageDetails;
                    if (LectureDetailsWindow.this.lecture != null) {
                        LectureDetailsWindow.this.customPermissions = ThriftActions.getLecturePermissions(JOptionPane.getFrameForComponent(LectureDetailsWindow.this.me), ((LectureDetailsWindow)LectureDetailsWindow.this).lecture.lectureId);
                    }
                    LectureDetailsWindow.this.fillDetails();
                }
            }
        });
    }

    private void fillDetails() {
        if (this.lecture == null) {
            this.txtTitle.setText("-");
            this.lblTitleInfo.setText("-");
            this.toggleEditable(false);
            return;
        }
        if (this.image == null) {
            this.txtImageName.setText("-");
            this.lblImageNameInfo.setText("-");
        } else {
            this.txtImageName.setText(this.image.getImageName());
            this.lblImageNameInfo.setText(this.image.getImageName());
        }
        this.adminRightsFromDefaultPermissions = this.lecture.defaultPermissions.admin;
        this.ctlPermissionManager.initPanel(this.customPermissions, this.lecture.defaultPermissions, this.lecture.ownerId);
        this.chkCustomPermAdmin.setSelected(this.lecture.defaultPermissions.admin);
        this.chkCustomPermEdit.setSelected(this.lecture.defaultPermissions.edit);
        this.ctlLocationSelector.setOnlyInSelection(this.lecture.limitToLocations);
        this.ctlLocationSelector.setSelectedLocationsAsIds(this.lecture.locationIds);
        this.ctlRunscriptConfigurator.setState(this.lecture);
        this.ctlNetshareConfigurator.setState(this.lecture.networkShares, this.lecture.presetNetworkShares);
        this.ctlLdapFilterConfigurator.setState(this.lecture.ldapFilters, this.lecture.presetLdapFilters);
        this.ctlNetrulesConfigurator.setState(this.lecture);
        this.txtTitle.setText(this.lecture.getLectureName());
        this.lblTitleInfo.setText(this.lecture.getLectureName());
        this.txtDescription.setText(this.lecture.getDescription());
        this.lblOwner.setUser(UserCache.find(this.lecture.getOwnerId()));
        this.lblOwnerInfo.setUser(UserCache.find(this.lecture.getOwnerId()));
        this.lblUpdater.setUser(UserCache.find(this.lecture.getUpdaterId()));
        this.lblCreateTime.setText(FormatHelper.longDate(this.lecture.getCreateTime()));
        this.lblUpdateTime.setText(FormatHelper.longDate(this.lecture.getUpdateTime()));
        this.lblStartTime.setText(FormatHelper.longDate(this.lecture.getStartTime()));
        this.lblEndTime.setText(FormatHelper.longDate(this.lecture.getEndTime()));
        this.txtId.setText(this.lecture.getLectureId());
        this.chkIsActive.setSelected(this.lecture.isEnabled);
        this.chkHasInternetAccess.setSelected(this.lecture.hasInternetAccess);
        this.chkHasUsbAccess.setSelected(this.lecture.hasUsbAccess);
        this.chkIsExam.setSelected(this.lecture.isExam);
        this.chkAutoUpdate.setSelected(this.lecture.autoUpdate);
        this.cboVersions.setEnabled(!this.lecture.autoUpdate);
        this.lblUseCount.setText(Integer.toString(this.lecture.useCount));
        this.fillVersionsCombo();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(new Date(this.lecture.getStartTime() * 1000L));
        this.dtpStartDate.getModel().setDate(startCal.get(1), startCal.get(2), startCal.get(5));
        this.spnStartTime.getModel().setValue(startCal.getTime());
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(new Date(this.lecture.getEndTime() * 1000L));
        this.dtpEndDate.getModel().setDate(endCal.get(1), endCal.get(2), endCal.get(5));
        this.spnEndTime.getModel().setValue(endCal.getTime());
        this.toggleEditable(true);
        this.pnlTabs.setSelectedIndex(this.pnlTabs.indexOfTab("\u00dcbersicht"));
        this.setVisible(true);
        this.changeMonitor.reset();
    }

    private void fillVersionsCombo() {
        List<ImageVersionDetails> versions = this.image == null ? new ArrayList<ImageVersionDetails>(0) : this.image.getVersions();
        Iterator<ImageVersionDetails> it = versions.iterator();
        while (it.hasNext()) {
            ImageVersionDetails version = it.next();
            if (version.isValid || this.lecture.imageVersionId.equals(version.versionId)) continue;
            it.remove();
        }
        Collections.sort(versions, new Comparator<ImageVersionDetails>(){

            @Override
            public int compare(ImageVersionDetails o1, ImageVersionDetails o2) {
                return -Long.compare(o1.getCreateTime(), o2.getCreateTime());
            }
        });
        this.cboVersions.setModel(new DefaultComboBoxModel<ImageVersionDetails>(versions.toArray(new ImageVersionDetails[versions.size()])));
        this.cboVersions.setSelectedItem(new ImageVersionDetails(this.lecture.getImageVersionId(), 0L, 0L, 0L, null, true, true, true, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLectureOwner(UserInfo user) {
        if (!ThriftActions.setLectureOwner(JOptionPane.getFrameForComponent(this), this.lecture.getLectureId(), user)) {
            return;
        }
        Gui.showMessageBox(this.me, "Besitzrechte \u00fcbertragen an " + FormatHelper.userName(user), MessageType.INFO, null, null);
        this.toggleEditable(false);
        String lectureId = this.lecture.getLectureId();
        LectureDetailsWindow lectureDetailsWindow = this.me;
        synchronized (lectureDetailsWindow) {
            this.image = null;
            this.lecture = null;
        }
        this.setLecture(lectureId);
    }

    private void performImageDownload() {
        if (this.image == null) {
            Gui.showMessageBox(this, "VM ung\u00fcltig.", MessageType.ERROR, null, null);
            return;
        }
        this.btnDownloadImage.setEnabled(false);
        long versionSize = 0L;
        for (ImageVersionDetails version : this.image.versions) {
            if (!version.versionId.equals(this.lecture.imageVersionId)) continue;
            if (!version.isValid) {
                Gui.showMessageBox(this, "Ung\u00fcltige VM-Version gew\u00e4hlt", MessageType.ERROR, null, null);
                return;
            }
            versionSize = version.fileSize;
            break;
        }
        if (versionSize == 0L) {
            Gui.showMessageBox(this, "Fehler bei der Abfrage der Gr\u00f6\u00dfe des VM-Abbildes.", MessageType.ERROR, null, null);
            return;
        }
        ThriftActions.initDownload(JOptionPane.getFrameForComponent(this), this.lecture.imageVersionId, this.image.imageName, this.image.virtId, this.image.osId, versionSize, new ThriftActions.DownloadCallback(){

            @Override
            public void downloadInitialized(boolean success) {
                if (!success) {
                    Gui.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            LectureDetailsWindow.this.btnDownloadImage.setEnabled(true);
                        }
                    });
                }
            }
        });
    }

    private void saveChanges() {
        boolean saved = this.saveChangesInternal();
        this.callback.updated(saved);
        if (saved) {
            this.dispose();
        } else {
            this.btnSaveChanges.setEnabled(true);
        }
    }

    private boolean saveChangesInternal() {
        long endTime;
        long startTime = DateTimeHelper.getDateFrom(this.dtpStartDate, this.spnStartTime).getTime() / 1000L;
        if (!this.isPeriodValid(startTime, endTime = DateTimeHelper.getDateFrom(this.dtpEndDate, this.spnEndTime).getTime() / 1000L, true)) {
            return false;
        }
        if (this.image != null) {
            String string = this.lecture.imageVersionId = this.chkAutoUpdate.isSelected() ? this.image.latestVersionId : ((ImageVersionDetails)this.cboVersions.getItemAt((int)this.cboVersions.getSelectedIndex())).versionId;
        }
        if (this.adminRightsFromDefaultPermissions && this.changeListenerPermissions.isCurrentlyChanged()) {
            if (!this.saveCustomPermissions()) {
                return false;
            }
            this.changeListenerPermissions.reset();
        }
        StartupConfigurator.StartupSettings startupSettings = this.ctlRunscriptConfigurator.getState();
        LectureWrite metadata = new LectureWrite(this.txtTitle.getText(), this.txtDescription.getText(), this.lecture.getImageVersionId(), this.chkAutoUpdate.isSelected(), this.chkIsActive.isSelected(), startTime, endTime, startupSettings.serializeItems(), null, this.chkIsExam.isSelected(), this.chkHasInternetAccess.isSelected(), this.lecture.getDefaultPermissions(), this.ctlLocationSelector.getSelectedLocationsAsIds(), this.ctlLocationSelector.getOnlyInSelection(), false, this.chkHasUsbAccess.isSelected());
        NetrulesConfigurator.StateWrapper netrules = this.ctlNetrulesConfigurator.getState();
        metadata.setNetworkExceptions(netrules.customRules);
        metadata.setPresetNetworkExceptionIds(netrules.selectedPresets);
        metadata.setNetworkShares(this.ctlNetshareConfigurator.getState());
        metadata.setLdapFilters(this.ctlLdapFilterConfigurator.getState());
        metadata.setPresetScriptIds(startupSettings.selectedScripts);
        try {
            ThriftManager.getSatClient().updateLecture(Session.getSatelliteToken(), this.lecture.getLectureId(), metadata);
            LOGGER.info("Successfully saved new metadata");
        }
        catch (TException e) {
            ThriftError.showMessage(JOptionPane.getFrameForComponent(this), LOGGER, e, "Fehler beim Speichern der Veranstaltung!");
            return false;
        }
        if (this.changeListenerPermissions.isCurrentlyChanged() && !this.saveCustomPermissions()) {
            return false;
        }
        this.changeMonitor.reset();
        return true;
    }

    private boolean saveCustomPermissions() {
        try {
            ThriftManager.getSatClient().writeLecturePermissions(Session.getSatelliteToken(), this.lecture.lectureId, this.ctlPermissionManager.getPermissions());
            LOGGER.info("Successfully saved custom permissions");
            return true;
        }
        catch (TException e) {
            ThriftError.showMessage(JOptionPane.getFrameForComponent(this), LOGGER, e, "Fehler beim \u00dcbertragen der Berechtigungen!");
            return false;
        }
    }

    private boolean isPeriodValid(long start, long end, boolean feedback) {
        if (start <= 0L || end <= 0L) {
            return false;
        }
        if (end > start) {
            return true;
        }
        String msg = "Start der Veranstaltung ist nach dem Enddatum!";
        if (feedback) {
            Gui.showMessageBox(this.me, msg, MessageType.ERROR, LOGGER, null);
        }
        this.lblError.setText(msg);
        return false;
    }

    protected void toggleEditable(boolean editable) {
        this.setTabEnabled(this.pnlTabGeneral, editable &= LecturePerms.canEdit(this.lecture));
        this.setTabEnabled(this.pnlTabPermissions, editable && LecturePerms.canAdmin(this.lecture));
        this.setTabEnabled(this.pnlTabRestrictions, editable);
        this.setTabEnabled(this.pnlTabLocations, editable);
        this.setTabEnabled(this.pnlTabRunscript, editable);
        this.setTabEnabled(this.pnlTabNetshare, editable);
        this.setTabEnabled(this.pnlTabLdapFilter, editable);
        this.setTabEnabled(this.pnlTabNetrules, editable);
        this.btnChangeOwner.setEnabled(LecturePerms.canAdmin(this.lecture));
        this.btnDownloadImage.setEnabled(ImagePerms.canDownload(this.image));
    }

    private void setTabEnabled(JPanel tab, boolean editable) {
        int index = this.pnlTabs.indexOfComponent(tab);
        if (index == -1) {
            return;
        }
        this.pnlTabs.setEnabledAt(index, editable);
    }

    public static void open(Frame modalParent, String lectureId, LectureUpdatedCallback callback) {
        LectureDetailsWindow win = new LectureDetailsWindow(modalParent, callback);
        win.setLecture(lectureId);
        win.setVisible(true);
    }

    @Override
    public void show() {
        if (!this.isVisible()) {
            this.pack();
            MainWindow.centerShell(this);
        }
        super.show();
    }

    @Override
    public boolean wantConfirmQuit() {
        return this.changeMonitor.isCurrentlyModified();
    }

    @Override
    public void escapePressed() {
        this.safeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeClose() {
        if (this.changeMonitor.isCurrentlyModified() && !Gui.showMessageBox(this.me, "\u00c4nderungen werden verworfen, wollen Sie wirklich schlie\u00dfen?", MessageType.QUESTION_YESNO, null, null)) {
            return;
        }
        LectureDetailsWindow lectureDetailsWindow = this.me;
        synchronized (lectureDetailsWindow) {
            this.lecture = null;
            this.image = null;
        }
        this.dispose();
    }

    public static interface LectureUpdatedCallback {
        public void updated(boolean var1);
    }
}

