/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.openslx.dozmod.gui.helper.TableColumnAdjuster;

public abstract class ListTable<T>
extends JTable {
    private final ListModel<T> model;
    private final TableRowSorter<ListModel<T>> sorter;
    private List<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
    private final TableColumnAdjuster adjuster;
    private final Comparator<T> itemComparator;

    public ListTable(ListTableColumn ... columns) {
        this((Comparator<T>)null, columns);
    }

    public ListTable(Comparator<T> itemComparator, ListTableColumn ... columns) {
        int i;
        for (i = 0; i < columns.length; ++i) {
            TableColumn tc = new TableColumn(i);
            tc.setHeaderValue(columns[i].colName);
            this.addColumn(tc);
        }
        this.model = new ListModel(this, columns);
        this.sorter = new TableRowSorter<ListModel<T>>(this.model);
        for (i = 0; i < columns.length; ++i) {
            if (columns[i].sortComparator == null) continue;
            this.sorter.setComparator(i, columns[i].sortComparator);
        }
        this.adjuster = new TableColumnAdjuster(this, 5);
        this.adjuster.setOnlyAdjustLarger(true);
        this.itemComparator = itemComparator;
        this.setModel(this.model);
        this.setRowSorter(this.sorter);
        this.setShowGrid(false);
        this.setCellSelectionEnabled(false);
        this.setAutoResizeMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        ListTableRenderer listTableRenderer = new ListTableRenderer();
        this.setDefaultRenderer(Object.class, listTableRenderer);
        this.setDefaultRenderer(Integer.class, listTableRenderer);
        this.setDefaultRenderer(Long.class, listTableRenderer);
        this.setDefaultRenderer(Boolean.class, this.getDefaultRenderer(Boolean.class));
        this.setDefaultRenderer(Icon.class, new IconRenderer());
        this.setDefaultEditor(Boolean.class, this.getDefaultEditor(Boolean.class));
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.sorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                ListTable.this.adjuster.adjustColumns();
            }
        });
    }

    protected abstract Object getValueAtInternal(T var1, ListTableColumn var2);

    public T getModelRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.model.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        return (T)((ListModel)this.model).data.get(rowIndex);
    }

    public T getViewRow(int rowIndex) {
        return this.getModelRow(this.convertRowIndexToModel(rowIndex));
    }

    public List<T> getSelectedItems() {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        ArrayList<T> itemList = new ArrayList<T>();
        for (int i : rows) {
            itemList.add(this.getViewRow(i));
        }
        return itemList;
    }

    public T getSelectedItem() {
        int rowIndex = this.getSelectedRow();
        if (rowIndex == -1) {
            return null;
        }
        return this.getViewRow(rowIndex);
    }

    public List<T> getData() {
        if (((ListModel)this.model).data == null) {
            return null;
        }
        return Collections.unmodifiableList(((ListModel)this.model).data);
    }

    public boolean setSelectedItem(T item) {
        int selectionIndex = -1;
        for (int i = 0; i < ((ListModel)this.model).data.size(); ++i) {
            Object rowItem = ((ListModel)this.model).data.get(i);
            if (this.itemComparator == null) {
                if (!rowItem.equals(item)) continue;
                selectionIndex = i;
                break;
            }
            if (this.itemComparator.compare(item, rowItem) != 0) continue;
            selectionIndex = i;
            break;
        }
        if (selectionIndex != -1) {
            selectionIndex = this.convertRowIndexToView(selectionIndex);
        }
        if (selectionIndex == -1) {
            this.getSelectionModel().clearSelection();
            return false;
        }
        this.setRowSelectionInterval(selectionIndex, selectionIndex);
        return true;
    }

    public void setData(List<T> data, boolean sort) {
        T oldSelection = this.getSelectedItem();
        this.model.setData(data);
        this.adjuster.adjustColumns();
        if (!sort) {
            return;
        }
        if (this.sortKeys.isEmpty()) {
            this.sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            this.sorter.setSortKeys(this.sortKeys);
        }
        this.sorter.sort();
        if (oldSelection != null) {
            this.setSelectedItem(oldSelection);
        }
    }

    public void setColumnVisible(ListTableColumn column, boolean visible) {
        this.model.setVisible(column, visible);
    }

    public TableRowSorter<ListModel<T>> getRowSorter() {
        return this.sorter;
    }

    @Override
    public ListModel<T> getModel() {
        return this.model;
    }

    public void setValueAt(Object newValue, T row, ListTableColumn column) {
    }

    public Component prepareRenderHook(Component component, T row, ListTableColumn listTableColumn, boolean isSelected) {
        return component;
    }

    public Object modelValueToDisplayFormat(Object value, ListTableColumn column) {
        return value;
    }

    @Override
    public final Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        T item = this.getViewRow(row);
        if (c != null && item != null) {
            c = this.prepareRenderHook(c, item, this.model.getColumn(this.convertColumnIndexToModel(column)), this.isRowSelected(row));
        }
        return c;
    }

    public static class ListTableColumn {
        public final boolean isEditable;
        public final Class<?> colClass;
        public final String colName;
        public final Comparator<?> sortComparator;

        public ListTableColumn(String colName) {
            this(colName, String.class, null);
        }

        public ListTableColumn(String colName, Class<?> colClass) {
            this(colName, colClass, null);
        }

        public ListTableColumn(String colName, Class<?> colClass, Comparator<?> sortComparator) {
            this(colName, colClass, sortComparator, false);
        }

        public ListTableColumn(String colName, Class<?> colClass, Comparator<?> sortComparator, boolean isEditable) {
            this.isEditable = isEditable;
            this.colName = colName;
            this.colClass = colClass;
            this.sortComparator = sortComparator;
        }

        public ListTableColumn(String colName, Comparator<?> sortComparator) {
            this(colName, String.class, sortComparator);
        }
    }

    private class IconRenderer
    extends DefaultTableCellRenderer {
        private IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = ListTable.this.modelValueToDisplayFormat(value, ListTable.this.model.getColumn(ListTable.this.convertColumnIndexToModel(column)));
            }
            this.setIcon((Icon)value);
            return this;
        }
    }

    private class ListTableRenderer
    extends DefaultTableCellRenderer {
        public ListTableRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
            this.putClientProperty("html", null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                value = ListTable.this.modelValueToDisplayFormat(value, ListTable.this.model.getColumn(ListTable.this.convertColumnIndexToModel(column)));
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(null);
            return this;
        }
    }

    public static class ListModel<T>
    extends AbstractTableModel {
        private final ColumnState[] columns;
        private ArrayList<T> data = null;
        private final ListTable<T> table;

        public ListModel(ListTable<T> table, ListTableColumn ... columns) {
            this.table = table;
            this.columns = new ColumnState[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                this.columns[i] = new ColumnState(columns[i]);
            }
        }

        public void setData(List<T> list) {
            this.data = new ArrayList<T>(list);
            this.fireTableDataChanged();
        }

        public ListTableColumn getColumn(int modelColumnIndex) {
            return this.columns[modelColumnIndex].column;
        }

        public void setVisible(ListTableColumn column, boolean visible) {
            TableColumnModel cm = this.table.getColumnModel();
            for (int i = 0; i < this.columns.length; ++i) {
                ColumnState c = this.columns[i];
                if (c.column != column) continue;
                if (c.hiddenColumn == null && visible || c.hiddenColumn != null && !visible) {
                    return;
                }
                if (visible) {
                    cm.addColumn(c.hiddenColumn);
                    cm.moveColumn(cm.getColumnCount() - 1, c.oldIndex);
                    c.hiddenColumn = null;
                    break;
                }
                c.oldIndex = this.table.convertColumnIndexToView(i);
                c.hiddenColumn = cm.getColumn(c.oldIndex);
                cm.removeColumn(c.hiddenColumn);
                break;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this.columns[col].column.isEditable;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (this.isCellEditable(row, col)) {
                T item = this.table.getModelRow(row);
                if (item == null) {
                    return;
                }
                this.table.setValueAt(aValue, item, this.columns[col].column);
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columns[col].column.colName;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.columns[col].column.colClass;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            T item = this.table.getModelRow(rowIndex);
            if (item == null) {
                return null;
            }
            return this.table.getValueAtInternal(item, this.columns[columnIndex].column);
        }

        public T getModelRow(int rowIndex) {
            return this.table.getModelRow(rowIndex);
        }

        private static class ColumnState {
            int oldIndex;
            final ListTableColumn column;
            TableColumn hiddenColumn = null;

            ColumnState(ListTableColumn column) {
                this.column = column;
            }
        }
    }
}

