/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.filetransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.TInvalidTokenException;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.bwlp.thrift.iface.TransferStatus;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferTask;
import org.openslx.filetransfer.Transfer;
import org.openslx.filetransfer.UploadStatusCallback;
import org.openslx.filetransfer.Uploader;
import org.openslx.thrifthelper.ThriftManager;

public class UploadTask
extends TransferTask {
    private static final Logger LOGGER = Logger.getLogger(UploadTask.class);
    private static final double THRIFT_INTERVAL_SECONDS = 1.7;
    private static final int THRIFT_INTERVAL_MS = 1700;
    private final String host;
    private final int port;
    private final String uploadToken;
    private final long startTime;
    private String remoteError = null;
    private static AtomicInteger numConnections = new AtomicInteger();
    private long lastThriftUpdate = 0L;
    private long virtualSpeed = 0L;

    public static int getNumberOfUploads() {
        return numConnections.get();
    }

    public UploadTask(String host, int port, String uploadToken, File uploadFile) throws FileNotFoundException {
        super(uploadFile, uploadFile.length());
        if (!uploadFile.canRead()) {
            throw new FileNotFoundException();
        }
        this.host = host;
        this.port = port;
        this.uploadToken = uploadToken;
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TransferEvent getTransferEvent() {
        long now = System.currentTimeMillis();
        TransferState state = null;
        byte[] blocks = null;
        String error = null;
        if (this.lastThriftUpdate + 1700L < now) {
            this.lastThriftUpdate = now;
            try {
                TransferStatus uploadStatus = ThriftManager.getSatClient().queryUploadStatus(this.uploadToken);
                state = uploadStatus.getState();
                blocks = uploadStatus.getBlockStatus();
            }
            catch (TInvalidTokenException e) {
                error = "Upload token unknown!?";
                state = TransferState.ERROR;
            }
            catch (TException e) {
                error = "Exception quering upload status: " + e.toString();
            }
        }
        long speed = 0L;
        long timeRemaining = 0L;
        List list = this.transfers;
        synchronized (list) {
            for (TransferTask.TransferThread thread : this.transfers) {
                speed += thread.getCurrentSpeed();
            }
        }
        if (speed != 0L && blocks != null) {
            int missing = 0;
            for (Object b : (Object)blocks) {
                if (b == false) continue;
                ++missing;
            }
            long bytesRemaining = 0x1000000L * (long)missing;
            timeRemaining = 1000L * bytesRemaining / (speed + 1L);
            this.virtualSpeed = (long)(blocks.length - missing) * 0x1000000L * 1000L / (System.currentTimeMillis() - this.startTime + 1L);
        }
        if (this.remoteError != null && (error == null || this.remoteError.equals("Out of disk space"))) {
            error = this.remoteError;
        }
        TransferEvent event = new TransferEvent(state, blocks, speed, this.virtualSpeed, timeRemaining, error);
        return event;
    }

    @Override
    protected TransferTask.TransferThread createNewThread() {
        return new UploadThread();
    }

    private class UploadThread
    extends TransferTask.TransferThread {
        private long currentSpeed = 0L;
        private Uploader uploader = null;

        private UploadThread() {
        }

        @Override
        public void run() {
            numConnections.incrementAndGet();
            try {
                this.run2();
            }
            finally {
                numConnections.decrementAndGet();
            }
        }

        public void run2() {
            try {
                this.uploader = new Uploader(UploadTask.this.host, UploadTask.this.port, 20000, null, UploadTask.this.uploadToken);
            }
            catch (Exception e) {
                LOGGER.warn("Could not initialize new uploader", e);
                UploadTask.this.consecutiveInitFails.incrementAndGet();
                UploadTask.this.connectFailed(this);
                return;
            }
            UploadTask.this.connectSucceeded(this);
            final UploadThread thread = this;
            boolean ret = this.uploader.upload(UploadTask.this.localFile.getAbsolutePath(), new UploadStatusCallback(){
                private long currentBytes = 0L;
                private long lastUpdate = 0L;
                private long lastBytes = 0L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void uploadProgress(long bytesSent) {
                    this.currentBytes += bytesSent;
                    long now = System.currentTimeMillis();
                    if (this.lastUpdate + 600L < now) {
                        UploadThread uploadThread = thread;
                        synchronized (uploadThread) {
                            this.lastBytes = (this.lastBytes * 2L + this.currentBytes) / 3L;
                            UploadThread.this.currentSpeed = 1000L * this.lastBytes / (now - this.lastUpdate);
                            this.lastUpdate = now;
                        }
                        this.currentBytes = 0L;
                    }
                }

                @Override
                public void uploadError(String message) {
                    UploadTask.this.fireErrorMessage(message);
                }
            });
            if (ret) {
                UploadTask.this.remoteError = null;
                UploadTask.this.consecutiveInitFails.set(0);
            } else {
                String err = this.uploader.getRemoteError();
                if (err != null) {
                    UploadTask.this.remoteError = err;
                }
                UploadTask.this.consecutiveInitFails.incrementAndGet();
            }
            UploadTask.this.transferEnded(this, ret);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentSpeed() {
            UploadThread uploadThread = this;
            synchronized (uploadThread) {
                return this.currentSpeed;
            }
        }

        @Override
        protected Transfer getTransfer() {
            return this.uploader;
        }
    }
}

