/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdatepicker.ComponentColorDefaults;
import org.jdatepicker.ComponentFormatDefaults;
import org.jdatepicker.ComponentIconDefaults;
import org.jdatepicker.ComponentTextDefaults;
import org.jdatepicker.DateModel;
import org.jdatepicker.DatePanel;
import org.jdatepicker.SqlDateModel;
import org.jdatepicker.UtilCalendarModel;
import org.jdatepicker.UtilDateModel;
import org.jdatepicker.constraints.DateSelectionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDatePanel
extends JComponent
implements DatePanel {
    private static final long serialVersionUID = -2299249311312882915L;
    private Set<ActionListener> actionListeners = new HashSet<ActionListener>();
    private Set<DateSelectionConstraint> dateConstraints = new HashSet<DateSelectionConstraint>();
    private boolean showYearButtons = false;
    private boolean doubleClickAction = false;
    private int firstDayOfWeek = Calendar.getInstance().getFirstDayOfWeek();
    private InternalCalendarModel internalModel;
    private InternalController internalController;
    private InternalView internalView;

    public JDatePanel() {
        this(JDatePanel.createModel());
    }

    public JDatePanel(Calendar value) {
        this(JDatePanel.createModelFromValue(value));
    }

    public JDatePanel(java.util.Date value) {
        this(JDatePanel.createModelFromValue(value));
    }

    public JDatePanel(Date value) {
        this(JDatePanel.createModelFromValue(value));
    }

    public JDatePanel(DateModel<?> model) {
        this.internalModel = new InternalCalendarModel(model);
        this.internalController = new InternalController();
        this.internalView = new InternalView();
        this.setLayout(new GridLayout(1, 1));
        this.add(this.internalView);
    }

    public static DateModel<Calendar> createModel() {
        return new UtilCalendarModel();
    }

    private static DateModel<Calendar> createModel(Calendar value) {
        return new UtilCalendarModel(value);
    }

    private static DateModel<?> createModelFromValue(Object value) {
        if (value instanceof Calendar) {
            return new UtilCalendarModel((Calendar)value);
        }
        if (value instanceof java.util.Date) {
            return new UtilDateModel((java.util.Date)value);
        }
        if (value instanceof Date) {
            return new SqlDateModel((Date)value);
        }
        throw new IllegalArgumentException("No model could be constructed from the initial value object.");
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, "Date selected"));
        }
    }

    @Override
    public void setShowYearButtons(boolean showYearButtons) {
        this.showYearButtons = showYearButtons;
        this.internalView.updateShowYearButtons();
    }

    @Override
    public boolean isShowYearButtons() {
        return this.showYearButtons;
    }

    @Override
    public void setDoubleClickAction(boolean doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    @Override
    public boolean isDoubleClickAction() {
        return this.doubleClickAction;
    }

    @Override
    public DateModel<?> getModel() {
        return this.internalModel.getModel();
    }

    @Override
    public void addDateSelectionConstraint(DateSelectionConstraint constraint) {
        this.dateConstraints.add(constraint);
    }

    @Override
    public void removeDateSelectionConstraint(DateSelectionConstraint constraint) {
        this.dateConstraints.remove(constraint);
    }

    @Override
    public void removeAllDateSelectionConstraints() {
        this.dateConstraints.clear();
    }

    @Override
    public Set<DateSelectionConstraint> getDateSelectionConstraints() {
        return Collections.unmodifiableSet(this.dateConstraints);
    }

    protected boolean checkConstraints(DateModel<?> model) {
        for (DateSelectionConstraint constraint : this.dateConstraints) {
            if (constraint.isValidSelection(model)) continue;
            return false;
        }
        return true;
    }

    private static ComponentTextDefaults getTexts() {
        return ComponentTextDefaults.getInstance();
    }

    private static ComponentIconDefaults getIcons() {
        return ComponentIconDefaults.getInstance();
    }

    private static ComponentColorDefaults getColors() {
        return ComponentColorDefaults.getInstance();
    }

    private static ComponentFormatDefaults getFormats() {
        return ComponentFormatDefaults.getInstance();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.internalView.updateTodayLabel();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.internalView.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InternalCalendarModel
    implements TableModel,
    SpinnerModel,
    ChangeListener {
        private DateModel<?> model;
        private Set<ChangeListener> spinnerChangeListeners = new HashSet<ChangeListener>();
        private Set<TableModelListener> tableModelListeners = new HashSet<TableModelListener>();
        private int[] lookup = null;

        public InternalCalendarModel(DateModel<?> model) {
            this.model = model;
            model.addChangeListener(this);
        }

        public DateModel<?> getModel() {
            return this.model;
        }

        @Override
        public void addChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.add(arg0);
        }

        @Override
        public void removeChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.remove(arg0);
        }

        @Override
        public Object getNextValue() {
            return Integer.toString(this.model.getYear() + 1);
        }

        @Override
        public Object getPreviousValue() {
            return Integer.toString(this.model.getYear() - 1);
        }

        @Override
        public void setValue(Object text) {
            String year = (String)text;
            this.model.setYear(Integer.parseInt(year));
        }

        @Override
        public Object getValue() {
            return Integer.toString(this.model.getYear());
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.add(arg0);
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.remove(arg0);
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            ComponentTextDefaults.Key key = ComponentTextDefaults.Key.getDowKey((JDatePanel.this.firstDayOfWeek - 1 + columnIndex) % 7);
            return JDatePanel.getTexts().getText(key);
        }

        private int[] lookup() {
            if (this.lookup == null) {
                this.lookup = new int[8];
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek - 1) % 7] = 0;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 0) % 7] = 1;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 1) % 7] = 2;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 2) % 7] = 3;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 3) % 7] = 4;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 4) % 7] = 5;
                this.lookup[(((JDatePanel)JDatePanel.this).firstDayOfWeek + 5) % 7] = 6;
            }
            return this.lookup;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int series = columnIndex + rowIndex * 7 + 1;
            Calendar firstOfMonth = Calendar.getInstance();
            firstOfMonth.set(this.model.getYear(), this.model.getMonth(), 1);
            int dowForFirst = firstOfMonth.get(7);
            int daysBefore = this.lookup()[dowForFirst - 1];
            return series - daysBefore;
        }

        public Class getColumnClass(int arg0) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public void setValueAt(Object arg0, int arg1, int arg2) {
        }

        private void fireValueChanged() {
            for (ChangeListener cl : this.spinnerChangeListeners) {
                cl.stateChanged(new ChangeEvent(this));
            }
            JDatePanel.this.internalView.updateMonthLabel();
            for (TableModelListener tl : this.tableModelListeners) {
                tl.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireValueChanged();
        }
    }

    private class InternalController
    implements ActionListener,
    MouseListener {
        private InternalController() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (!JDatePanel.this.isEnabled()) {
                return;
            }
            if (arg0.getSource() == JDatePanel.this.internalView.getNextMonthButton()) {
                JDatePanel.this.internalModel.getModel().addMonth(1);
            } else if (arg0.getSource() == JDatePanel.this.internalView.getPreviousMonthButton()) {
                JDatePanel.this.internalModel.getModel().addMonth(-1);
            } else if (arg0.getSource() == JDatePanel.this.internalView.getNextYearButton()) {
                JDatePanel.this.internalModel.getModel().addYear(1);
            } else if (arg0.getSource() == JDatePanel.this.internalView.getPreviousYearButton()) {
                JDatePanel.this.internalModel.getModel().addYear(-1);
            } else {
                for (int month = 0; month < JDatePanel.this.internalView.getMonthPopupMenuItems().length; ++month) {
                    if (arg0.getSource() != JDatePanel.this.internalView.getMonthPopupMenuItems()[month]) continue;
                    JDatePanel.this.internalModel.getModel().setMonth(month);
                }
            }
        }

        public void mousePressed(MouseEvent arg0) {
            if (!JDatePanel.this.isEnabled()) {
                return;
            }
            if (arg0.getSource() == JDatePanel.this.internalView.getMonthLabel()) {
                JDatePanel.this.internalView.getMonthPopupMenu().setLightWeightPopupEnabled(false);
                JDatePanel.this.internalView.getMonthPopupMenu().show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
            } else if (arg0.getSource() == JDatePanel.this.internalView.getTodayLabel()) {
                Calendar today = Calendar.getInstance();
                JDatePanel.this.internalModel.getModel().setDate(today.get(1), today.get(2), today.get(5));
            } else if (arg0.getSource() == JDatePanel.this.internalView.getDayTable()) {
                int row = JDatePanel.this.internalView.getDayTable().getSelectedRow();
                int col = JDatePanel.this.internalView.getDayTable().getSelectedColumn();
                if (row >= 0 && row <= 5) {
                    Integer date = (Integer)JDatePanel.this.internalModel.getValueAt(row, col);
                    int oldDay = JDatePanel.this.internalModel.getModel().getDay();
                    JDatePanel.this.internalModel.getModel().setDay(date);
                    if (!JDatePanel.this.checkConstraints(JDatePanel.this.internalModel.getModel())) {
                        JDatePanel.this.internalModel.getModel().setDay(oldDay);
                        return;
                    }
                    JDatePanel.this.internalModel.getModel().setSelected(true);
                    if (JDatePanel.this.doubleClickAction && arg0.getClickCount() == 2) {
                        JDatePanel.this.fireActionPerformed();
                    }
                    if (!JDatePanel.this.doubleClickAction) {
                        JDatePanel.this.fireActionPerformed();
                    }
                }
            } else if (arg0.getSource() == JDatePanel.this.internalView.getNoneLabel()) {
                JDatePanel.this.internalModel.getModel().setSelected(false);
                if (JDatePanel.this.doubleClickAction && arg0.getClickCount() == 2) {
                    JDatePanel.this.fireActionPerformed();
                }
                if (!JDatePanel.this.doubleClickAction) {
                    JDatePanel.this.fireActionPerformed();
                }
            }
        }

        public void mouseClicked(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private class InternalTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -2341614459632756921L;

        private InternalTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setHorizontalAlignment(0);
            if (row == -1) {
                label.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_GRID_HEADER));
                label.setBackground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID_HEADER));
                label.setHorizontalAlignment(0);
                return label;
            }
            Calendar todayCal = Calendar.getInstance();
            Calendar selectedCal = Calendar.getInstance();
            selectedCal.set(JDatePanel.this.internalModel.getModel().getYear(), JDatePanel.this.internalModel.getModel().getMonth(), JDatePanel.this.internalModel.getModel().getDay());
            int cellDayValue = (Integer)value;
            int lastDayOfMonth = selectedCal.getActualMaximum(5);
            if (cellDayValue < 1 || cellDayValue > lastDayOfMonth) {
                label.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_GRID_OTHER_MONTH));
                Calendar calForDay = Calendar.getInstance();
                calForDay.set(JDatePanel.this.internalModel.getModel().getYear(), JDatePanel.this.internalModel.getModel().getMonth(), cellDayValue);
                UtilCalendarModel modelForDay = new UtilCalendarModel(calForDay);
                label.setBackground(JDatePanel.this.checkConstraints(modelForDay) ? JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID) : JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID_NOT_SELECTABLE));
                if (cellDayValue > lastDayOfMonth) {
                    label.setText(Integer.toString(cellDayValue - lastDayOfMonth));
                } else {
                    GregorianCalendar lastMonth = new GregorianCalendar();
                    lastMonth.set(selectedCal.get(1), selectedCal.get(2) - 1, 1);
                    int lastDayLastMonth = ((Calendar)lastMonth).getActualMaximum(5);
                    label.setText(Integer.toString(lastDayLastMonth + cellDayValue));
                }
            } else {
                label.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_GRID_THIS_MONTH));
                Calendar calForDay = Calendar.getInstance();
                calForDay.set(JDatePanel.this.internalModel.getModel().getYear(), JDatePanel.this.internalModel.getModel().getMonth(), cellDayValue);
                UtilCalendarModel modelForDay = new UtilCalendarModel(calForDay);
                label.setBackground(JDatePanel.this.checkConstraints(modelForDay) ? JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID) : JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID_NOT_SELECTABLE));
                if (todayCal.get(5) == cellDayValue && todayCal.get(2) == JDatePanel.this.internalModel.getModel().getMonth() && todayCal.get(1) == JDatePanel.this.internalModel.getModel().getYear()) {
                    label.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_GRID_TODAY));
                    if (JDatePanel.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                        label.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_GRID_TODAY_SELECTED));
                        label.setBackground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID_TODAY_SELECTED));
                    }
                } else if (JDatePanel.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                    label.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_GRID_SELECTED));
                    label.setBackground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID_SELECTED));
                }
            }
            return label;
        }
    }

    private class InternalView
    extends JPanel {
        private static final long serialVersionUID = -6844493839307157682L;
        private JPanel centerPanel;
        private JPanel northCenterPanel;
        private JPanel northPanel;
        private JPanel southPanel;
        private JPanel previousButtonPanel;
        private JPanel nextButtonPanel;
        private JTable dayTable;
        private JTableHeader dayTableHeader;
        private InternalTableCellRenderer dayTableCellRenderer;
        private JLabel monthLabel;
        private JLabel todayLabel;
        private JLabel noneLabel;
        private JPopupMenu monthPopupMenu;
        private JMenuItem[] monthPopupMenuItems;
        private JButton nextMonthButton;
        private JButton previousMonthButton;
        private JButton previousYearButton;
        private JButton nextYearButton;
        private JSpinner yearSpinner;

        private void updateShowYearButtons() {
            if (JDatePanel.this.showYearButtons) {
                this.getNextButtonPanel().add(this.getNextYearButton());
                this.getPreviousButtonPanel().removeAll();
                this.getPreviousButtonPanel().add(this.getPreviousYearButton());
                this.getPreviousButtonPanel().add(this.getPreviousMonthButton());
            } else {
                this.getNextButtonPanel().remove(this.getNextYearButton());
                this.getPreviousButtonPanel().remove(this.getPreviousYearButton());
            }
        }

        private void updateMonthLabel() {
            this.monthLabel.setText(JDatePanel.getTexts().getText(ComponentTextDefaults.Key.getMonthKey(JDatePanel.this.internalModel.getModel().getMonth())));
        }

        public InternalView() {
            this.initialise();
        }

        private void initialise() {
            this.setLayout(new BorderLayout());
            this.setSize(200, 180);
            this.setPreferredSize(new Dimension(200, 180));
            this.setOpaque(false);
            this.add((Component)this.getNorthPanel(), "North");
            this.add((Component)this.getSouthPanel(), "South");
            this.add((Component)this.getCenterPanel(), "Center");
        }

        private JPanel getNorthPanel() {
            if (this.northPanel == null) {
                this.northPanel = new JPanel();
                this.northPanel.setLayout(new BorderLayout());
                this.northPanel.setName("");
                this.northPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.northPanel.setBackground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_MONTH_SELECTOR));
                this.northPanel.add((Component)this.getPreviousButtonPanel(), "West");
                this.northPanel.add((Component)this.getNextButtonPanel(), "East");
                this.northPanel.add((Component)this.getNorthCenterPanel(), "Center");
            }
            return this.northPanel;
        }

        private JPanel getNorthCenterPanel() {
            if (this.northCenterPanel == null) {
                this.northCenterPanel = new JPanel();
                this.northCenterPanel.setLayout(new BorderLayout());
                this.northCenterPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                this.northCenterPanel.setOpaque(false);
                this.northCenterPanel.add((Component)this.getMonthLabel(), "Center");
                this.northCenterPanel.add((Component)this.getYearSpinner(), "East");
            }
            return this.northCenterPanel;
        }

        private JLabel getMonthLabel() {
            if (this.monthLabel == null) {
                this.monthLabel = new JLabel();
                this.monthLabel.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_MONTH_SELECTOR));
                this.monthLabel.setHorizontalAlignment(0);
                this.monthLabel.addMouseListener(JDatePanel.this.internalController);
                this.updateMonthLabel();
            }
            return this.monthLabel;
        }

        private JSpinner getYearSpinner() {
            if (this.yearSpinner == null) {
                this.yearSpinner = new JSpinner();
                this.yearSpinner.setModel(JDatePanel.this.internalModel);
            }
            return this.yearSpinner;
        }

        private JPanel getSouthPanel() {
            if (this.southPanel == null) {
                this.southPanel = new JPanel();
                this.southPanel.setLayout(new BorderLayout());
                this.southPanel.setBackground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_TODAY_SELECTOR));
                this.southPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.southPanel.add((Component)this.getTodayLabel(), "West");
                this.southPanel.add((Component)this.getNoneLabel(), "East");
            }
            return this.southPanel;
        }

        private JLabel getNoneLabel() {
            if (this.noneLabel == null) {
                this.noneLabel = new JLabel();
                this.noneLabel.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_TODAY_SELECTOR_ENABLED));
                this.noneLabel.setHorizontalAlignment(0);
                this.noneLabel.addMouseListener(JDatePanel.this.internalController);
                this.noneLabel.setIcon(JDatePanel.getIcons().getClearIcon());
            }
            return this.noneLabel;
        }

        private void updateTodayLabel() {
            Calendar now = Calendar.getInstance();
            DateFormat df = JDatePanel.getFormats().getFormat(ComponentFormatDefaults.Key.TODAY_SELECTOR);
            this.todayLabel.setText(JDatePanel.getTexts().getText(ComponentTextDefaults.Key.TODAY) + ": " + df.format(now.getTime()));
        }

        private JLabel getTodayLabel() {
            if (this.todayLabel == null) {
                this.todayLabel = new JLabel();
                this.todayLabel.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_TODAY_SELECTOR_ENABLED));
                this.todayLabel.setHorizontalAlignment(0);
                this.todayLabel.addMouseListener(JDatePanel.this.internalController);
                this.updateTodayLabel();
            }
            return this.todayLabel;
        }

        private JPanel getCenterPanel() {
            if (this.centerPanel == null) {
                this.centerPanel = new JPanel();
                this.centerPanel.setLayout(new BorderLayout());
                this.centerPanel.setOpaque(false);
                this.centerPanel.add((Component)this.getDayTableHeader(), "North");
                this.centerPanel.add((Component)this.getDayTable(), "Center");
            }
            return this.centerPanel;
        }

        private JTable getDayTable() {
            if (this.dayTable == null) {
                this.dayTable = new JTable();
                this.dayTable.setAutoResizeMode(4);
                this.dayTable.setModel(JDatePanel.this.internalModel);
                this.dayTable.setShowGrid(true);
                this.dayTable.setGridColor(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.BG_GRID));
                this.dayTable.setSelectionMode(0);
                this.dayTable.setCellSelectionEnabled(true);
                this.dayTable.setRowSelectionAllowed(true);
                this.dayTable.setFocusable(false);
                this.dayTable.addMouseListener(JDatePanel.this.internalController);
                for (int i = 0; i < 7; ++i) {
                    TableColumn column = this.dayTable.getColumnModel().getColumn(i);
                    column.setCellRenderer(this.getDayTableCellRenderer());
                }
                this.dayTable.addComponentListener(new ComponentListener(){

                    public void componentResized(ComponentEvent e) {
                        double w = e.getComponent().getSize().getWidth();
                        double h = e.getComponent().getSize().getHeight();
                        float sw = (float)Math.floor(w / 16.0);
                        float sh = (float)Math.floor(h / 8.0);
                        InternalView.this.dayTable.setFont(InternalView.this.dayTable.getFont().deriveFont(Math.min(sw, sh)));
                        int r = (int)Math.floor(h / 6.0);
                        InternalView.this.dayTable.setRowHeight(r);
                    }

                    public void componentMoved(ComponentEvent e) {
                    }

                    public void componentShown(ComponentEvent e) {
                    }

                    public void componentHidden(ComponentEvent e) {
                    }
                });
            }
            return this.dayTable;
        }

        private InternalTableCellRenderer getDayTableCellRenderer() {
            if (this.dayTableCellRenderer == null) {
                this.dayTableCellRenderer = new InternalTableCellRenderer();
            }
            return this.dayTableCellRenderer;
        }

        private JTableHeader getDayTableHeader() {
            if (this.dayTableHeader == null) {
                this.dayTableHeader = this.getDayTable().getTableHeader();
                this.dayTableHeader.setResizingAllowed(false);
                this.dayTableHeader.setReorderingAllowed(false);
                this.dayTableHeader.setDefaultRenderer(this.getDayTableCellRenderer());
            }
            return this.dayTableHeader;
        }

        private JPanel getPreviousButtonPanel() {
            if (this.previousButtonPanel == null) {
                this.previousButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(3);
                this.previousButtonPanel.setLayout(layout);
                this.previousButtonPanel.setName("");
                this.previousButtonPanel.setOpaque(false);
                if (JDatePanel.this.isShowYearButtons()) {
                    this.previousButtonPanel.add(this.getPreviousYearButton());
                }
                this.previousButtonPanel.add(this.getPreviousMonthButton());
            }
            return this.previousButtonPanel;
        }

        private JPanel getNextButtonPanel() {
            if (this.nextButtonPanel == null) {
                this.nextButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(3);
                this.nextButtonPanel.setLayout(layout);
                this.nextButtonPanel.setName("");
                this.nextButtonPanel.setOpaque(false);
                this.nextButtonPanel.add(this.getNextMonthButton());
                if (JDatePanel.this.isShowYearButtons()) {
                    this.nextButtonPanel.add(this.getNextYearButton());
                }
            }
            return this.nextButtonPanel;
        }

        private JButton getNextMonthButton() {
            if (this.nextMonthButton == null) {
                this.nextMonthButton = new JButton();
                this.nextMonthButton.setIcon(JDatePanel.getIcons().getNextMonthIconEnabled());
                this.nextMonthButton.setDisabledIcon(JDatePanel.getIcons().getNextMonthIconDisabled());
                this.nextMonthButton.setText("");
                this.nextMonthButton.setPreferredSize(new Dimension(20, 15));
                this.nextMonthButton.setFocusable(false);
                this.nextMonthButton.setOpaque(false);
                this.nextMonthButton.addActionListener(JDatePanel.this.internalController);
                this.nextMonthButton.setToolTipText(JDatePanel.getTexts().getText(ComponentTextDefaults.Key.MONTH));
            }
            return this.nextMonthButton;
        }

        private JButton getNextYearButton() {
            if (this.nextYearButton == null) {
                this.nextYearButton = new JButton();
                this.nextYearButton.setIcon(JDatePanel.getIcons().getNextYearIconEnabled());
                this.nextYearButton.setDisabledIcon(JDatePanel.getIcons().getNextYearIconDisabled());
                this.nextYearButton.setText("");
                this.nextYearButton.setPreferredSize(new Dimension(20, 15));
                this.nextYearButton.setFocusable(false);
                this.nextYearButton.setOpaque(false);
                this.nextYearButton.addActionListener(JDatePanel.this.internalController);
                this.nextYearButton.setToolTipText(JDatePanel.getTexts().getText(ComponentTextDefaults.Key.YEAR));
            }
            return this.nextYearButton;
        }

        private JButton getPreviousMonthButton() {
            if (this.previousMonthButton == null) {
                this.previousMonthButton = new JButton();
                this.previousMonthButton.setIcon(JDatePanel.getIcons().getPreviousMonthIconEnabled());
                this.previousMonthButton.setDisabledIcon(JDatePanel.getIcons().getPreviousMonthIconDisabled());
                this.previousMonthButton.setText("");
                this.previousMonthButton.setPreferredSize(new Dimension(20, 15));
                this.previousMonthButton.setFocusable(false);
                this.previousMonthButton.setOpaque(false);
                this.previousMonthButton.addActionListener(JDatePanel.this.internalController);
                this.previousMonthButton.setToolTipText(JDatePanel.getTexts().getText(ComponentTextDefaults.Key.MONTH));
            }
            return this.previousMonthButton;
        }

        private JButton getPreviousYearButton() {
            if (this.previousYearButton == null) {
                this.previousYearButton = new JButton();
                this.previousYearButton.setIcon(JDatePanel.getIcons().getPreviousYearIconEnabled());
                this.previousYearButton.setDisabledIcon(JDatePanel.getIcons().getPreviousYearIconDisabled());
                this.previousYearButton.setText("");
                this.previousYearButton.setPreferredSize(new Dimension(20, 15));
                this.previousYearButton.setFocusable(false);
                this.previousYearButton.setOpaque(false);
                this.previousYearButton.addActionListener(JDatePanel.this.internalController);
                this.previousYearButton.setToolTipText(JDatePanel.getTexts().getText(ComponentTextDefaults.Key.YEAR));
            }
            return this.previousYearButton;
        }

        private JPopupMenu getMonthPopupMenu() {
            if (this.monthPopupMenu == null) {
                this.monthPopupMenu = new JPopupMenu();
                JMenuItem[] menuItems = this.getMonthPopupMenuItems();
                for (int i = 0; i < menuItems.length; ++i) {
                    this.monthPopupMenu.add(menuItems[i]);
                }
            }
            return this.monthPopupMenu;
        }

        private JMenuItem[] getMonthPopupMenuItems() {
            if (this.monthPopupMenuItems == null) {
                this.monthPopupMenuItems = new JMenuItem[12];
                for (int i = 0; i < 12; ++i) {
                    JMenuItem mi = new JMenuItem(JDatePanel.getTexts().getText(ComponentTextDefaults.Key.getMonthKey(i)));
                    mi.addActionListener(JDatePanel.this.internalController);
                    this.monthPopupMenuItems[i] = mi;
                }
            }
            return this.monthPopupMenuItems;
        }

        public void setEnabled(boolean enabled) {
            this.dayTable.setEnabled(enabled);
            this.dayTableCellRenderer.setEnabled(enabled);
            this.nextMonthButton.setEnabled(enabled);
            if (this.nextYearButton != null) {
                this.nextYearButton.setEnabled(enabled);
            }
            this.previousMonthButton.setEnabled(enabled);
            if (this.previousYearButton != null) {
                this.previousYearButton.setEnabled(enabled);
            }
            this.yearSpinner.setEnabled(enabled);
            if (enabled) {
                this.todayLabel.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_TODAY_SELECTOR_ENABLED));
            } else {
                this.todayLabel.setForeground(JDatePanel.getColors().getColor(ComponentColorDefaults.Key.FG_TODAY_SELECTOR_DISABLED));
            }
            super.setEnabled(enabled);
        }
    }
}

