/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.whitelist;

import com.btr.proxy.util.MiscUtil;
import com.btr.proxy.util.UriFilter;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

public class IpRangeFilter
implements UriFilter {
    private byte[] matchTo;
    int numOfBits;

    public IpRangeFilter(String matchTo) {
        String[] parts = matchTo.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("IP range is not valid:" + matchTo);
        }
        try {
            InetAddress address = InetAddress.getByName(parts[0].trim());
            this.matchTo = address.getAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("IP range is not valid:" + matchTo);
        }
        this.numOfBits = MiscUtil.parseInt(parts[1].trim());
    }

    @Override
    public boolean accept(URI uri) {
        if (uri == null || uri.getHost() == null) {
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(uri.getHost());
            byte[] addr = address.getAddress();
            if (addr.length != this.matchTo.length) {
                return false;
            }
            int bit = 0;
            for (int nibble = 0; nibble < addr.length; ++nibble) {
                for (int nibblePos = 7; nibblePos >= 0; --nibblePos) {
                    int mask = 1 << nibblePos;
                    if ((this.matchTo[nibble] & mask) != (addr[nibble] & mask)) {
                        return false;
                    }
                    if (++bit < this.numOfBits) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }
}

